/** 
 * @file sunDiscV.glsl
 *
  * $LicenseInfo:firstyear=2007&license=viewerlgpl$
 * Second Life Viewer Source Code
 * Copyright (C) 2007, Linden Research, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2.1 of the License only.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * Linden Research, Inc., 945 Battery Street, San Francisco, CA  94111  USA
 * $/LicenseInfo$
 */

uniform mat4 texture_matrix0;
uniform mat4 modelview_matrix;
uniform mat4 modelview_projection_matrix;

ATTRIBUTE vec3 position;
ATTRIBUTE vec2 texcoord0;

VARYING vec2 vary_texcoord0;
VARYING float sun_fade;

void calcAtmospherics(vec3 eye_pos);

void main()
{
    //transform vertex
    vec3 offset = vec3(0, 0, 50);
    vec4 vert = vec4(position.xyz - offset, 1.0);
    vec4 pos  = modelview_projection_matrix*vert;

    sun_fade = smoothstep(0.3, 1.0, (position.z + 50) / 512.0f);

    gl_Position = pos;
    
    calcAtmospherics(pos.xyz);

    vary_texcoord0 = (texture_matrix0 * vec4(texcoord0,0,1)).xy;
}
