/** 
 * @file shadowSkinnedV.glsl
 *
 * $LicenseInfo:firstyear=2021&license=viewerlgpl$
 * Second Life Viewer Source Code
 * Copyright (C) 2007, Linden Research, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2.1 of the License only.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * Linden Research, Inc., 945 Battery Street, San Francisco, CA  94111  USA
 * $/LicenseInfo$
 */

uniform mat4 modelview_matrix;
uniform mat4 projection_matrix;

ATTRIBUTE vec3 position;

VARYING vec4 post_pos;

mat4 getObjectSkinnedTransform();

void main()
{
	//transform vertex
	mat4 mat = getObjectSkinnedTransform();
	
	mat = modelview_matrix * mat;
	vec4 pos = (mat*vec4(position.xyz, 1.0));
	pos = projection_matrix*pos;

	post_pos = pos;

#if !defined(DEPTH_CLAMP)
	gl_Position = vec4(pos.x, pos.y, pos.w*0.5, pos.w);
#else
	gl_Position = pos;
#endif

}
