/** 
 * @file treeShadowF.glsl
 *
 * $LicenseInfo:firstyear=2005&license=viewerlgpl$
 * Second Life Viewer Source Code
 * Copyright (C) 2005, Linden Research, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2.1 of the License only.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * Linden Research, Inc., 945 Battery Street, San Francisco, CA  94111  USA
 * $/LicenseInfo$
 */

/*[EXTRA_CODE_HERE]*/

#ifdef DEFINE_GL_FRAGCOLOR
out vec4 frag_color;
#else
#define frag_color gl_FragColor
#endif

uniform float minimum_alpha;

uniform sampler2D diffuseMap;

VARYING vec4 pos;
VARYING vec2 vary_texcoord0;

vec4 computeMoments(float d, float a);

void main() 
{
	float alpha = texture2D(diffuseMap, vary_texcoord0.xy).a;

	if (alpha < minimum_alpha)
	{
		discard;
	}

    frag_color = computeMoments(length(pos), 1.0);

#if !defined(DEPTH_CLAMP)
	gl_FragDepth = max(pos.z/pos.w*0.5+0.5, 0.0);
#endif

}

