/**
 * @file bumpF.glsl
 *
 * $LicenseInfo:firstyear=2007&license=viewerlgpl$
 * Second Life Viewer Source Code
 * Copyright (C) 2007, Linden Research, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2.1 of the License only.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Linden Research, Inc., 945 Battery Street, San Francisco, CA  94111  USA
 * $/LicenseInfo$
 */

out vec4 frag_color;

uniform sampler2D texture0;
uniform sampler2D texture1;

in vec2 vary_texcoord0;
in vec2 vary_texcoord1;
in vec3 vary_position;

void mirrorClip(vec3 pos);

void main()
{
    mirrorClip(vary_position);
    float tex0 = texture(texture0, vary_texcoord0.xy).a;
    float tex1 = texture(texture1, vary_texcoord1.xy).a;

    frag_color = max(vec4(tex0+(1.0-tex1)-0.5), vec4(0));
}
