// scrtip from http://wiki.secondlife.com/wiki/Text_Scroller
integer count; // Used to keep track of itterations
 
integer length; // A measure of string length
 
string text = "                   "; // Adding this creates a gap between beginning and end of text
 
integer NCC; // NoteCardCount for tracking which line to read
 
string NC; // NoteCard name
 
integer on; // Are we on or off?
 
default
{
    state_entry()
    {
        NC = llGetInventoryName(INVENTORY_NOTECARD, 0); // Establish the name of our NC
        llGetNotecardLine(NC, NCC); // Ask for the first line
    }
    dataserver(key q, string data)
    {
        if(data != EOF) // If the data is useful
        {
            text += (data + " "); // Store it
            llGetNotecardLine(NC, (++NCC)); // And get the next line
        }
        else // If not useful we are at the end of the NC
        {
            length = llStringLength(text); // Establish the length of our text
            // The number 19 is 1 less than the number of faces (2 per prim) that display text. Change that number accordingly if...
            // ...you have a larger or smaller number of prims in your object.
            llMessageLinked(-1, 0, llGetSubString("Touch start scroll.", count, (count + 19)), "5371627b-0900-49d7-8f06-17226cdffc0a");
        } // Message the display scripts that we are ready to function
    }
    timer()
    {
        if(count == length) // If we have gone full circle
        count = 0; // Start again
        llMessageLinked(-1, 0, llGetSubString(text, count, (count + 19)), "5371627b-0900-49d7-8f06-17226cdffc0a");
        ++count; // Message the display scripts with a chunk of text
    }
    touch_end(integer nd)
    {
        if(on) // Are we running?
        llSetTimerEvent(0.0); // Stop the timer
        else // No?
        llSetTimerEvent(0.15); // Start the timer
        on = (!on); // Remember what we did
    }
    changed(integer change)
    {
        if(change & CHANGED_INVENTORY) // If the inventory has changed the NC may have
        llResetScript(); // So reset the script to read the new card
    }
}