//d'Elle Tech Sync Poseball Script (Main) by Adelle Fitzgerald


//Licenced under Creative Commons Attribution-Share Alike 3.0 Unported - http://creativecommons.org/licenses/by-sa/3.0/


//You are free:

//    * to Share — to copy, distribute and transmit the work
//    * to Remix — to adapt the work

//Under the following conditions:

//    * Attribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).

//    * Share Alike — If you alter, transform, or build upon this work, you may distribute the resulting work only under the same, similar or a compatible license.

//With the understanding that:

//    * Waiver — Any of the above conditions can be waived if you get permission from the copyright holder.
//    * Public Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.
//    * Other Rights — In no way are any of the following rights affected by the license:
//          o Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;
//          o The author's moral rights;
//          o Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.
//    * Notice — For any reuse or distribution, you must make clear to others the license terms of this work. The best way to do this is with a link to this web page.

//Disclaimer

//The Commons Deed is not a license. It is simply a handy reference for understanding the Legal Code (the full license) — it is a human-readable expression of some of its key terms. Think of it as the user-friendly interface to the Legal Code beneath. This Deed itself has no legal value, and its contents do not appear in the actual license.

//Creative Commons is not a law firm and does not provide legal services. Distributing of, displaying of, or linking to this Commons Deed does not create an attorney-client relationship.



string animation;
string text = "Sit";
vector target = <-0.5,0,-0.4>;
vector rot = <0,-90,180>;
key otherAvie;
integer debug = FALSE;
integer reSyncTimer = 120; //Timer for auto-resync - set to 0 for disabled.

default
{
    on_rez(integer start_param)
    {
        llResetScript();
    }

    state_entry()
    {
        animation = llGetInventoryName(INVENTORY_ANIMATION, 0);
        llListen(1,"","","");
        llSetText(text,<1,1,1>,1);
        llSetAlpha(1.0,ALL_SIDES);
        llSitTarget(target,llEuler2Rot(rot*DEG_TO_RAD));
    }
   
    listen(integer channel, string name, key id, string message)
    {                 
        if(message == "show")
        {
            llSetAlpha(1.0,ALL_SIDES);
            llSetText(text,<1,1,1>,1);
            llMessageLinked(LINK_ALL_OTHERS, 0, "show", "NULL_KEY");
        }           
        if(message == "hide")
        {
            llSetAlpha(0.0,ALL_SIDES);
            llSetText("",<1,1,1>,1);
            llMessageLinked(LINK_ALL_OTHERS, 0, "hide", "NULL_KEY");
        }
        if (id == llAvatarOnSitTarget() || id == otherAvie)
        {           
            if(message == "sync")
            {
                if (debug) llSay(0,"Re-syncing main");
                llMessageLinked(LINK_ALL_OTHERS, 0, "sync", "NULL_KEY");
                llStopAnimation(animation);
                llStartAnimation(animation);
            }
        }
           
    }

    changed(integer change)
    {
        if(change & CHANGED_LINK)
        {
            key avatar = llAvatarOnSitTarget();
            if(avatar != NULL_KEY)
            {
                llRequestPermissions(avatar,PERMISSION_TRIGGER_ANIMATION);
            }
            else
            {
                if (llGetPermissionsKey() != NULL_KEY)
                {
                    llStopAnimation(animation);
                    llResetScript();
                }
            }
        }       
    }

    run_time_permissions(integer parm)
    {
        if(parm == PERMISSION_TRIGGER_ANIMATION)
        {
            llStopAnimation("sit");
            llMessageLinked(LINK_ALL_OTHERS, 0, "sync", "NULL_KEY");
            llStartAnimation(animation);
            llSetAlpha(0.0,ALL_SIDES);
            llSetText("",<1,1,1>,1);
            llSetTimerEvent(reSyncTimer);
        }
    }
    link_message(integer int,integer num,string str,key id)
    {
        if(str == "sync")
        {
            if (debug) llSay(0,"Re-syncing main");
            llStopAnimation(animation);
            llStartAnimation(animation);
        }
        else if (str == "otherAvie")
        {
            if (debug) llSay(0,"Other Avie: " + (string)id);
            otherAvie = id;
        }
    }
    timer()
    {
        if (debug) llSay(0,"Re-syncing main");
        llStopAnimation(animation);
        llMessageLinked(LINK_ALL_OTHERS, 0, "sync", "NULL_KEY");
        llStartAnimation(animation);
    }
}