//============================================================================
//                          Prim Mirroring Script Set
//                           Written by Jeffrey Gomez
//
//     Permissions Granted to Edit, Copy, Transfer, and Sell this script
//      to any user, so long as this comment set remains intact, and is 
//        granted WITHOUT ANY WARRANTY. USE AT OWN RISK. And enjoy. =]
//
//   For Instructions on Usage, Limitations, etc, see PrimPorter Mirror Code
//============================================================================

// This just parses our data into llSetPrimitiveParams. Not much to see here.
integer use_set = 0;
integer SETONE = 1;
integer SETTWO = 2;
integer SETTHREE = 3;
vector pos;
rotation rot;
vector size;
integer type;
integer holeshape;
vector cut;
float hollow;
vector twist;
vector topsize;
vector topshear;
vector dimple;
vector advancedcut;
vector taper;
float revolutions;
float radiusoffset;
float skew;
vector holesize;


default
{
    state_entry()
    {
        //llSay(0,(string)llGetPrimitiveParams([PRIM_POSITION,PRIM_ROTATION,PRIM_SIZE,PRIM_TYPE]));
        llListen(19001,"","","");
        llListen(19002,"","","");
    }
    listen(integer chan, string name, key id, string msg)
    {
        list params = llParseString2List(msg,[":"],[]);
        if(chan == 19001)
        {
            pos = (vector)llList2String(params,0);
            rot = (rotation)llList2String(params,1);
            size = (vector)llList2String(params,2);
            type = (integer)llList2String(params,3);
            if(type < 3)
            {
                use_set = SETONE;
                holeshape = (integer)llList2String(params,4);
                cut = (vector)llList2String(params,5);
                hollow = (float)llList2String(params,6);
                twist = (vector)llList2String(params,7);
                topsize = (vector)llList2String(params,8);
                topshear = (vector)llList2String(params,9);
            }
            else if(type == 3)
            {
                use_set = SETTWO;
                holeshape = (integer)llList2String(params,4);
                cut = (vector)llList2String(params,5);
                hollow = (float)llList2String(params,6);
                twist = (vector)llList2String(params,7);
                dimple = (vector)llList2String(params,8);
            }
            else if(type > 3)
            {
                use_set = SETTHREE;
                holeshape = (integer)llList2String(params,4);
                cut = (vector)llList2String(params,5);
                hollow = (float)llList2String(params,6);
                twist = (vector)llList2String(params,7);
                holesize = (vector)llList2String(params,8);
                topshear = (vector)llList2String(params,9);
                
            }
        }
        else if(chan == 19002) 
        {
            if(msg != "done")
            {
                advancedcut = (vector)llList2String(params,0);
                taper = (vector)llList2String(params,1);
                revolutions = (float)llList2String(params,2);
                radiusoffset = (float)llList2String(params,3);
                skew = (float)llList2String(params,4);
            }
            if(use_set == 1)
                llSetPrimitiveParams([PRIM_POSITION,pos,PRIM_ROTATION,rot,PRIM_SIZE,size,PRIM_TYPE,type,holeshape,cut,hollow,twist,topsize,topshear]);
            else if(use_set == 2)
                llSetPrimitiveParams([PRIM_POSITION,pos,PRIM_ROTATION,rot,PRIM_SIZE,size,PRIM_TYPE,type,holeshape,cut,hollow,twist,dimple]);
            else if(use_set == 3)
                llSetPrimitiveParams([PRIM_POSITION,pos,PRIM_ROTATION,rot,PRIM_SIZE,size,PRIM_TYPE,type,holeshape,cut,hollow,twist,holesize,topshear,advancedcut,taper,revolutions,radiusoffset,skew]);
            llRemoveInventory(llGetScriptName());
        }
    }
}