
//Where user sits in relation to object. ( <X,Y,Z> )
vector offset=<0.0,0.0,1.0>;


string anim;
key avatar;
 
default
{
    state_entry() 
    {
        llSitTarget(offset,ZERO_ROTATION);
        anim = "turn_180";
        llSetSitText("Pose");
    }
 
    changed(integer change) 
    {
        if(change & CHANGED_LINK) 
        {
            avatar = llAvatarOnSitTarget();
            if(avatar != NULL_KEY)
            {
                //SAT DOWN
                llRequestPermissions(avatar,PERMISSION_TRIGGER_ANIMATION);
                return;
            }
            else
            {
                //STOOD UP
                if (llGetPermissionsKey() != NULL_KEY)
                {
                    llStopAnimation(anim);
                }
                return;
            }
        }
        if(change & CHANGED_INVENTORY)
        {
            llResetScript(); 
        }
        if(change & CHANGED_OWNER)
        {
            llResetScript();
        }
    }
 
    run_time_permissions(integer perm)
    {
        if(perm & PERMISSION_TRIGGER_ANIMATION)
        {
            llStopAnimation("sit");
            llStartAnimation(anim);
        }
    }
}