// Default is to make the entire object change color, even if multiple prims.
// From Alicia Stella Free Scripts at http://www.aliciastella.com/modules/AMS/
integer ChangeAllPrims = TRUE; // set this to FALSE for this prim only

//-----START COLORS-----------------------------

list Pale =["Pale1",<0.90,0.88,0.85>,"Pale2",<0.85,0.83,0.80>,"Pale3",<0.80,0.78,0.75>,"Pale4",<0.89,0.81,0.78>,"Pale5",<0.87,0.76,0.73>];
list Light = ["Light1",<0.86,0.75,0.71>,"Light2",<0.84,0.71,0.67>,"Light3",<0.82,0.66,0.62>,"Light4",<0.78,0.59,0.54>, "Light5",<0.78,0.64,0.58>];
list Medium = ["Medium1",<0.75,0.57,0.47>,"Medium2",<0.71,0.51,0.40>,"Medium3",<0.69,0.50,0.355>,"Medium4",<0.60,0.44,0.33>,
    "Medium5",<0.59,0.43,0.34>];
list Tan = ["Tan1",<0.89,0.64,0.49>,"Tan2",<0.87,0.57,0.39>,"Tan3",<0.85,0.51,0.30>,"Tan4",<0.82,0.43,0.20>,
    "Tan5",<0.76,0.39,0.17>];
list Dark = ["Dark1",<0.67,0.40,0.26>,"Dark2",<0.60,0.36,0.24>,"Dark3",<0.52,0.31,0.20>, "Dark4", <0.45,0.27,0.18>,
    "Dark5",<0.37,0.22,0.15>];
list VeryDark = ["VeryDark1",<0.36,0.19,0.16>,"VeryDark2",<0.33,0.20,0.18>,"VeryDark3",<0.28,0.17,0.15>,"VeryDark4",<0.23,0.14,0.12>,
    "VeryDark5",<0.16,0.10,0.09>];
list Goth = ["White",<1,1,1>,"GothPale",<0.89,0.80,0.83>,"GothPale2",<0.78,0.74,0.70>,"GothGray",<0.66,0.66,0.66>];


//-----END COLORS-----------------------------

key toucher = NULL_KEY;
list sub_menu;
list main_menu = ["Pale", "Light", "Medium", "Tan", "Dark", "VeryDark", "Goth"];



//FUNCTIONS

//owner menu
integer menu_handler;
integer menu_channel;
menu(key user,string title,list buttons)
{
    llListenRemove(menu_handler);
    menu_channel = (integer)(llFrand(99999.0) * -1);
    menu_handler = llListen(menu_channel,"","","");
    llDialog(user,title,buttons,menu_channel);
    llSetTimerEvent(60.0);
}

default
{
    on_rez( integer sparam )
    {
        llResetScript();
    }
    
    state_entry()
    {
        //
    }
    
    touch_start(integer total_number)
    {
        toucher = llDetectedKey(0);
        menu(toucher, "\n \nSelect a color category.", main_menu);
    }

    // use link message instead of touch in case you have more menu in another script.
    //link_message(integer sender_num, integer num, string str, key id)
    //{
        //if (str == "Colors") // from main script
        //{
            //toucher = id;
            //menu(toucher, "\n \nSelect a color category.", main_menu);
        //}
    //}
    
    timer() 
    {
        llSetTimerEvent(0.0);
        llListenRemove(menu_handler);
        toucher = NULL_KEY;
    }
    
    listen(integer channel, string name, key is, string message)
    {
        if (channel == menu_channel)
        {
            llSetTimerEvent(0.0);
            llListenRemove(menu_handler);
            
            if (llListFindList(main_menu, [message]) != -1) {
            if (message == "Pale") sub_menu = Pale; 
            else if (message == "Light") sub_menu = Light;
            else if (message == "Medium") sub_menu = Medium;
            else if (message == "Tan") sub_menu = Tan;
            else if (message == "Dark") sub_menu = Dark;
            else if (message == "VeryDark") sub_menu = VeryDark;
            else if (message == "Goth") sub_menu = Goth;
           
            
            menu(toucher, "\n \nSelect a color.", llList2ListStrided(sub_menu, 0, -1, 2));
            return;  
            }
        
            integer index = llListFindList(sub_menu, [message]);
            if (index != -1)
            {
                vector color_vector = llList2Vector(sub_menu, index+1);
                if (ChangeAllPrims == TRUE)
                {
                    llSetLinkColor(1, color_vector, ALL_SIDES); //the primary prim 
                    llSetLinkColor(26, color_vector, ALL_SIDES);
                    llSetLinkColor(27, color_vector, ALL_SIDES);
                    llSetLinkColor(28, color_vector, ALL_SIDES);
                    llSetLinkColor(29, color_vector, ALL_SIDES);
                    llSetLinkColor(30, color_vector, ALL_SIDES);
                               
                }
                else
                {
                    llSetColor(color_vector, ALL_SIDES); //only prim script is in
                }
            }
        }
    }
}