//// "Flying v2" CONTROLLER TEMPLATE v1 - by Jopsy Pendragon - 5/15/2008
//// You are free to use this script as you please, so long as you include this line:
//** The original 'free' version of this script came from THE PARTICLE LABORATORY. **//

// EFFECT: used in attachments, will ACTIVATE particles when avatar flies or is in the air and
//            DEACTIVE particles when they land.

// SETUP:  Drop this CONTROLLER TEMPLATE script into any prim of the same
// linked object as your PARTICLE TEMPLATE. It should be responsive immediately.
 

string  CONTROLLER_ID = "A"; // see more about CONTROL TEMPLATES at end.

key user;
integer activators;
integer on=FALSE; // starting mode

default {
    attach( key id ) { llResetScript();}
    
    on_rez(integer n) { llResetScript();}
    
    state_entry() { 
        activators = ( 0 // comment/uncomment to customize which actions to turn particles on for.
               // | AGENT_ALWAYS_RUN    // has running ("Always Run") enabled, or is using tap-tap-hold
               // | AGENT_ATTACHMENTS   // has attachments
               // | AGENT_AWAY          // is in "away" mode
               // | AGENT_BUSY          // is in "busy" mode
               // | AGENT_CROUCHING     // is crouching
                  | AGENT_FLYING        // is flying
                  | AGENT_IN_AIR        // is in the air (hovering)
               // | AGENT_MOUSELOOK     // is in mouselook
               // | AGENT_ON_OBJECT     // is sitting on an object
               // | AGENT_SCRIPTED      // has scripted attachments
               // | AGENT_SITTING       // is sitting
               // | AGENT_TYPING        // is typing
               // | AGENT_WALKING       // is walking
            );
            
        user = llGetOwner();
        llSetTimerEvent( 1.0 );
        llMessageLinked( LINK_SET, on, CONTROLLER_ID, ""); // set on or off as defined above to start with.
    } 
    
    timer() { 
        if ( llGetAgentInfo(user) & activators ) {  // Agent is using one of the selected actions.
        
            if ( ! on ) { // start only if not already started.
                on=TRUE; 
                llMessageLinked( LINK_SET, TRUE, CONTROLLER_ID, ""); 
            } 
            
        } else  {  // user is NOT using one of the selected actions.
        
            if ( on ) { // stop only if already started.
                on=FALSE; 
                llMessageLinked( LINK_SET, FALSE, CONTROLLER_ID, ""); 
            }
            
        } 
    }
}
 
 
//========================================================================
//======================== USING CONTROL TEMPLATES =======================
//
// By default one CONTROLLER TEMPLATE will activate and deactivate all the 
// PARTICLE TEMPLATES that are in the same linked object.
//
// However, the templates will only obey or affect each other if they share
// identical CONTROLLER_ID's.
//
// If you want templates to operate independently, change the value for 
// CONTROLLER_ID so that it is the same for all templates that work together.
// (and different from all the templates that it should ignore or be ignored by)

//==================================== END ===============================
