//gimisa@yahoo.fr  corrected for OSGrid and used optimise  warp function in wiki (last version) 110702
//Teleporter Script  v 3.0 by Asira Sakai (with help from LSLWiki)
// requires a notecard in the object's inventory with target vectors and destination descriptions
// in alternating lines (or just a single line with a target vector)
// Will teleport any agent who "sits" on the object containing the script within the simulator
// Touching the object will select the next destination if there are more than one

string gName;                       // name of a notecard in the object's inventory
integer gLine = 0;                  // current line number
key gQueryID;                       // id used to identify dataserver queries
vector homeVector;               // starting vector
vector targetVector;              // vector to teleport to
vector color = <0,0,1>;          // set float text color to blue
integer listIndex;              // current index on the list
list destinations;              // the list of all destinations, strided <vector> , string
string staticText = "Teleport Cube v 3.0"; // optional custom text
string destinationText;            // the text describing the destination

//from wiki.net
warpPos(vector pos)
{
    list rules;
    integer num = llCeil(llVecDist(llGetPos(),pos)/10);
    while(num--)rules=rules+[PRIM_POSITION,pos];
    llSetPrimitiveParams(rules);
}

init()
    {
        destinations = [];          // clear out destinations
        llSetText(staticText, color, 1.0);  // set optional initial floating text
        llSetSitText("Teleport");           // change "sit" option to "Teleport"
        llSitTarget(<0.0, 0.0, 0.1>, ZERO_ROTATION); // needed for llAvatarOnSitTarget to work
        gName = llGetInventoryName(INVENTORY_NOTECARD, 0); // select the first notecard in the object's inventory
        if (gName != "")  // if a notecard is found
            gQueryID = llGetNotecardLine(gName, gLine);    // request first notecard line
        else
            llSay(0,"No location set, insert notecard with target vector in <x,y,z> format");
        if(llAvatarOnSitTarget() != NULL_KEY)   // if someone is sitting
                llUnSit(llAvatarOnSitTarget()); // unsit him 
    }

default
{
    state_entry()
    {
        init();
    }
    on_rez()
    {
        init();
    }

    touch_start(integer total_number)
    {

        if (gName != ""){
            if (gLine <= 1)  // if there is only one destination available
                llSay(0, "Right click and select Teleport to activate");
            else {
                llSay(0, "Selecting next destination, right click and select Teleport to activate");
                // get next entries from the list
                if (listIndex >= gLine)
                    listIndex = 0;
                targetVector = (vector)llList2String(destinations, listIndex); 
                listIndex += 1; 
                destinationText = llList2String(destinations, listIndex); 
                listIndex += 1;             
                llSetText(destinationText, color, 1.0);

            }
        }
        else
            llResetScript();
    }
    
    dataserver(key query_id, string data) {
        if (query_id == gQueryID) {    
            if (data != EOF) {          // if not at the end of the notecard
                destinations = destinations + data; // add the line data to the list
                gLine++;                // increase line count
                gQueryID = llGetNotecardLine(gName, gLine);    // request next line
            }
            else {  // display the loaded list to the owner
                llOwnerSay("Loaded Locations:");
                listIndex = 0;
                while (listIndex < gLine) {
                    llOwnerSay(llList2String(destinations, listIndex));
                    listIndex++;
                }
                // set up first destination
                targetVector = (vector)llList2String(destinations, 0);
                destinationText = llList2String(destinations, 1);
                if (destinationText != "")
                    llSetText(destinationText, color, 1.0);
                listIndex = 2;
            }
        }         
    }
    
    changed(integer change) {
        if (change & CHANGED_LINK){  // if a link change occurs (sit or unsit)
            if(llAvatarOnSitTarget() != NULL_KEY){  // and there is someone sitting now
                if (gName != ""){  // if there is a valid notecard loaded
                    homeVector = llGetPos();  // record current position for return
                    warpPos(targetVector);  // teleport to selected coordinates
                    llUnSit(llAvatarOnSitTarget()); // unsit him
                    warpPos(homeVector);  // teleport back to old position
                }
                else
                    llResetScript();
            }
        }
    }
}