//// "Marco" TARGET TEMPLATE v1 - by Jopsy Pendragon - 3/13/2009
//// You are free to use this script as you please, so long as you include this line:
//** The original 'free' version of this script came from THE PARTICLE LABORATORY. **//

// SETUP:  Drop and configure this TARGET TEMPLATE script into the PARTICLE EMITTING PRIM.
// It is designed to respond to the "Polo" TARGET TEMPLATE. 
// The value for LISTENER_CHANNEL must be the same in both scripts!   
// (if you have a marco/polo pair near another pair, they may confuse each other,
// give one pair a different LISTEN_CHANNEL than the other pair. =)

// The Marco/Polo targetting method is best used for child prims of DIFFERENT objects or 
// attachments to find each other.  It will also work in nearly every targeting situation,
// however it is more likely to add lag to a region than other methods.
// When possible, try to use the best targetting method for your need. =)

integer   LISTEN_CHANNEL = -234;
string          SAY_MESG = "Marco!";
string        LISTEN_FOR = "Polo!";    
integer      retry_count = 30; // give up after saying "Marco!" 30 times if no one says "Polo!".

string  CONTROLLER_ID = "A"; // see more about CONTROL TEMPLATES at end.

integer listen_handle;

default {
    on_rez(integer n) { llResetScript();}
    attach(key id) { llResetScript();}     
    touch_start(integer n) {llResetScript();}
    
    state_entry() { 
        listen_handle = llListen( LISTEN_CHANNEL, "", NULL_KEY, LISTEN_FOR );
        llSay( LISTEN_CHANNEL, SAY_MESG );  
        llSetTimerEvent(2.0);
    } 
    
    timer() {
        if ( retry_count-- < 0 ) llSetTimerEvent(0.0);
        llSay( LISTEN_CHANNEL, SAY_MESG );  
    }
    
    listen( integer chan, string name, key target_id, string mesg ) {
        if ( chan == LISTEN_CHANNEL && mesg == LISTEN_FOR ) {
            llMessageLinked( LINK_SET, 2, CONTROLLER_ID, target_id );    
            llSetTimerEvent(0.0);
        }   
    }
}


//========================================================================
//======================== USING CONTROL TEMPLATES =======================
//
//
// By default, control templates will turn EVERY particle template in the
// same object ON or OFF.  If you want particle templates to only listen
// to specific controller templates, then give both matching 
// CONTROLLER_ID's.  (something other than "A", like: "B" for example).  


//==================================== END ===============================
