//// "SetPrim" EFFECT TEMPLATE v1 - by Jopsy Pendragon - 3/16/2010
//// You are free to use this script as you please, so long as you include this line:
//** The original 'free' version of this script came from THE PARTICLE LABORATORY. **//

// WHEN TO USE THIS SCRIPT:   If you want to change the appearance of prims in your
// object when your particle effect turns on, or off, this is the script to add.
// This script updates PRIM COLOR, FULLBRIGHT, GLOW and LIGHT attributes.

// *WARNING*:  Most avatars can only see the effect of 2 lights at a time.  
// Only some avatars can see more (but only up to 6 at a time, total)
// The LIGHT attribute almost always increases rendering lag.
// Use PRIM_POINT_LIGHT in extreme moderation.  Try to use GLOW instead.

// HOW TO USE THIS SCRIPT:
//   1 Drop this script into a prim in your object.
//   2 edit the prim so its attributes are how you want them in OFF mode
//   3 touch the prim
//   4 copy and paste the output into the 'disable()' function, (overwrite the similar lines)
//   5 edit the prim and set the attributes to the way you want them in ON mode
//   6 touch it again
//   7 copy and paste the output into the 'enable()' function, (overwrite the similar lines)
//   8 uncomment (remove //'s) from the attribute lines that you want auto-changed
//   9 comment out (add //'s) the touch_start() line in the script to disable the attribute output option.
//  10 test (trigger the object's CONTROLLER TEMPLATE making it send ON and OFF signals)
//   
// Don't compile this script with [X] Mono.  Other scripts may run MUCH faster with mono, 
// but not this one.  Using Mono here would only waste region memory and contribute to lag.

integer side = ALL_SIDES; // replace with a digit to affect one side of the prim. 

string  CONTROLLER_ID = "A"; // See comments at end regarding CONTROLLERS.
integer AUTO_START = TRUE;   // TRUE=turn on when scripts reset.

enable() {
    // Information about:  LINK_ID=0,  FACE_NUMBER=0
 llSetLinkPrimitiveParams( LINK_THIS, []
     // + [ PRIM_GLOW, (0), 0.000000 ] /* (face#), glow */
     // + [ PRIM_FULLBRIGHT, (0), 0 ]  /* (face#), enable(TRUE or FALSE) */
     // + [ PRIM_COLOR, (0), <1.000000, 1.000000, 1.000000>, 1.000000 ] /* (face#), color, alpha */ 
     // + [ PRIM_POINT_LIGHT, 0, <1.000000, 1.000000, 1.000000>, 1.000000, 10.000000, 0.750000 ]
                              /* enable(TRUE or FALSE), color, intensity, radius, falloff */
    );
}

disable() {
    // Information about:  LINK_ID=0,  FACE_NUMBER=0
 llSetLinkPrimitiveParams( LINK_THIS, []
     // + [ PRIM_GLOW, (0), 0.000000 ] /* (face#), glow */
     // + [ PRIM_FULLBRIGHT, (0), 0 ]  /* (face#), enable(TRUE or FALSE) */
     // + [ PRIM_COLOR, (0), <1.000000, 1.000000, 1.000000>, 1.000000 ] /* (face#), color, alpha */ 
     // + [ PRIM_POINT_LIGHT, 0, <1.000000, 1.000000, 1.000000>, 1.000000, 10.000000, 0.750000 ]
                              /* enable(TRUE or FALSE), color, intensity, radius, falloff */
    );
}

show_me( integer face ) {
    string strface=(string)face;
    llWhisper(0,"\n// Information about:"
        +"  LINK_ID="+(string)llDetectedLinkNumber(0)
        +",  FACE_NUMBER="+(string)llDetectedTouchFace(0)+"\n"
        +" llSetLinkPrimitiveParams( LINK_THIS, []\n" 
        +"     // + [ PRIM_GLOW, (ALL_SIDES), "+(string)llGetPrimitiveParams([PRIM_GLOW,face])+" ] /* (face#), glow */\n" 
        +"     // + [ PRIM_FULLBRIGHT, (ALL_SIDES), "+(string)llGetPrimitiveParams([PRIM_FULLBRIGHT,face])+" ]  /* (face#), enable(TRUE or FALSE) */\n" 
        +"     // + [ PRIM_COLOR, (ALL_SIDES), "+llList2CSV(llGetPrimitiveParams([PRIM_COLOR,face]))+" ] /* (face#), color, alpha */ \n" 
        +"     // + [ PRIM_POINT_LIGHT, "+llList2CSV(llGetPrimitiveParams([PRIM_POINT_LIGHT]))+" ]\n"
        +"                              /* enable(TRUE or FALSE), color, intensity, radius, falloff */\n" 
        +");" );
}


default {
    touch_start(integer n) { show_me( llDetectedTouchFace(0) ); }
    
    state_entry() { 
        if ( AUTO_START ) enable();   
    } 
    
    link_message( integer sibling, integer num, string mesg, key target_key ) {
        if ( mesg != CONTROLLER_ID ) return; // this message isn't for me.  Bail out.
        
        if ( num == 0 ) enable();  // Message says to turn particles OFF:
            
        else if ( num == 1 ) disable(); // Message says to turn particles ON:   
    }
}

// for more on setting prim attributes, visit:

// http://rpgstats.com/wiki/index.php?title=LlSetPrimitiveParams
// http://wiki.secondlife.com/wiki/LlSetPrimitiveParams
// http://lslwiki.net/lslwiki/wakka.php?wakka=llSetPrimitiveParams

