//// "Timer Reset" CONTROLLER TEMPLATE v1 - by Jopsy Pendragon - 4/8/2008
//// You are free to use this script as you please, so long as you include this line:
//** The original 'free' version of this script came from THE PARTICLE LABORATORY. **//

// EFFECT: 'Touch' prim to activate particles for some number of seconds.

// SETUP:  Drop this CONTROLLER TEMPLATE script into the same object with
// your PARTICLE TEMPLATE.  It should be operational immediately.


// Adjust these values:
integer       SELF_ONLY = TRUE; // FALSE auto-stops particles turned on by other controllers.
float   AUTO_STOP_TIMER = 15.0; // seconds to wait before sending STOP signal.


string  CONTROLLER_ID = "A"; // see more about CONTROL TEMPLATES at end.
integer mode = 1; // Remember whether currently particles are on(1) or off(0).

default {
        
    timer() {
        llMessageLinked( LINK_SET, FALSE, CONTROLLER_ID, NULL_KEY ); // send command
        llSetTimerEvent( 0.0 ); // done with the timer, so disable it.
    }
           
    link_message( integer sibling, integer turn_on, string controller_id, key ignore ) {
        if ( controller_id != CONTROLLER_ID ) return; // this message is not for us.
        if ( turn_on ) {
            llSetTimerEvent( AUTO_STOP_TIMER );
        } else {
            // another controller turned particles on, set auto-stop timer!
            llSetTimerEvent( 0.0 ); // another controller turned particles off.
        }
    }
}


//========================================================================
//======================== USING CONTROL TEMPLATES =======================
//
// To use:  Drop this CONTROLLER TEMPLATE script into the same object with
// your PARTICLE TEMPLATE.  It should be operational immediately.
//
// By default, control templates will turn EVERY particle template in the
// same object ON or OFF.  If you want particle templates to only listen
// to specific controller templates, then give both matching CONTROLLER_ID's,
// (something other than "A", like: "B" for example).  


//======================================== END =============================== 
