// "Texture Anim" - Starting Template Script v1 - 12/2/2008 - Jopsy Pendragon
// This is a free sample script from THE PARTICLE LABORATORY in Teal.

// llSetTextureAnim() is an LSL FUNCTION that turns ON or OFF the prim attributes 
// that cause textures to scroll, spin, and scale.
// Some textures contain a sequence of frames arranged in a grid, this function
// can also be used to show each of those frames in rapid succession.
// You can not set or reset animation attributes without using llSetTextureAnim().

integer AUTO_START = TRUE;   // Optionally FALSE only if using CONTROLLERS.
string  CONTROLLER_ID = "A"; // Ignore ALL Linked messages that don't send this message.

flicker(integer mode) {
    if ( ! mode ) { //  Turn off Animation and set texture to a specific scale & offset
    
        llSetTextureAnim(   0 , ALL_SIDES,  0,0,   0.0, 0,   0.0  );  
        // Uncomment and set the next three lines for more control over what is seen in "OFF" mode.
        // llScaleTexture(  1.0, 1.0, ALL_SIDES);
        // llOffsetTexture( 0.0, 0.0, ALL_SIDES);
        // llRotateTexture( 0.0, ALL_SIDES );
        
    } else { // turn ON the texture animation
    
        // Look for the "Texture Animation Helper" device in the particle lab! =) -- Jopsy
        
        llSetTextureAnim( // a FUNCTION that requires the following PARAMETER list:
                    (0 // option list:  use // to disable any you do not want.  
                        | ANIM_ON   // Disable this line to turn off animations.
                        | LOOP      // repeat animation over and over. - almost always needed
                     // | REVERSE   // animate in opposite direction.
                        | PING_PONG // reverses completed animation back to starting point
                        | SMOOTH    // disables flip-book style 'frames' animation
                        | ROTATE    // spins texture instead of offsetting it
                     // | SCALE     // zoom/shrinks texture instead of offsetting it.
                    ),
                ALL_SIDES,    // One face number or ALL_SIDES. 0=top, 1=side, 2=bottom,... depending on shape.
                1,1,  // Grid Size, for 'frames' style animation, X frames wide, by Y Frames tall.
                0.0,  // START: first frame, or first offset, scale or rotation angle.
                TWO_PI, // LENGTH: # of frames to show, distance to offset or scale, use TWO_PI for ROTATE!
                0.9   // "frames per second" smaller = slower
            ); // End of the PARAMETER list for the llSetTextureAnim() FUNCTION.
    }
}

default {  

    state_entry() { flicker( AUTO_START ); }  
        
    link_message( integer sibling, integer mode, string message, key target_key ) {
        
        if ( message != CONTROLLER_ID )  return; // this message isn't for me.  Bail out.   
         
        flicker(mode);  
    }
 
}  
 
