//// "Listening v2" TARGET TEMPLATE v1 - by Jopsy Pendragon - 4/8/2008
//// You are free to use this script as you please, so long as you include this line:
//** The original 'free' version of this script came from THE PARTICLE LABORATORY. **//

// PURPOSE:  This script Listens for another PRIM to speak... and then targets that
// prim with particles.    DO NOT CONFUSE THIS SCRIPT WITH THE "Listening" CONTROLLER TEMPLATE!

// SETUP:  Drop and configure this TARGET TEMPLATE script into the same object with
// your PARTICLE TEMPLATE.  It should be operational immediately.
// Drop and Configure the matching "Speaking" TARGET TEMPLATE into the target
// prim.  Make sure to check the [ ] Running checkbox on this script.
// Enable PSYS_PART_TARGET_POS_MASK in your PARTICLE TEMPLATE or this will not work.

// The Listen/Speaking targeting method is best used when you are trying to target
// an attachment or a child prim of an object not linked to the particle emitter.

// If mis-used Listen/Speaking target templates can cause more lag than other methods.
// Try to use the most appropriate targetting method rather than always using this one.

// USAGE: Type /1 on (to start particles) and /1 off (to disable them) 
 
// Customize these options.  Set the same in the matching "Speaking" TARGET TEMPLATE.
integer LISTENER_CHANNEL = 1;
string     SHARED_SECRET = "target me!";
float      GIVE_UP_TIMER = 360.0; // give up waiting for target after 360 seconds.
    // timer resets when object is rezzed, (un)linked, attached or touched

string  CONTROLLER_ID = "A"; // see more about CONTROL TEMPLATES at end.

integer listen_handle;

default {
    on_rez(integer n) { llResetScript();}
    touch_start(integer n) {llResetScript();}
    attach(key id) { llResetScript();}
    changed(integer n) { if ( n & CHANGED_LINK ) llResetScript();}
    
    state_entry() { 
        listen_handle = llListen( LISTENER_CHANNEL, "", NULL_KEY, "" );
        llSetTimerEvent( GIVE_UP_TIMER );
    }
    
    timer() { 
        llListenRemove(listen_handle);
        llSetTimerEvent(0.0);
    }
    
    listen( integer chan, string name, key target_id, string mesg ) {
        if ( mesg == SHARED_SECRET && llGetOwnerKey(target_id) == llGetOwner() ) {
            llMessageLinked( LINK_SET, 2, CONTROLLER_ID, target_id );  
            llListenRemove(listen_handle);
            llSetTimerEvent(0.0);
        }   
    }
}


//========================================================================
//======================== USING CONTROL TEMPLATES =======================
//
//
// By default, control templates will turn EVERY particle template in the
// same object ON or OFF.  If you want particle templates to only listen
// to specific controller templates, then give both matching 
// CONTROLLER_ID's.  (something other than "A", like: "B" for example).  


//==================================== END ===============================
