//// "Glow" PARTICLE TEMPLATE v1 - by Jopsy Pendragon - 4/8/2008
//// You are free to use this script as you please, so long as you include this line:
//** The original 'free' version of this script came from THE PARTICLE LABORATORY. **//

// SETUP:  Drop one optional particle texture and this script into a prim.
// Particles should start automatically. (Reset) the script if you insert a
// particle texture later on.  Add one or more CONTROLLER TEMPLATES to any
// prims in the linked object to control when particles turn ON and OFF.

// Customize the particle_parameter values below to create your unique 
// particle effect and click SAVE.  Values are explained along with their
// min/max and default values further down in this script.


list known_asset_keys=[  ]; // add your particle texture ASSET UUID KEYS uuid keys here, like:
                            // list known_asset_keys = [ "55555555-5555-5555-5555-555555555555", "..." ];
                            // textures found in prim contents will be appended to the list below.
integer ADD_CONTENTS = TRUE; // set to false to ignore textures in contents.
integer RANDOMIZE = FALSE; // set to false to cycle through texture in order.
float   UPDATE_INTERVAL = 1.0; // # of seconds to wait before changing particle textures

string  CONTROLLER_ID = "A"; // See comments at end regarding CONTROLLERS.
integer AUTO_START = TRUE;   // Optionally FALSE only if using CONTROLLERS.

integer num_textures; // # of textures in contents
list known_textures;  // names found of textures in contents
integer current_texture; // tracks current texture when in sequential(non-random) mode.
list particle_parameters=[]; // stores your custom particle effect, defined below.
list target_parameters=[]; // remembers targets found using TARGET TEMPLATE scripts.
                            
get_texture_names() {
    integer i;  
    known_textures = known_asset_keys;
    num_textures = llGetInventoryNumber( INVENTORY_TEXTURE );
    if ( ADD_CONTENTS ) {
        for (i=0; i < num_textures; i++ )
            known_textures += [ llGetInventoryName( INVENTORY_TEXTURE, i ) ];  
        num_textures += llGetListLength( known_asset_keys );
    }
    
    if ( ! RANDOMIZE && current_texture > num_textures ) current_texture = num_textures;
}

list pick_texture() {
    if ( RANDOMIZE ) 
        return( [ PSYS_SRC_TEXTURE, 
                llList2String( known_textures, (integer)llFrand(llGetListLength(known_textures) ) ) ] );
    else {
        if ( num_textures ) current_texture = ( current_texture + 1 ) % num_textures;
        return( [ PSYS_SRC_TEXTURE, llList2String( known_textures, current_texture ) ] );
    }
}

default { 
    changed(integer change_type ) {
        if ( ADD_CONTENTS && (change_type & CHANGED_INVENTORY) ) get_texture_names();
    }
    
    state_entry() {             
        get_texture_names();
        
        particle_parameters = [  // start of particle settings
           // Texture Parameters:
           //PSYS_SRC_TEXTURE, llGetInventoryName(INVENTORY_TEXTURE, 0),
           PSYS_PART_START_SCALE, <0.25, 0.25, FALSE>, PSYS_PART_END_SCALE, <0.25, 0.25, FALSE>, 
           PSYS_PART_START_COLOR, <1.00,1.00,1.00>,    PSYS_PART_END_COLOR, <1.00,1.00,1.00>, 
           PSYS_PART_START_ALPHA, (float) 1.,         PSYS_PART_END_ALPHA, (float) 0.0,     
           
           // Production Parameters:
           PSYS_SRC_BURST_PART_COUNT, (integer)    1, 
           PSYS_SRC_BURST_RATE,         (float) 0.05,  
           PSYS_PART_MAX_AGE,           (float) 0.75, 
        // PSYS_SRC_MAX_AGE,            (float)  0.00, 
            
           // Placement Parameters:
           PSYS_SRC_PATTERN, (integer) 4, // 1=DROP, 2=EXPLODE, 4=ANGLE, 8=CONE,
           
           // Placement Parameters (for any non-DROP pattern):
           PSYS_SRC_BURST_SPEED_MIN, (float)  0.01,   PSYS_SRC_BURST_SPEED_MAX, (float) 00.01, 
           PSYS_SRC_BURST_RADIUS, (float)  .5,
           
           // Placement Parameters (only for ANGLE & CONE patterns):
           PSYS_SRC_ANGLE_BEGIN, (float) 0.0 * PI,   PSYS_SRC_ANGLE_END, (float)  .00 * PI,  
           PSYS_SRC_OMEGA, <10.00, 0.00, 00.00>,  
           
           // After-Effect & Influence Parameters:
        // PSYS_SRC_ACCEL, < 00.00, 00.00, 00.0>,
        // PSYS_SRC_TARGET_KEY, (key) llGetLinkKey(llGetLinkNum() + 1), 
                   
           PSYS_PART_FLAGS, (integer) ( 0                  // Texture Options:     
                                | PSYS_PART_INTERP_COLOR_MASK   
                                | PSYS_PART_INTERP_SCALE_MASK   
                                | PSYS_PART_EMISSIVE_MASK   
                             // | PSYS_PART_FOLLOW_VELOCITY_MASK
                                                  // After-effect & Influence Options:
                             // | PSYS_PART_WIND_MASK            
                             // | PSYS_PART_BOUNCE_MASK          
                             // | PSYS_PART_FOLLOW_SRC_MASK     
                             // | PSYS_PART_TARGET_POS_MASK     
                             // | PSYS_PART_TARGET_LINEAR_MASK    
                            ) 
            //end of particle settings                     
        ];
        
        if ( AUTO_START ) {
            llParticleSystem( particle_parameters  + pick_texture() );       
            llSetTimerEvent(1.0);
        }
        
    }
    
    link_message( integer sibling, integer num, string mesg, key target_key ) {
        if ( mesg != CONTROLLER_ID ) { // this message isn't for me.  Bail out.
            return;
        } else if ( num == 0 ) { // Message says to turn particles OFF:
            llParticleSystem( [ ] );
            llSetTimerEvent(0.0);
        } else if ( num == 1 ) { // Message says to turn particles ON:
            llParticleSystem( particle_parameters + pick_texture() );
            llSetTimerEvent(1.0);
        } else if ( num == 2 ) { // Turn on, and remember and use the key sent us as a target:
            target_parameters = [ PSYS_SRC_TARGET_KEY, target_key ];
            llParticleSystem( particle_parameters + target_parameters + pick_texture() );
        } else { // bad instruction number
            // do nothing.
        }            
    }
    
    timer() {
            llParticleSystem( particle_parameters + target_parameters + pick_texture() );
    }
        
}

//== END ===============================
