//// "Online Sensor" CONTROLLER TEMPLATE v1 - by Jopsy Pendragon - 4/8/2008
//// You are free to use this script as you please, so long as you include this line:
//** The original 'free' version of this script came from THE PARTICLE LABORATORY. **//

// EFFECT: Checks owner's login status once a minute, activates particles if online.

// WARNING: Continuous 'Sensors' like this each add a little lag to SecondLife.
// Be a good citizen and keep the number of objects you use this sensor in to a minimum.

// SETUP:  Drop this CONTROLLER TEMPLATE script into the same object with
// your PARTICLE TEMPLATE.  You may have to check the [X] Running checkbox
// at the bottom of this script window for it to start.



integer SHOW_HOVERTEXT = TRUE; // Set to FALSE for no hovertext.

string  CONTROLLER_ID = "A"; // see more about CONTROL TEMPLATES at end.

string owner_name;
integer last_check=-1;

default {    
    state_entry() {
        if ( llGetCreator() == llGetOwner() ) 
        llRequestAgentData( llGetOwner(), DATA_NAME ); // get owner's name.
    }    
    
    dataserver(key req, string data) {    
        owner_name = data;  
        state monitoring; // name retrieved, start checking online status.
    }
}

state monitoring {    
    on_rez(integer n) { llResetScript(); }
    
    // Don't be a lagtard!  Checking more often than every 60 seconds is unnecessary.
    state_entry() { llSetTimerEvent(60.0); }     
    
    timer() { llRequestAgentData( llGetOwner(), DATA_ONLINE ); }
    
    dataserver(key req, string data) { 
        integer check = (integer) data;
        
        if ( check != last_check ) {
            last_check = check;
            // this avoids unnecessary re-starting or re-stopping of particles.
            if ( check == 1 ) {
                if ( SHOW_HOVERTEXT ) llSetText(owner_name + "\nis online",<0,1,0>,1.0); 
                llMessageLinked( LINK_SET, TRUE, CONTROLLER_ID, NULL_KEY ); // send command
            } else {
                if ( SHOW_HOVERTEXT ) llSetText(owner_name + "\nis offline",<1,0,0>,1.0);
                llMessageLinked( LINK_SET, FALSE, CONTROLLER_ID, NULL_KEY ); // send command
            }
        }
    }
}
 
//========================================================================
//======================== USING CONTROL TEMPLATES =======================
//
// To use:  Drop this CONTROLLER TEMPLATE script into the same object with
// your PARTICLE TEMPLATE.  It should be operational immediately.
//
// By default, control templates will turn EVERY particle template in the
// same object ON or OFF.  If you want particle templates to only listen
// to specific controller templates, then give both matching CONTROLLER_ID's,
// (something other than "A", like: "B" for example).  


//======================================== END ===============================
