//// "Altitude" SECONDARY CONTROLLER TEMPLATE v1 - by Jopsy Pendragon - 3/16/2010
//// You are free to use this script as you please, so long as you include this line:
//** The original 'free' version of this script came from THE PARTICLE LABORATORY. **//

// WHEN TO USE THIS SCRIPT:  This script can be added to MOVING objects that contain a
// normal CONTROLLER TEMPLATE to enable/disable particle effects.  When Active, this 
// script monitors the object height, and enables a secondary particle effect when
// the object is below a certain altitude.   When the primary effects are turned off,
// this script stops monitoring object height to reduce lag.

// HOW TO USE THIS SCRIPT:  Drop it in any prim in your object.  Add another 
// PARTICLE TEMPLATE script to your object and change it's CONTROLLER_ID to "B" so
// that it will listen to THIS script not your primary controller template.

float dust_cloud_height=5; //meters, customize to preferred trigger height.


integer dust_cloud_status=TRUE;

default {
    state_entry() {
        llSetTimerEvent(1.0);
    }
    
    link_message( integer sibling, integer signal, string controller_id, key id ) {
        if ( controller_id != "A" ) return;  // not for us.
        
        if ( signal )
            llSetTimerEvent(1.0); // timer on
        else { 
            llSetTimerEvent(0.0); // timer off
            dust_cloud_status=FALSE;
            llMessageLinked( LINK_SET,  dust_cloud_status, "B", "" );
        }
    }
    
    timer() {
        vector p=llGetPos();
        
        // height_check is TRUE if below height, FALSE otherwise.
        integer height_check = ( llFabs( llGround(p) - p.z ) < dust_cloud_height ); 
        
        if ( dust_cloud_status != height_check ) {
            dust_cloud_status = height_check;
            llMessageLinked( LINK_SET, dust_cloud_status, "B", "" );
        }
    }
}
