//// "RZ" TARGET TEMPLATE v1 - by Jopsy Pendragon - 4/8/2008
//// You are free to use this script as you please, so long as you include this line:
//** The original 'free' version of this script came from THE PARTICLE LABORATORY. **//

// PURPOSE:  Finds a NAMED object nearby and tells particle template to target it.
// WARNING: Sensors can not find Attachments, Seated Avatars or Child Prims by name!

// SETUP: Give your target object a unique name and give that name to NAME_OF_TARGET here.
// If your target object is non-physical and not scripted, leave TYPE_OF_TARGET alone,
// otherwise, update TYPE_OF_TARGET to reflect your desired target.  
//
// Make sure you have enabled the PSYS_PART_TARGET_POS_MASK in the corresponding
// particle template for this to work! and verify [ ] Running is checked for this script.

// USAGE:  Will begin scanning for target every time it is rezzed or attached.
// Will retry a few times every few seconds and then give up.  
// Touch the prim to force it to start scanning again, or re-rez this object.

string rez_prim_name;
vector REZ_LOCATION_OFFSET = <-1,0,0>; // how far from the prim to rez the new object... (max 10m!)
vector REZ_VELOCITY = <-2, 0, 4 >; // direction and amount of initial 'push' for physical rezzed objects
rotation REZ_ROTATION =ZERO_ROTATION; // object orientation at moment of rez
integer REZ_MESSAGE_PARAMATER = 0; // a value you can secretly pass to the rezzed object.

string     NAME_OF_TARGET = "My Sample Target Name";
integer    TYPE_OF_TARGET = PASSIVE; // can be PASSIVE, SCRIPTED, ACTIVE(physical), or AGENT(for avatars)
float       SCAN_DISTANCE = 25.0; // how far to scan for target, max 96?
integer NUMBER_OF_RETRIES = 12; // approximately how many times to re-scan
float      RETRY_INTERVAL = 5.0; // # of seconds between scan attempts.

string  CONTROLLER_ID = "A"; // see more about CONTROL TEMPLATES at end.

default { 
    on_rez(integer n) { llResetScript(); }
    
    attach(key id) { llResetScript(); }

    state_entry() { 
        rez_prim_name = llGetInventoryName( INVENTORY_OBJECT, 0 );
        if ( rez_prim_name == "" ) llOwnerSay("error:  I have nothing to rez!"); 
    }

    touch_start(integer n) { 
        llMessageLinked( LINK_SET, 0, CONTROLLER_ID, ""); // turn particle template off
        llRezObject( rez_prim_name, llGetPos() +REZ_LOCATION_OFFSET,  REZ_VELOCITY, 
                            REZ_ROTATION, REZ_MESSAGE_PARAMATER ); 
    }
    
    object_rez(key key_of_rezzed_object ) {
        llMessageLinked( LINK_SET, 2, CONTROLLER_ID, key_of_rezzed_object); // send command to PARTICLE TEMPLATE 
    } 
}
         

//========================================================================
//======================== USING CONTROL TEMPLATES =======================
//
// Want to control when your particles turn ON and OFF?   You can!
// 
// Drop one (or more) of the CONTROL TEMPLATES from the particle laboratory
// into your object containing this script.  That's it!

// Your controls should be effective immediately.  (Some controllers can be
// adjusted and tuned, open them and read the USAGE notes to see.)
//
// One control template can control several particle templates in the
// same object.   (keep in mind that each prim can only have ONE
// particle effect active at a time).
//
// The 'particle_effect_name' value must be the same in both the control
// and particle template to work.  You can change that value and have
// a controller for one effect, and a different controller for a different
// effect in the same object.
//


//======================================== END ===============================


