//// "Speaking" TARGET TEMPLATE v1 - by Jopsy Pendragon - 4/8/2008
//// You are free to use this script as you please, so long as you include this line:
//** The original 'free' version of this script came from THE PARTICLE LABORATORY. **//

// SETUP:  Drop and configure this TARGET TEMPLATE script into the TARGET PRIM.
// configure LISTENER_CHANNEL and SHARED_SECRET to match the "Listen" target template.
// Make sure to check the [ ] Running checkbox on this script.
// Enable PSYS_PART_TARGET_POS_MASK in your PARTICLE TEMPLATE or this will not work.

// The Listen/Speaking targeting method is best used when you are trying to target
// an attachment or a child prim of an object not linked to the particle emitter.

// If mis-used Listen/Speaking target templates can cause more lag than other methods.
// Try to use the most appropriate targetting method rather than always using this one.

 
// Customize these options.  Set the same in the matching "Speaking" TARGET TEMPLATE.
integer LISTENER_CHANNEL = 1;
string     SHARED_SECRET = "target me!";
float     RETRY_INTERVAL = 1.0; // delay between broadcast attempts
integer      retry_count = 15; // give up broadcasting # of tries.
    // re-broadcasts when object is rezzed, (un)linked, attached or touched

// string  CONTROLLER_ID = "A"; // unused in this template, use SHARED_SECRET instead.

default {
    on_rez(integer n) { llResetScript();}
    touch_start(integer n) {llResetScript();}
    attach(key id) { llResetScript();}
    changed(integer n) { if ( n & CHANGED_LINK ) llResetScript();}
    
    state_entry() { 
        llSleep(1.0);
        llRegionSay( LISTENER_CHANNEL, SHARED_SECRET );
        llSetTimerEvent( RETRY_INTERVAL );
    }
    
    timer() {
        retry_count--;
        if ( retry_count <= 0 ) llSetTimerEvent(0.0); // give up.
    }
    

}
 
