//// "Link by Name" TARGET TEMPLATE v1 - by Jopsy Pendragon - 4/8/2008
//// You are free to use this script as you please, so long as you include this line:
//** The original 'free' version of this script came from THE PARTICLE LABORATORY. **//

// PURPOSE: Helps a particle template in the same LINKED OBJECT target this prim.
// WARNING: Only works from prim to prim in the SAME LINKED OBJECT.

// SETUP: Drop this TARGET TEMPLATE into the contents of the prim you want hit with
// particles.  Everytime the object is rezzed in world, it will send it's key to the
// particle templates in the same object.
//
// Make sure you have enabled the PSYS_PART_TARGET_POS_MASK in the corresponding
// particle template for this to work!

string NAME_OF_LINKED_TARGET_PRIM = "target_one"; // root is always link #1, child prims are 2, 3, 4, ... 

string  CONTROLLER_ID = "A"; // see more about CONTROL TEMPLATES at end.


default { 
    on_rez(integer n) { llResetScript(); }
    
    attach(key id) { llResetScript(); }
    
    changed(integer n) { if ( n & CHANGED_LINK ) llResetScript();} 

    state_entry() { 
        llMessageLinked( LINK_SET, 0, CONTROLLER_ID, "" ); 
        
        integer n = llGetNumberOfPrims();
        
        do { 
            if ( llGetLinkName(n) == NAME_OF_LINKED_TARGET_PRIM ) { // found it?
                llMessageLinked( LINK_SET, 2, CONTROLLER_ID, llGetLinkKey(n) ); 
                return;
            }
        } while ( --n > 0 ); 
        
        // all prims checked - didn't find it.
        llOwnerSay("error: Could not find a linked prim named: "+NAME_OF_LINKED_TARGET_PRIM);
    } 
}
        


//========================================================================
//======================== USING CONTROL TEMPLATES =======================
//
// Want to control when your particles turn ON and OFF?   You can!
// 
// Drop one (or more) of the CONTROL TEMPLATES from the particle laboratory
// into your object containing this script.  That's it!

// Your controls should be effective immediately.  (Some controllers can be
// adjusted and tuned, open them and read the USAGE notes to see.)
//
// One control template can control several particle templates in the
// same object.   (keep in mind that each prim can only have ONE
// particle effect active at a time).
//
// The 'particle_effect_name' value must be the same in both the control
// and particle template to work.  You can change that value and have
// a controller for one effect, and a different controller for a different
// effect in the same object.
//


//======================================== END =============================== 
