//// "Listen" CONTROLLER TEMPLATE v1.1 - by Jopsy Pendragon - 5/10/2008
//// You are free to use this script as you please, so long as you include this line:
//** The original 'free' version of this script came from THE PARTICLE LABORATORY. **//

// WARNING:   Do not confuse this script with the listening TARGET TEMPLATE! =)

// SETUP:  Drop this CONTROLLER TEMPLATE script into the same object with
// your PARTICLE TEMPLATE.  It should be operational immediately.

// USAGE: Type /1 on (to start particles) and /1 off (to disable them)

// WARNING:  This script is significantly DIFFERENT than the "Listening" TARGET TEMPLATE!
// Also, this script will only listen for a new owner AFTER the new owner rezzes the object
// in world.  If you have them Buy-Original, it will still listen-to/obey the old owner.

// UPDATES:  OWNER_ONLY correction.  Will now obeys prims owned by owner as well.
// Removed "Target speaker" code to keep the script simple.
// To target speakers, use the "Listen" TARGET TEMPLATE instead.
 
// Customize these options:
integer LISTENER_CHANNEL = 1;
string        ON_COMMAND = "on";
string       OFF_COMMAND = "off";

integer       OWNER_ONLY = TRUE; // FALSE = listen to anyone/anything. 

string  CONTROLLER_ID = "A"; // see more about CONTROL TEMPLATES at end.
key my_owner = NULL_KEY;


default {
    on_rez(integer n) { llResetScript(); }
    
    state_entry() {  
        
        if ( OWNER_ONLY ) my_owner = llGetOwner(); 
        
        llListen( LISTENER_CHANNEL, "", "", "" ); 
    }
    
    listen( integer chan, string name, key target_id, string mesg ) { 
        if ( OWNER_ONLY ) {
            if ( target_id != my_owner // Check the identity of the speaker
            && llGetOwnerKey(target_id) != my_owner ) { // check ID of the speaking prim's owner
                return; // skip the rest of this listen() block.
            }
        }
            
        if ( mesg == ON_COMMAND ) { 
            llMessageLinked( LINK_SET, TRUE, CONTROLLER_ID, NULL_KEY );  
             
        } else if ( mesg == OFF_COMMAND ) {
            llMessageLinked( LINK_SET, FALSE, CONTROLLER_ID, NULL_KEY ); // send command
        }
    }
    
}


//========================================================================
//======================== USING CONTROL TEMPLATES =======================
//
//
// By default, control templates will turn EVERY particle template in the
// same object ON or OFF.  If you want particle templates to only listen
// to specific controller templates, then give both matching 
// CONTROLLER_ID's.  (something other than "A", like: "B" for example).  


//==================================== END =============================== 
