//// "Seated Avatar v2" CONTROLLER TEMPLATE v1 - by Jopsy Pendragon - 4/8/2008
//// You are free to use this script as you please, so long as you include this line:
//** The original 'free' version of this script came from THE PARTICLE LABORATORY. **//

// EFFECT: Particles are turned on when an avatar sits on this prim, and turned off when
// they stand up.

// WARNING: llSitTarget (included below) seems to be required for this script to work.

// SETUP:  Drop this CONTROLLER TEMPLATE script into the same object with
// your PARTICLE TEMPLATE.  It should be operational immediately.


// Adjust these values:

string  CONTROLLER_ID = "A"; // see more about CONTROL TEMPLATES at end.

integer occupied=TRUE; // assume someone is sitting on us if the script resets.
 
default {
    state_entry() { 
        // You may have to adjust SitTarget location/rotation or the location of this prim.
        llSitTarget( <0.25, 0.0, 0.55>, ZERO_ROTATION);    
        llSetClickAction( CLICK_ACTION_SIT );
    }
        
    changed(integer change) {
        
        if ( change & CHANGED_LINK ) { // a link change has occured
            
            if ( llAvatarOnSitTarget() != NULL_KEY ) { // our seat has an avatar in it!  
                llMessageLinked( LINK_SET, TRUE, CONTROLLER_ID, NULL_KEY ); // send ON command   
                occupied=TRUE;
                
            } else if ( occupied ) { // only turn particles off if someone was sitting and now isn't.
                llMessageLinked( LINK_SET, FALSE, CONTROLLER_ID, NULL_KEY ); // send OFF command  
                occupied=FALSE;
                
            }     
        }
    }    
}


//========================================================================
//======================== USING CONTROL TEMPLATES =======================
//
//
// By default, control templates will turn EVERY particle template in the
// same object ON or OFF.  If you want particle templates to only listen
// to specific controller templates, then give both matching 
// CONTROLLER_ID's.  (something other than "A", like: "B" for example).  


//==================================== END =============================== 
