float animation_speed = 0.05;
integer link_counter;
integer gON=1;  // A toggle  
list gModel_list;   // List of your animated link numbers
integer gLen;   // Length of gModel_list

default
{    
    state_entry()  // In which you make a list of the links to be animated    
    {        
        integer i = llGetNumberOfPrims(); 
        while (i)        
        {            
            if (llGetLinkName(i) == "Model")  // Find the links named "Model"          
            {               
                gModel_list += [i];   //  Add them to a list            
            }       
            --i;  
        }        
        gLen = llGetListLength(gModel_list);   // How long is the list?   
         llSetTimerEvent(animation_speed* (gON )); 
        link_counter = 0; 
    }   
    changed( integer c) 
    {       
        if ( c & CHANGED_LINK) 
        {           
            llResetScript(); 
        } 
    }        

      
 timer()   // In which you animate the links   
 {        
link_counter = (++link_counter)%gLen;  // Choose the next link in gModel_list, a new one  each time the timer fires 
       integer i;  
      while ( i < gLen)  // Step through all links listed in gModel_list       
 {           
 integer Link = llList2Integer(gModel_list,i);  
 // Get the link number           
 if ( i == link_counter)  // If this link is the one chosen .....     
       {           
     llSetLinkAlpha(Link, 1.0, ALL_SIDES);  // ... make it visible           
 }  
          else          
  {               
 llSetLinkAlpha( Link,0.0, ALL_SIDES);  // .... make it transparent       
     }        
    ++i;     
   }  
  }   
     }
 