//start_unprocessed_text
/*/|/ Started at: 04.05.2013 17:04:00
/|/ Authors: XandrineX and Perl Nakajima

/|/ --- configuration ---
float   gLOCKMEISTER_RESPONSE_TIMEOUT = 3;
integer gLOCKMEISTER_CHANNEL          = -8888;
integer gLOCKGUARD_CHANNEL            = -9119;

/|/ incomming link messages...
integer gCMD_SET_CHAINS               = 2732; /|/ cmdId, set chains in msg
integer gCMD_REM_CHAINS               = 2733; /|/ cmdId, remove all chains
string  gSET_SEPARATOR                = "~"; /|/ separator from linkmessage

/|/ For trying to use lockguard as a fallback, you need to specify mappings here
/|/ from the lockmeister to lockguard attachment IDs. I know that this is not
/|/ perfect, since lockmeister and lockguard offer different cuff points and
/|/ additionally work just the other way round. So I tried to do my best and
/|/ give the best mapping I could think of. But you might need to change it,
/|/ depending on your needs and piece of furniture.
/|/ For reference and available points, see:
/|/ http:/|/wiki.secondlife.com/wiki/LSL_Protocol/LockMeister_System
/|/ http:/|/lslwiki.net/lslwiki/wakka.php?wakka=exchangeLockGuardItem
list   gLM_TO_LG_MAPPINGS = [
    "rcuff",    "rightwrist",
    "rbiceps",  "rightupperarm",
    "lbiceps",  "leftupperarm",
    "lcuff",    "leftwrist",
    "lblade",   "harnessleftloopback",  /|/ ?
    "rblade",   "harnessrightloopback", /|/ ?
    "rnipple",  "rightnipplering",
    "lnipple",  "leftnipplering",
    "rfbelt",   "rightbeltloop",
    "lfbelt",   "leftbeltloop",
    "rtigh",    "rightupperthigh",
    "ltigh",    "leftupperthigh",
    "rlcuff",   "rightankle",
    "llcuff",   "leftankle",
    "lbbelt",   "harnessleftloopback",  /|/ ?
    "rbbelt",   "harnessrightloopback", /|/ ?
    "pelvis",   "clitring",             /|/ ?
    "fbelt",    "frontbeltloop",
    "bbelt",    "backbeltloop",
    "rcollar",  "collarrightloop",
    "lcollar",  "collarleftloop",
    "thead",    "topheadharness",       /|/ ?
    "collar",   "collarfrontloop",
    "lbit",     "leftgag",              /|/ ?
    "rbit",     "rightgag",             /|/ ?
    "nose",     "nosering",
    "bcollar",  "collarbackloop",
    "back",     "harnessbackloop",      /|/ ?
    "lhand",    "leftwrist",            /|/ ?
    "rhand",    "rightwrist"            /|/ ?
];

/|/ --- global variables ---
list    gPrimIDs;         /|/ description => linkId
list    gLmCalls;         /|/ store call-string => linkId for listen
list    gLmCallsDone;     /|/ stores lockmeister chains set
integer gLmCallsLength;   /|/ length of gLmCalls
integer gListenHandle;    /|/ storing lockmeister listening handle
key     gAvatarKey;

/|/ ============================================================
query_set_chains( key avatarKey, list items ) {
    integer itemLength = llGetListLength( items );

    llWhisper( gLOCKGUARD_CHANNEL, "lockguard " + (string)gAvatarKey + " all unlink " );
    integer lengthLG = llGetListLength( gLM_TO_LG_MAPPINGS );
    integer j;
    for( j=0; j < lengthLG; j+=2 ) {
        llWhisper( gLOCKGUARD_CHANNEL, "lockguard " + (string)gAvatarKey + " "
            + llList2String( gLM_TO_LG_MAPPINGS, j + 1 ) + " unlink" );
    }

    gLmCalls = [];
    llListenRemove( gListenHandle );
    gListenHandle = llListen( gLOCKMEISTER_CHANNEL, "", NULL_KEY, "" );
    integer i;
    for( i=0; i < itemLength; i+=2 ) {
        string desc    = llList2String( items, i );
        integer index  = llListFindList( gPrimIDs, [ desc ] );
        if( index == -1 ) {
/|/              llOwnerSay( "/me Error: no ring " + desc + " found" );
        }
        else {
            integer primId = llList2Integer( gPrimIDs, index + 1 );
            llLinkParticleSystem( primId, [] );
            string mooring = llList2String(  items,    i + 1 );
            if( mooring != "" ) {
/|/                llOwnerSay( "Chain: " + desc + " -> " + mooring
/|/                    + " PrimId: " + (string)primId );
                string lm_call = (string)avatarKey + mooring;
                /|/ llOwnerSay( "Calling: " + lm_call );
                if( -1 == llListFindList( gLmCalls, [ lm_call + " ok" ] ) ) {
                    llWhisper( gLOCKMEISTER_CHANNEL, lm_call );
                }
                gLmCalls += [ lm_call + " ok", primId ];
            }
        }   
    } /|/ for i

    gLmCallsLength = llGetListLength( gLmCalls );
    llSetTimerEvent( gLOCKMEISTER_RESPONSE_TIMEOUT );
}
/|/ ============================================================
default {

    state_entry() {
        gPrimIDs = [];
        integer number_of_prims = llGetNumberOfPrims();
        integer i;
        for( i=2; i < number_of_prims + 1; ++i ) { /|/ ignore root prim
            string desc = llList2String( llGetLinkPrimitiveParams( i, [ PRIM_DESC ] ), 0 );
            if( desc != "" && desc != "(No description)" ) {
                if( -1 == llListFindList( gPrimIDs, [ desc ] ) ) { /|/ only accept unique descriptions
                    gPrimIDs += [ desc, i ];
                }
                else {
                    llOwnerSay( "/me Error: prim description " + desc
                        + " isn't unique, please make it unique... ignoring" );  
                }
            }
        }
/|/      gPrimIDs = llListSort( gPrimIDs, 2, TRUE );
/|/      llOwnerSay( "PrimIDs: " + llDumpList2String( gPrimIDs, "\t" ) );
    }

    link_message( integer primId, integer commandId, string message, key avatarKey ) {

        if( commandId == gCMD_REM_CHAINS ) {
            /|/ lockguard first, because it seems to react slower
            /|/ llWhisper( gLOCKGUARD_CHANNEL, "lockguard " + (string)gAvatarKey + " all unlink" );
            integer lengthLG = llGetListLength( gLM_TO_LG_MAPPINGS );
            integer j;
            for( j=0; j < lengthLG; j+=2 ) {
                llWhisper( gLOCKGUARD_CHANNEL, "lockguard " + (string)gAvatarKey + " "
                    + llList2String( gLM_TO_LG_MAPPINGS, j + 1 ) + " unlink" );
            }
    
            /|/ lockmeister
            list descriptions = llParseStringKeepNulls( message, [ gSET_SEPARATOR ], [] );    
            integer length = llGetListLength( descriptions );
            integer i;
            for( i=0; i < length; i+=1 ) {
                string description = llList2String( descriptions, i );
                integer index      = llListFindList( gPrimIDs, [ description ] );
                if( index != -1 ) {
                    llLinkParticleSystem( llList2Integer( gPrimIDs, index + 1 ), [] );
                }
                else {
/|/                    llOwnerSay( "/me Error: no desc found: " + description );
                }
            }
        }

        else if( commandId == gCMD_SET_CHAINS ) {
            gAvatarKey = avatarKey;
            query_set_chains( avatarKey,
                llParseStringKeepNulls( message, [ gSET_SEPARATOR ], [] )
            );                    
        }
    }
    
    listen( integer channel, string cuffName, key cuffKey, string message ) {
        if( channel != gLOCKMEISTER_CHANNEL )     return;
        integer i;
        for( i=0; i < gLmCallsLength; i+=2 ) {
            if( llList2String( gLmCalls, i ) == message ) {
                
                /|/ send lockmeister chain
                llLinkParticleSystem( llList2Integer( gLmCalls, i + 1 ), [
                    PSYS_SRC_TARGET_KEY,       cuffKey,    
                    PSYS_PART_START_SCALE,     <0.06,0.06,0>,
                    PSYS_PART_MAX_AGE,         2,
                    PSYS_SRC_ACCEL,            <0, 0, -0.1>,        
                    PSYS_SRC_TEXTURE,          "40809979-b6be-2b42-e915-254ccd8d9a08", 
                    PSYS_SRC_PATTERN,          PSYS_SRC_PATTERN_DROP,        
                    PSYS_SRC_BURST_PART_COUNT, 1,
                    PSYS_SRC_BURST_RATE,       0.0,
                    PSYS_PART_FLAGS,
                        PSYS_PART_FOLLOW_VELOCITY_MASK |
                        PSYS_PART_FOLLOW_SRC_MASK |
                        PSYS_PART_TARGET_POS_MASK
                ] );
                
                gLmCallsDone += [ message ]; /|/ store successful points for skipping lockguard
            }
        }
    }

    timer() {
        llSetTimerEvent( 0.0 );
        llListenRemove( gListenHandle );
        
        /|/ try the not found lockmeister points with lockguard 
        integer i;
        for( i=0; i < gLmCallsLength; i+=2 ) {
            string message = llList2String( gLmCalls, i );
            if( -1 == llListFindList( gLmCallsDone, [ message ] ) ) {
                string lmMooring = llGetSubString( message, 36, -4 );
                integer index = llListFindList( gLM_TO_LG_MAPPINGS, [ lmMooring ] );
                if( index != -1 ) {
                    key     avatarKey = llGetSubString( message, 0, 35 );
                    string lgMooring  = llList2String( gLM_TO_LG_MAPPINGS, index + 1 );
                    integer primId    = llList2Integer( gLmCalls, i + 1 );
                    key     primKey   = llGetLinkKey( primId );
                    /|/ llOwnerSay( (string)primId + ": LM-Mooring: '" + lmMooring + "' => LG: " + lgMooring );
                    llWhisper( gLOCKGUARD_CHANNEL, "lockguard " + (string)avatarKey + " "
                        + lgMooring + " gravity 0.3 life 1 link " + (string)primKey );
                }
            }
        }
        
        /|/ cleanup
        gLmCalls     = [];
        gLmCallsDone = [];
    }
    
    on_rez(integer param){
        llResetScript();
    }
    
} /|/ default
/|/ ============================================================
*/
//end_unprocessed_text
//nfo_preprocessor_version 0
//program_version Firestorm-Releasex64 4.7.7.48706- Howard Baxton
//last_compiled 04/18/2016 19:03:31
//mono








float   gLOCKMEISTER_RESPONSE_TIMEOUT = 3;
integer gLOCKMEISTER_CHANNEL          = -8888;
integer gLOCKGUARD_CHANNEL            = -9119;


integer gCMD_SET_CHAINS               = 2732; 
integer gCMD_REM_CHAINS               = 2733; 
string  gSET_SEPARATOR                = "~"; 










list   gLM_TO_LG_MAPPINGS = [
    "rcuff",    "rightwrist",
    "rbiceps",  "rightupperarm",
    "lbiceps",  "leftupperarm",
    "lcuff",    "leftwrist",
    "lblade",   "harnessleftloopback",  
    "rblade",   "harnessrightloopback", 
    "rnipple",  "rightnipplering",
    "lnipple",  "leftnipplering",
    "rfbelt",   "rightbeltloop",
    "lfbelt",   "leftbeltloop",
    "rtigh",    "rightupperthigh",
    "ltigh",    "leftupperthigh",
    "rlcuff",   "rightankle",
    "llcuff",   "leftankle",
    "lbbelt",   "harnessleftloopback",  
    "rbbelt",   "harnessrightloopback", 
    "pelvis",   "clitring",             
    "fbelt",    "frontbeltloop",
    "bbelt",    "backbeltloop",
    "rcollar",  "collarrightloop",
    "lcollar",  "collarleftloop",
    "thead",    "topheadharness",       
    "collar",   "collarfrontloop",
    "lbit",     "leftgag",              
    "rbit",     "rightgag",             
    "nose",     "nosering",
    "bcollar",  "collarbackloop",
    "back",     "harnessbackloop",      
    "lhand",    "leftwrist",            
    "rhand",    "rightwrist"            
];


list    gPrimIDs;         
list    gLmCalls;         
list    gLmCallsDone;     
integer gLmCallsLength;   
integer gListenHandle;    
key     gAvatarKey;


query_set_chains( key avatarKey, list items ) {
    integer itemLength = llGetListLength( items );

    llWhisper( gLOCKGUARD_CHANNEL, "lockguard " + (string)gAvatarKey + " all unlink " );
    integer lengthLG = llGetListLength( gLM_TO_LG_MAPPINGS );
    integer j;
    for( j=0; j < lengthLG; j+=2 ) {
        llWhisper( gLOCKGUARD_CHANNEL, "lockguard " + (string)gAvatarKey + " "
            + llList2String( gLM_TO_LG_MAPPINGS, j + 1 ) + " unlink" );
    }

    gLmCalls = [];
    llListenRemove( gListenHandle );
    gListenHandle = llListen( gLOCKMEISTER_CHANNEL, "", NULL_KEY, "" );
    integer i;
    for( i=0; i < itemLength; i+=2 ) {
        string desc    = llList2String( items, i );
        integer index  = llListFindList( gPrimIDs, [ desc ] );
        if( index == -1 ) {

        }
        else {
            integer primId = llList2Integer( gPrimIDs, index + 1 );
            llLinkParticleSystem( primId, [] );
            string mooring = llList2String(  items,    i + 1 );
            if( mooring != "" ) {


                string lm_call = (string)avatarKey + mooring;
                
                if( -1 == llListFindList( gLmCalls, [ lm_call + " ok" ] ) ) {
                    llWhisper( gLOCKMEISTER_CHANNEL, lm_call );
                }
                gLmCalls += [ lm_call + " ok", primId ];
            }
        }   
    } 

    gLmCallsLength = llGetListLength( gLmCalls );
    llSetTimerEvent( gLOCKMEISTER_RESPONSE_TIMEOUT );
}

default {

    state_entry() {
        gPrimIDs = [];
        integer number_of_prims = llGetNumberOfPrims();
        integer i;
        for( i=2; i < number_of_prims + 1; ++i ) { 
            string desc = llList2String( llGetLinkPrimitiveParams( i, [ PRIM_DESC ] ), 0 );
            if( desc != "" && desc != "(No description)" ) {
                if( -1 == llListFindList( gPrimIDs, [ desc ] ) ) { 
                    gPrimIDs += [ desc, i ];
                }
                else {
                    llOwnerSay( "/me Error: prim description " + desc
                        + " isn't unique, please make it unique... ignoring" );  
                }
            }
        }


    }

    link_message( integer primId, integer commandId, string message, key avatarKey ) {

        if( commandId == gCMD_REM_CHAINS ) {
            
            
            integer lengthLG = llGetListLength( gLM_TO_LG_MAPPINGS );
            integer j;
            for( j=0; j < lengthLG; j+=2 ) {
                llWhisper( gLOCKGUARD_CHANNEL, "lockguard " + (string)gAvatarKey + " "
                    + llList2String( gLM_TO_LG_MAPPINGS, j + 1 ) + " unlink" );
            }
    
            
            list descriptions = llParseStringKeepNulls( message, [ gSET_SEPARATOR ], [] );    
            integer length = llGetListLength( descriptions );
            integer i;
            for( i=0; i < length; i+=1 ) {
                string description = llList2String( descriptions, i );
                integer index      = llListFindList( gPrimIDs, [ description ] );
                if( index != -1 ) {
                    llLinkParticleSystem( llList2Integer( gPrimIDs, index + 1 ), [] );
                }
                else {

                }
            }
        }

        else if( commandId == gCMD_SET_CHAINS ) {
            gAvatarKey = avatarKey;
            query_set_chains( avatarKey,
                llParseStringKeepNulls( message, [ gSET_SEPARATOR ], [] )
            );                    
        }
    }
    
    listen( integer channel, string cuffName, key cuffKey, string message ) {
        if( channel != gLOCKMEISTER_CHANNEL )     return;
        integer i;
        for( i=0; i < gLmCallsLength; i+=2 ) {
            if( llList2String( gLmCalls, i ) == message ) {
                
                
                llLinkParticleSystem( llList2Integer( gLmCalls, i + 1 ), [
                    PSYS_SRC_TARGET_KEY,       cuffKey,    
                    PSYS_PART_START_SCALE,     <0.06,0.06,0>,
                    PSYS_PART_MAX_AGE,         2,
                    PSYS_SRC_ACCEL,            <0, 0, -0.1>,        
                    PSYS_SRC_TEXTURE,          "40809979-b6be-2b42-e915-254ccd8d9a08", 
                    PSYS_SRC_PATTERN,          PSYS_SRC_PATTERN_DROP,        
                    PSYS_SRC_BURST_PART_COUNT, 1,
                    PSYS_SRC_BURST_RATE,       0.0,
                    PSYS_PART_FLAGS,
                        PSYS_PART_FOLLOW_VELOCITY_MASK |
                        PSYS_PART_FOLLOW_SRC_MASK |
                        PSYS_PART_TARGET_POS_MASK
                ] );
                
                gLmCallsDone += [ message ]; 
            }
        }
    }

    timer() {
        llSetTimerEvent( 0.0 );
        llListenRemove( gListenHandle );
        
        
        integer i;
        for( i=0; i < gLmCallsLength; i+=2 ) {
            string message = llList2String( gLmCalls, i );
            if( -1 == llListFindList( gLmCallsDone, [ message ] ) ) {
                string lmMooring = llGetSubString( message, 36, -4 );
                integer index = llListFindList( gLM_TO_LG_MAPPINGS, [ lmMooring ] );
                if( index != -1 ) {
                    key     avatarKey = llGetSubString( message, 0, 35 );
                    string lgMooring  = llList2String( gLM_TO_LG_MAPPINGS, index + 1 );
                    integer primId    = llList2Integer( gLmCalls, i + 1 );
                    key     primKey   = llGetLinkKey( primId );
                    
                    llWhisper( gLOCKGUARD_CHANNEL, "lockguard " + (string)avatarKey + " "
                        + lgMooring + " gravity 0.3 life 1 link " + (string)primKey );
                }
            }
        }
        
        
        gLmCalls     = [];
        gLmCallsDone = [];
    }
    
    on_rez(integer param){
        llResetScript();
    }
    
} 


