/* ************************************************************************** */
//
// tl BodyController script [BB]
// 
// by Thai Low @ endivatomic.eu:8002
//
// Provided under Creative Commons Attribution-Non-Commercial-ShareAlike 4.0 
//                International license.
//
// Please be sure you read and adhere to the terms of this license: 
//      https://creativecommons.org/licenses/by-nc-sa/4.0/
//
/* ************************************************************************** */
// IMPORTANT NOTE: 
//          I only made the controller (this script) and the related HUD,
//          NOT the bodymesh where you may found this script inside. 
//          The right to copy and use any components (mesh,textures,etc...)
//          apart this script, are all reserved to the related builders.
//                                                      Thai Low
/* ************************************************************************** */

// -------------------------------------------------------------------------
//  module variables/constants
// -------------------------------------------------------------------------
integer CHOFFS  = 101;
string SKIN     = "SK";
string SKINUP   = "SU";
string SKINLOW  = "SL";
string UWEAR    = "UK";
string UWEARUP  = "UU";
string UWEARLOW = "UL";
string NECK     = "NECK";
string HANDL    = "HL";
string HANDR    = "HR";
string HAND     = "HAND";
string GLOVES   = "GLOVES";

list cCHEST  = [ TRUE, "SU1", "SU2" ];
list cARMS   = [ TRUE, "SU3", "SU4" ];
list cNIPPLE = [ TRUE, "SU9", "SU10" ];
list cBREAST = [ TRUE, "SU5", "SU6" ];
list cBELLY  = [ TRUE, "SU7", "SU8" ];
list cBACK   = [ TRUE, "SL2" ];
list cPELVIS = [ TRUE, "SL1" ];
list cULEGS  = [ TRUE, "SL3", "SL4", "SL5", "SL6", "SL7", "SL8", "SL9", "SL10" ];
list cLLEGS  = [ TRUE, "SL11", "SL12", "SL13", "SL14", "SL15", "SL16", "SL17", "SL18" ];

list mSkUp;
list mSkLow;
list mUnUp;
list mUnLow;
integer mHandL = -1;
integer mHandR = -1;
integer mNeck  = -1;

integer mCh;

// -------------------------------------------------------------------------
//  common Helpers
// -------------------------------------------------------------------------
// --- Get a unique channel number (nearly unique)
integer getOwnerChannel() {  
  return 0x80000000 | (integer)("0x"+llGetSubString((string)llGetOwner(),-7,-1));
}  

// -------------------------------------------------------------------------
//  module functions
// -------------------------------------------------------------------------
initLinks() {
  mSkUp = [];
  mSkLow = [];
  mUnUp = [];
  mUnLow = [];
    
  integer lnk = 1 + llGetNumberOfPrims();
  while( --lnk > 0 ) {        
    string name = llGetLinkName( lnk );  
    if (name == HANDL) mHandL = lnk;
    else if (name == HANDR) mHandR = lnk;
    else if (name == NECK) mNeck = lnk;
    else {        
      string nm = llGetSubString( name, 0, 1);        
      if (nm == SKINUP) mSkUp += [lnk];
      else if (nm == SKINLOW) mSkLow += [lnk];
      else if (nm == UWEARUP) mUnUp += [lnk];
      else if (nm == UWEARLOW) mUnLow += [lnk];
    }
  }
}

// --- set texture to specified (tp) blocks
setTexture( string tp, key tid ) {      
  list lst = [];
  if ( tp == SKINUP ) { lst = [ mNeck ] + mSkUp; setHandTexture( tid ); }
  else if ( tp == SKINLOW ) lst = mSkLow;
  else if ( tp == UWEARUP ) { lst = mUnUp; setGlovesTexture( tid ); }
  else if ( tp == UWEARLOW ) { lst = mUnLow; llSay(mCh, "SOCKS|txt|"+tid); }
    
  integer n = llGetListLength(lst);
  while( --n >= 0 ) {
    integer lnk = llList2Integer(lst,n);  
    llSetLinkPrimitiveParamsFast( lnk, [PRIM_TEXTURE, ALL_SIDES, tid, <1,1,0>, <0,0,0>, 0] );    
  }
}

// --- set color to skin layer
setSkinColor( vector col ) {
  list lst = [mNeck] + mSkUp + mSkLow;
  integer n = llGetListLength(lst);
  float alpha;
  
  while( --n >= 0 ) {
    integer lnk =  llList2Integer(lst,n);  
    integer nf = llGetLinkNumberOfSides( lnk );  
    while (nf >= 0) {
      alpha = llList2Float(llGetLinkPrimitiveParams(lnk, [ PRIM_COLOR, nf ]),1);
      llSetLinkPrimitiveParamsFast( lnk, [PRIM_COLOR, nf, col, alpha] );
      nf--;   
    }  
  }
  
  alpha = llList2Float(llGetLinkPrimitiveParams(mHandL, [ PRIM_COLOR, 5 ]),1);
  llSetLinkPrimitiveParamsFast( mHandL, [PRIM_COLOR, 5, col, alpha] );
  llSetLinkPrimitiveParamsFast( mHandR, [PRIM_COLOR, 5, col, alpha] );
}

setHandTexture( key tid ) {          
  if (mHandL != -1) llSetLinkPrimitiveParamsFast( mHandL, [PRIM_TEXTURE, 5, tid, <1,1,0>, <0,0,0>, 0] );        
  if (mHandR != -1) llSetLinkPrimitiveParamsFast( mHandR, [PRIM_TEXTURE, 5, tid, <1,1,0>, <0,0,0>, 0] );   
}

setNailTexture( key tid ) {      
  llSetLinkPrimitiveParamsFast( mHandL, [
    PRIM_TEXTURE, 0, tid, <1,1,0>, <0,0,0>, 0,
    PRIM_TEXTURE, 1, tid, <1,1,0>, <0,0,0>, 0,
    PRIM_TEXTURE, 2, tid, <1,1,0>, <0,0,0>, 0,
    PRIM_TEXTURE, 3, tid, <1,1,0>, <0,0,0>, 0,
    PRIM_TEXTURE, 4, tid, <1,1,0>, <0,0,0>, 0
  ] );        
  llSetLinkPrimitiveParamsFast( mHandR, [
    PRIM_TEXTURE, 0, tid, <1,1,0>, <0,0,0>, 0,
    PRIM_TEXTURE, 1, tid, <1,1,0>, <0,0,0>, 0,
    PRIM_TEXTURE, 2, tid, <1,1,0>, <0,0,0>, 0,
    PRIM_TEXTURE, 3, tid, <1,1,0>, <0,0,0>, 0,
    PRIM_TEXTURE, 4, tid, <1,1,0>, <0,0,0>, 0
  ] );           
}

setNailSize( integer sz ) {  
  integer i;
  for( i = 0; i < 5; i++) {
    float alpha = 0.; 
    if (i == sz) alpha = 1.;  
    llSetLinkAlpha( mHandL, alpha, i ); 
    llSetLinkAlpha( mHandR, alpha, i );     
  }   
}

setNailColor( vector col ) {  
  integer i;
  for( i = 0; i < 5; i++) {   
    llSetLinkColor( mHandL, col, i ); 
    llSetLinkColor( mHandR, col, i );     
  }   
}

setNeckSize(integer sz ) {  
  integer nf = llGetLinkNumberOfSides( mNeck );  
  while (--nf > 0) {
    float alpha = 0.; if (nf == sz) alpha = 1.;   
    llSetLinkAlpha( mNeck, alpha, nf );     
  }   
}

switchSkinAlpha( string part, integer face ) {
  if (part == NECK) {
    integer nf = llGetLinkNumberOfSides( mNeck ); 
    float alpha = 1;
    while (--nf > 0) {      
      if ( llList2Float( llGetLinkPrimitiveParams(mNeck, [ PRIM_COLOR, nf ]), 1 ) > .2) alpha = 0.;         
    }       
    llSetLinkAlpha( mNeck, alpha, -1 );           
    return;    
  }  
        
  list lst = mSkUp + mSkLow;
  integer n = llGetListLength(lst);
    
  while( --n >= 0 ) {
    integer lnk = llList2Integer(lst,n);  
    if (llGetLinkName( lnk ) == part) {
      list par = llGetLinkPrimitiveParams(lnk, [ PRIM_COLOR, face ]);  
      vector col = llList2Vector( par, 0 );
      float alpha = 0;
      if (llList2Float( par, 1 ) < 0.5) alpha = 1;
      llSetLinkPrimitiveParamsFast( lnk, [PRIM_COLOR, face, col, alpha] );  
    }    
  }    
}

alphaSkinReset() {
  cCHEST =  llListReplaceList(cCHEST, [TRUE], 0, 0);
  cNIPPLE = llListReplaceList(cNIPPLE, [TRUE], 0, 0);
  cBREAST = llListReplaceList(cBREAST, [TRUE], 0, 0);
  cBELLY =  llListReplaceList(cBELLY, [TRUE], 0, 0);
  cBACK =   llListReplaceList(cBACK, [TRUE], 0, 0);
  cARMS =   llListReplaceList(cARMS, [TRUE], 0, 0);
  cPELVIS = llListReplaceList(cPELVIS, [TRUE], 0, 0);
  cULEGS =  llListReplaceList(cULEGS, [TRUE], 0, 0);
  cLLEGS =  llListReplaceList(cLLEGS, [TRUE], 0, 0);     
  
  list lst = mSkUp + mSkLow;  
  integer n = llGetListLength(lst);    
  while( --n >= 0 ) {
    integer lnk = llList2Integer(lst,n);  
    llSetLinkAlpha( lnk, 1., -1 );    
  }        
}

alphaBlock( string bn ) {
  if (bn == "reset") alphaSkinReset(); 
  else if (bn == "chest")  cCHEST = switchAlphaBlock( cCHEST );
  else if (bn == "breast") cBREAST = switchAlphaBlock( cBREAST );
  else if (bn == "nipple") cNIPPLE = switchAlphaBlock( cNIPPLE );
  else if (bn == "back")   cBACK = switchAlphaBlock( cBACK );
  else if (bn == "arms")   cARMS = switchAlphaBlock( cARMS );
  else if (bn == "belly")  cBELLY = switchAlphaBlock( cBELLY );
  else if (bn == "pelvis") cPELVIS = switchAlphaBlock( cPELVIS );
  else if (bn == "ulegs")  cULEGS = switchAlphaBlock( cULEGS );
  else if (bn == "llegs")  cLLEGS = switchAlphaBlock( cLLEGS );
}

list switchAlphaBlock( list lst ) {
  integer sts = !llList2Integer(lst,0);
  float alpha = 0; if (sts) alpha = 1;
  
  list nms = [];
  list fcs = [];
  
  integer n = llGetListLength(lst);    
  while( --n >= 1 ) {
    string sln = llList2String(lst,n);          
    integer p = llSubStringIndex( sln, ":" );
    if ( p == -1 ) {
      nms += [ sln ];
      fcs += -1;   
    }
    else {
      nms += [ llGetSubString(sln, 0, p-1) ];
      fcs += [ (integer)llGetSubString(sln, p+1, -1) ];            
    }         
  } 
  
  integer lnk = 1 + llGetNumberOfPrims();
  while( --lnk > 0 ) {        
    string name = llGetLinkName( lnk );  
    integer p = llListFindList( nms, [name] );
    if ( p != -1 ) 
      llSetLinkAlpha( lnk, alpha, llList2Integer( fcs, p ) );    
  }  
    
  return llListReplaceList(lst, [sts], 0, 0); 
}

alphaDump() {
  string msg = "\nSK|alphareset\n";
    
  list lst = mSkUp + mSkLow;  
  integer n = llGetListLength(lst);    
  while( --n >= 0 ) {
    integer lnk = llList2Integer(lst,n);  
    string   nm = llGetLinkName(lnk);
    
    integer nf = llGetLinkNumberOfSides( lnk );     
    while (--nf > 0) {      
      if ( llList2Float( llGetLinkPrimitiveParams(lnk, [ PRIM_COLOR, nf ]), 1 ) < .2) 
        msg += SKIN+"|alphaswitch|"+nm+"|"+(string)nf+"\n";
    }   
  }        
  
  llOwnerSay( msg );  
}

switchGloves() { 
  float alpha = llList2Float( llGetLinkPrimitiveParams(mHandL, [ PRIM_COLOR, 6 ]), 1 );
  
  if (alpha > .5) { 
    llSetLinkAlpha( mHandL, 0., 6 ); 
    llSetLinkAlpha( mHandL, 1., 5 ); 
    llSetLinkAlpha( mHandL, 1., 1 );     
    llSetLinkAlpha( mHandR, 0., 6 ); 
    llSetLinkAlpha( mHandR, 1., 5 ); 
    llSetLinkAlpha( mHandR, 1., 1 ); 
  }
  else {
    setNailSize( 1 );
    llSetLinkAlpha( mHandL, 1., 6 ); 
    llSetLinkAlpha( mHandR, 1., 6 ); 
  }
}

setGlovesTexture( key tid ) {      
  llSetLinkPrimitiveParamsFast( mHandL, [PRIM_TEXTURE, 6, tid, <1,1,0>, <0,0,0>, 0] );        
  llSetLinkPrimitiveParamsFast( mHandR, [PRIM_TEXTURE, 6, tid, <1,1,0>, <0,0,0>, 0] );           
}

setUWearAlphaFull( integer sts ) {   
  float alpha = 0.; if (sts) alpha = 1.;  
  list lst = mUnUp + mUnLow;  
  integer n = llGetListLength(lst);    
  while( --n >= 0 ) {
    integer lnk = llList2Integer(lst,n);  
    llSetLinkAlpha( lnk, alpha, ALL_SIDES );    
  }        
}

switchUWearAlpha() {        
  list lst = mUnUp + mUnLow;
  integer n = llGetListLength(lst);
  float alpha = -1;
    
  while( --n >= 0 ) {
    integer lnk = llList2Integer(lst,n);  
    if (alpha == -1) {
      alpha = 0;
      if (llList2Float( llGetLinkPrimitiveParams(lnk, [ PRIM_COLOR, 0 ]), 1 ) < 0.5) alpha = 1;
    }
    llSetLinkAlpha( lnk, alpha, ALL_SIDES );      
  }    
}

// --- set color to UnderWear layer
setUWearColor( vector col ) {
  list lst = mUnUp + mUnLow;
  integer n = llGetListLength(lst);
  float alpha;
  
  while( --n >= 0 ) {
    integer lnk =  llList2Integer(lst,n);  
    integer nf = llGetLinkNumberOfSides( lnk );  
    while (nf >= 0) {
      alpha = llList2Float(llGetLinkPrimitiveParams(lnk, [ PRIM_COLOR, nf ]),1);
      llSetLinkPrimitiveParamsFast( lnk, [PRIM_COLOR, nf, col, alpha] );
      nf--;   
    }  
  }  
}

// -------------------------------------------------------------------------
//  default Events cycle
// -------------------------------------------------------------------------
default {    
  state_entry() {
    initLinks(); 
    mCh = getOwnerChannel() + CHOFFS;  
    llListen( mCh, "", NULL_KEY, "" );     
  }    
  changed(integer mask) { if ( mask & CHANGED_OWNER ) llResetScript(); }  
  on_rez(integer par) { llResetScript(); }  
    
  listen( integer ch, string name, key id, string msg ) { 
    if (ch != mCh) return;              
    
    list    par = llParseString2List( msg, ["|"], [] );    
    string dest = llList2String( par, 0 );        
    string  cmd = llList2String( par, 1 );        
   
    if (dest == SKIN && cmd == "alphareset" )
      alphaSkinReset();
    if (dest == SKIN && cmd == "alphablock" )  
      alphaBlock( llList2String( par, 2 ) );    
    else if ((dest == SKIN || dest == NECK) && cmd == "alphaswitch" )  
      switchSkinAlpha( llList2String( par, 2 ), llList2Integer( par, 3 ) );        
    else if (dest == SKIN && cmd == "col" )  
      setSkinColor(llList2Vector( par, 2 ));    
    else if (dest == SKIN && cmd == "txt") { 
      setTexture( SKINUP, llList2Key( par, 2 ) );
      setTexture( SKINLOW, llList2Key( par, 3 ) );            
    }    
    else if ((dest == SKINUP || dest == SKINLOW) && cmd == "txt")  
      setTexture( dest, llList2Key( par, 2 ) );     
    else if (dest == NECK) { 
      if (cmd == "txt") setTexture( dest, llList2Key( par, 2 ) ); 
      if (cmd == "sz") setNeckSize( llList2Integer( par, 2 ) +1 );   
    }     
    else if (dest == HAND) {    
      if (cmd == "txt") setNailTexture( llList2Key( par, 2 ) );      
      else if (cmd == "col") setNailColor( llList2Vector( par, 2 ) );      
      else if (cmd == "nsz") setNailSize( llList2Integer( par, 2 ) );                      
    } 
    else if (dest == GLOVES) {
      if (cmd == "txt") setGlovesTexture( llList2Key( par, 2 ) );      
      else if (cmd == "switch") switchGloves();
    } 
    else if (dest == SKIN && cmd == "alphasay") 
      alphaDump();    
    // Underwear layer
    else if (dest == UWEAR && cmd == "alphaswitch")
      switchUWearAlpha();
    else if (dest == UWEAR && cmd == "on") 
      setUWearAlphaFull( TRUE );       
    else if (dest == UWEAR && cmd == "off")  
      setUWearAlphaFull( FALSE );                
    if (dest == UWEAR && cmd == "col" )  
      setUWearColor(llList2Vector( par, 2 ));             
    if (dest == UWEAR && cmd == "txt") { 
      setTexture( UWEARUP, llList2Key( par, 2 ) );
      setTexture( UWEARLOW, llList2Key( par, 3 ) );      
    }    
    else if ((dest == UWEARUP || dest == UWEARLOW) && cmd == "txt")  
      setTexture( dest, llList2Key( par, 2 ) );      
  }
} 