integer channel = 901238483;
integer findLink(string nm)
{
    integer i;
    for (i=2; i <= llGetNumberOfPrims(); i++)
    {
        if (llGetLinkName(i) == nm) return i;
    }
    return -1;
}

list decodeList(list tk) {
    integer i;
    list out =[];
    for (i=0; i < llGetListLength(tk); i+=2) {
        string c = llStringTrim( llList2String(tk, i), STRING_TRIM );
        if (c =="I") out += llList2Integer(tk, i+1);
        else if (c =="V") out += llList2Vector(tk, i+1);
        else if (c =="R") out += llList2Rot(tk, i+1);
        else if (c =="K") out += llList2Key(tk, i+1);
        else if (c =="F") out += llList2Float(tk, i+1);
        else if (c =="S") out += llList2String(tk, i+1);
    }
    return out;
}

default
{
    state_entry()
    {

        llListen(channel, "", "", "");
    }
    
    
    on_rez(integer n)
    {
        llResetScript();
    }
    
    listen(integer c, string n, key id, string m)
    {

        if (llGetOwnerKey(id) != llGetOwner()) return;

        list l = llParseString2List(m, "#", []);
        string cmd = llList2String(l,0);
        string part = llList2String(l,1);
        integer face = llList2Integer(l,2);
        
        if (cmd == "show" || cmd == "hide")
        {

            //llOwnerSay("PART="+part);
            
            float alpha = 0.;
            if (cmd == "show") alpha = 1.;
            
            integer ln = findLink(part+"_tat");
            if (ln>0)llSetLinkAlpha( ln, alpha, face);
            
            ln = findLink(part+"_skin");
            if (ln>0)llSetLinkAlpha( ln, alpha, face);
        }
        else if (cmd == "skinprimparams" )
        {
            llSetLinkPrimitiveParamsFast( (integer)part, decodeList( llList2List(l, 3, -1) )  );
        }
        else if (cmd == "skincolor" )
        {
            llSetLinkPrimitiveParams( LINK_ALL_CHILDREN, [PRIM_COLOR, ALL_SIDES, (vector)part, 1.0] );
        }
        else if (cmd == "parttexture")  // whole linkset skin
        {
            integer ln = findLink(part);
            integer f = face;
            if (face < 0) face = ALL_SIDES;
            if (ln >0)  llSetLinkTexture(ln, llList2String(l, 3), face);
        }
        else if (cmd == "partalpha")  // whole linkset skin
        {
            integer ln = findLink(part);
            integer f = face;
            if (face < 0) face = ALL_SIDES;
            if (ln >0)  llSetLinkAlpha(ln, llList2Float(l, 3), face);
        }

        else if (cmd == "skin")
        {
            integer ln = findLink(part+"_skin");

            if (ln >0)
                llSetLinkTexture(ln, llList2String(l, 3), face);
    
        }
        else if (cmd == "tattoo")
        {
            integer ln = findLink(part+"_tat");
            if (ln >0)
                llSetLinkTexture(ln, llList2String(l, 3), face);
        }

    }
    
} 