//start_unprocessed_text
/*/|/Brought to you by Chilli Bean@Foundation Grid 2020
/|/Sharing is Caring! Keep Opensim Free!

integer interval = 5;

list animations;

list GetAnimations()
{
    integer i;
    integer count = llGetInventoryNumber(INVENTORY_ALL);
    list temp_anims;
    for(i = 0; i < count; ++i)
    {
        string name = llGetInventoryName(INVENTORY_ALL,i);
        integer type = llGetInventoryType(name);
        if(type == INVENTORY_ANIMATION)
        {
            temp_anims += name;
        }
    }
    return temp_anims;
}

StopAnimation()
{
    list anims = GetAnimations();
    integer anim_count = llGetListLength(anims);
    if(anim_count > 0)
    {
        integer i;
        integer count = anim_count;
        for(i = 0; i < count; ++i)
        {
            llStopObjectAnimation(llList2String(anims,i));
        }
    }
}

integer counter;
integer anim_index = 0;

default
{
    state_entry()
    {
        animations = GetAnimations();
        if(llGetListLength(animations) >= 2)
        {            
            llStartObjectAnimation(llList2String(animations,anim_index));
            llSetTimerEvent(interval);
        }
        else
        {
            llOwnerSay("2 animations or more required.");
        }
    }
    changed(integer change)
    {
        if(change & CHANGED_INVENTORY)
        {
            StopAnimation();
            llResetScript();
        }
    }
    timer()
    {
        anim_index = (anim_index + 1) % llGetListLength(animations);
        StopAnimation();
        llStartObjectAnimation(llList2String(animations,anim_index));
    }
}
*/
//end_unprocessed_text
//nfo_preprocessor_version 0
//program_version Firestorm-Betax64 6.4.5.60799 - Chilli Bean
//last_compiled 10/20/2020 02:05:53
//mono







integer interval = 5;

list animations;
integer anim_index = 0;

StopAnimation()
{
    list anims = GetAnimations();
    integer anim_count = llGetListLength(anims);
    if(anim_count > 0)
    {
        integer i;
        integer count = anim_count;
        for(i = 0; i < count; ++i)
        {
            llStopObjectAnimation(llList2String(anims,i));
        }
    }
}

list GetAnimations()
{
    integer i;
    integer count = llGetInventoryNumber(INVENTORY_ALL);
    list temp_anims;
    for(i = 0; i < count; ++i)
    {
        string name = llGetInventoryName(INVENTORY_ALL,i);
        integer type = llGetInventoryType(name);
        if(type == INVENTORY_ANIMATION)
        {
            temp_anims += name;
        }
    }
    return temp_anims;
}

default
{
    state_entry()
    {
        animations = GetAnimations();
        if(llGetListLength(animations) >= 2)
        {            
            llStartObjectAnimation(llList2String(animations,anim_index));
            llSetTimerEvent(interval);
        }
        else
        {
            llOwnerSay("2 animations or more required.");
        }
    }
    changed(integer change)
    {
        if(change & CHANGED_INVENTORY)
        {
            StopAnimation();
            llResetScript();
        }
    }
    timer()
    {
        anim_index = (anim_index + 1) % llGetListLength(animations);
        StopAnimation();
        llStartObjectAnimation(llList2String(animations,anim_index));
    }
}

 