//==================================================
//  LockGuard V2 Building - Source Example
//================================================== 

    //
    // A few people have asked me to do an example of how to implement the LockGuard V2 Script 
    // as something they work with to actually create furniture with, without
    // writing any scripts at all. I know what it's like to be a non-scripter, so, I'm going to
    // toss this poseball script out there for non-scripters. It should be easy for you to modify,
    // as its fully commented.... and I've put as many of the options as I could in variables so
    // you don't have to actually hunt through the code itself to find what you need to change.
    // 
    // Now, the actual V2 Builder (as of Sept 29, 2006) is in progress and due for release
    // within the week. 
    //
    // But, what good are LockGuard V2 Scripts to people who can't script "at all"?
    //
    // In order to balance the open source nature of the LockGuard V2 Script itself and make it
    // even more accessible, I'm releasing this Basic LockGuard Builder Script Kit with full permissions. 
    // It contains a basic open source poseball, and open source attachment points, fully commented, 
    // which take you on a step by step journey on developing with LockGuard.
    //
    // Basically, you should be able to take this kit, compile it, link it to your furniture and
    // have immediate results.
    //
    // A few things to remember when using these scripts.....
    //
    //      1. You HAVE to link the poseball and the attachment points with your furniture.
    //      2. This is very basic code, there's no advanced features or notecard loading, etc.
    //      3. Make sure you have your attachment points and set up correctly! :)
    //
    // So, here we go! Here is your basic poseball. :)

//==================================================
// variables
//==================================================

        //
        // These are all the variables which control the poseball's options. You should be able
        // to change whatever you want here, and get the results you're looking for. Anything
        // above basic poseball functions, you'll actually have to change the code. :)
        //

    vector      vTitleColor                 = <1,1,1>;      // What color do youw ant your floating text to be? R/G/B
    float       fTitleOpacity               = 1;            // What opacity do you want it to be? 0 = invis, 1 = fully seen.
    string      szTitle                     = "";        // The floating text will be set to this.
    string      szSitText                   = "Sit";        // The pie menu will be set to this.
    
    string      szAnimation                 = "rockinghorse";    // This is the name of the animation to use.
    
    vector      vSitTarget                  = <0,0,0.1>;    // This is the sit target, relative of the poseball.
    vector      vSitRotation                = <0,0,0>;      // This is the sit rotation, its X/Y/Z axis.
    
    integer     nAlwaysShow                 = FALSE;        // Always show the poseball, no hiding.
    integer     nAlwaysHide                 = FALSE;        // Always hide the poseball, never show it. (Why?)

    
        
            
    key         kAvatar                     = NULL_KEY;     // Don't change this.                        
    integer     nAnimating                  = FALSE;        // Don't change this either! The animating flag just gets rid
                                                            // of script error messages when linking. :)
    
    //
    // Unless there's a reason, you don't need to modify anything below this line. :)
    //

//==================================================
// default
//==================================================


default
{
    
    //====================
    // state_entry
    //====================
 
    state_entry()
    {
        
        //
        // Adjust our menu.
        //
        
        llSetSitText( szSitText );
        
        //
        // Set up our sit target and rotation.
        //
        
        llSitTarget( vSitTarget, llEuler2Rot( vSitRotation * DEG_TO_RAD ) );
        
        //
        // Show or hide, depending on the options you've chosen.
        // If both are false, then the poseball will appear and disappear as needed.
        //
        
        if( nAlwaysShow == TRUE || nAlwaysHide == FALSE  )
        {
            
            llSetAlpha( 1, ALL_SIDES );
            llSetText( szTitle, vTitleColor, fTitleOpacity );
            
        } else if( nAlwaysHide == TRUE )
        {
            
            llSetAlpha( 0, ALL_SIDES );
            llSetText( "", <1,1,1>, 1 );
            
        }
        
    }
    
    //====================
    // changed
    //====================
    
    changed( integer change )
    {
        
        if( change & CHANGED_LINK )
        {
            
            //
            // Check to see if our arse is being planted on this poseball.
            //
            
            kAvatar = llAvatarOnSitTarget();
            
            if( kAvatar != NULL_KEY )
            {
               
                //
                // Yes it is, so let's request our animation permissions.
                //
                  
                llRequestPermissions( kAvatar, PERMISSION_TRIGGER_ANIMATION );
                
            } else
            {
                
                //
                // No, apparantly we're standing up now, got tired of sitting down, did we?
                //
                
                kAvatar = NULL_KEY;
                
                //
                // Since we're standing now, we might as well get rid of our chains.
                // Send a link message to unlink the attachment points.
                //
                //
                // Kill the animation, it's no longer needed if we're standing.
                //
                
                if( nAnimating == TRUE )
                {
                    
                    llMessageLinked( LINK_ALL_OTHERS, 0, "unlink", NULL_KEY );
                    llStopAnimation( szAnimation );
                    nAnimating = FALSE;
                    
                }
                
                //
                // Again, show the poseball if necessary, or keep it hidden.
                //
                
                if( nAlwaysShow == TRUE || nAlwaysHide == FALSE  )
                {
                    
                    llSetAlpha( 1, ALL_SIDES );
                    llSetText( szTitle, vTitleColor, fTitleOpacity );
                    
                } else if( nAlwaysHide == TRUE )
            {
                    
                    llSetAlpha( 0, ALL_SIDES );
                    llSetText( "", <1,1,1>, 1 );
                    
                }                
                
            }
            
        }
        
    }
            
    //====================
    // run_time_permissions
    //====================
                        
    run_time_permissions( integer permissions )
    {
        
        if( ( permissions & PERMISSION_TRIGGER_ANIMATION ) == PERMISSION_TRIGGER_ANIMATION )
        {
            
            if( nAlwaysShow == FALSE )
            {
                
                llSetAlpha( 0, ALL_SIDES );
                llSetText( "", <1,1,1>, 1 );
                
            }
                
            //
            // Let's get the LockGuard chains connected, we do this before we start the animation because
            // of the slight delay there is while particles travel from point A to point B. By the time
            // the animation has started and you're on the poseball, the chains should be linked. Hopefully. :)
            //
            // This message goes to the attachment points, which in turn call the LockGuard attachments.
            //
            
            llMessageLinked( LINK_ALL_OTHERS, 0, "link " + (string)kAvatar, NULL_KEY ); 
                
            // Stop teh sit and start teh animation. Someone really savvy could poll through all the running
            // animations and turn them off. :P

            llStopAnimation( "sit" );
            llStartAnimation( szAnimation );
            nAnimating = TRUE;
            
        }
        
    }
    
    touch_start(integer nb)
    {
     llSay(501,"fsit");   
    }
    
    collision_start(integer nb)
    {
    llSay(501,"fsit");
    llSay(0,"Bump!");
    }
}
