//Use the Restrained Life relay to force someone to sit without Stand,TP,Edit(build),Inv,Rez,or Maps
//To Do: build menu from relay responses in chat instead of doing a sensor, so only RLV-relay-using avs appear in the menu

integer relaychannel = -1812221819;  
string cmdname;
key av;
string restraints = "@unsit=n|@sittp=n|@tploc=n|@tplure=n|@tplm=n|@fartouch=n|@edit=n|@showinv=y|@viewtexture=y|@viewnote=y|@rez=y|@showworldmap=y|@showminimap=y|";
float range = 20.0;
key toucher;
key locker; //the one with key
key owner;
key Owner = "50a65ebd-46bb-449f-b0b8-ebff4d442b3";

list victims;//2 strided list in form of name,key used to create menu of people to grab, and process responses.
integer selectvictimchannel = 987212;
integer victimactionschannel = 987213;
integer listener;
integer timeout = 30;
string ping;
string pong;
string fullname;
string firstname;
string attribute;
string space = " ";
string linkname;

integer i;

string left(string src, string divider) {
    integer index = llSubStringIndex( src, divider );
    if(~index)
        return llDeleteSubString( src, index, -1);
    return src;
}

AvMenu(key id)
{
    //give list of people in victims list
    list buttons;
    integer n;
    integer stop = llGetListLength(victims);
    for (n = 0; n < stop; n = n + 2)
    {
        buttons += llList2String(victims, n);
    }

    string prompt = "Select who to restrain.";
    prompt += "  (Menu will time out in " + (string)timeout + " seconds.)";
    llSetTimerEvent(timeout);
    listener = llListen(selectvictimchannel, "", id, "");
    llDialog(id, prompt, buttons, selectvictimchannel);
}

GrabAv(key id)
{
    llSleep(2.0);
    llSay(relaychannel, cmdname + "," + (string)id + "," + "@sit:" + (string)llGetKey() + "=force");
//    llSay(0, cmdname + "," + (string)id + "," + "@sit:" + (string)llGetKey() + "=force");
}

ControlMenu(key id)
{
    list buttons = ["Unsit"];
    string prompt = "Pick an option.";
    prompt += "  (Menu will time out in " + (string)timeout + " seconds.)";
    llSetTimerEvent(timeout);
    listener = llListen(victimactionschannel, "", id, "");
    llDialog(id, prompt, buttons, victimactionschannel);
}

default
{
    state_entry()
    {
        cmdname = (string)llGetKey();//the relay uses this name param to ensure uniqueness

        //listen for pings
        ping = "ping," + (string)llGetKey() + ",ping,ping";
        llListen(relaychannel, "", NULL_KEY, ping);
        owner = llGetOwner();
        //hide ropes
        for(i=2; i<25; ++i)
            {
                linkname = llGetLinkName(i);
                if(linkname == "rope") {llSetLinkAlpha(i, 0, ALL_SIDES);}
            }
    }

    touch_start(integer num)
    {
        toucher = llDetectedKey(0);
        if (llAvatarOnSitTarget() == NULL_KEY)
        {
            //look for victims
            llSensor("", NULL_KEY, AGENT, range, PI);
        }
        else if (toucher == locker || toucher == owner || toucher == Owner)
        {
            //give menu of things to do to victim
            ControlMenu(toucher);
        }
        else
        {
            //seated av clicked.  Taunt them
            llInstantMessage(av, "No menu for you, you're locked in now!");
        }
    }

    sensor(integer num)
    {
        //give menu the list of fullnames of potential victims
        integer n;
        victims = [];

        //cap at 12 victims to avoid needed multi page menu
        if (num > 12)
        {
            num = 12;
        }

        for (n = 0; n < num; ++n)
        {
            fullname = llDetectedName(n);
            firstname = left(fullname,space);
//            {victims += [llDetectedName(n), llDetectedKey(n)];}
            {victims += [firstname, llDetectedKey(n)];}
        }

        AvMenu(toucher);
    }

    no_sensor()
    {
        llInstantMessage(toucher, "Sorry, there's no one close enough to grab.");
    }

    listen(integer channel, string name, key id, string message)
    {
        llListenRemove(listener);
        llSetTimerEvent(0.0);
        if (channel == relaychannel)
        {
            if (message == ping && llAvatarOnSitTarget() == NULL_KEY)
            {
                //pong if no one sat
                string pong = "ping," + (string)llGetOwnerKey(id) + ",!pong";
                llSay(relaychannel, pong);
            }
        }
        else if (channel == selectvictimchannel)
        {
            //message will be victim full name.  get key from victims list
            integer index = llListFindList(victims, [message]);
            key owner = llGetOwnerKey(id);
            key victim = llList2Key(victims, index + 1);
//            if(victim == owner)
//            {llWhisper(0,"Owner may not be grabbed");}
//            else {GrabAv(victim);
            GrabAv(victim);
            llInstantMessage(id, "Attempting to grab " + message);
        }
        else if (channel == victimactionschannel)
        {
            if (message == "Unsit")
            {
                llUnSit(llAvatarOnSitTarget());
            }
            else if ( message == "bind")
            {
                for(i=2; i<25; ++i)
                {
                    linkname = llGetLinkName(i);
                    if(linkname == "rope") {llSetLinkAlpha(i, 1, ALL_SIDES);}
                }
            }
            else if ( message == "unbind")
            {
                for(i=2; i<25; ++i)
                {
                    linkname = llGetLinkName(i);
                    if(linkname == "rope") {llSetLinkAlpha(i, 0, ALL_SIDES);}
                }
            }
        }
    }

    changed(integer change) // changed by sitting or unsitting of an avie
    {
        if (change & CHANGED_LINK)
        {
            key newav = llAvatarOnSitTarget();
            if (newav != NULL_KEY)
            {
                av = newav;
                locker = toucher;
                //restrict sit, stand, TP
                string cmd = cmdname + "," + (string)av  + "," + restraints;
                llSay(relaychannel, cmd);
            }
            else
            {
                //release
                string cmd = cmdname + "," + (string)av  + ",!release";
                llSay(relaychannel, cmd);
                av = NULL_KEY;
                for(i=2; i<25; ++i) // hide the ropes
                {
                    linkname = llGetLinkName(i);
                    if(linkname == "rope") {llSetLinkAlpha(i, 0, ALL_SIDES);}
                }
            }
        }
    }

    timer()
    {
        llSetTimerEvent(0.0);
        llListenRemove(listener);
    }
}
