///////////////////////////////////////////////////////////////////////////////
// Builders' Buddy 1.9 (Component Pieces)
// by Newfie Pendragon, March 2006
//
// This script is distributed with permission that it may be used in
// any way, or may be further modified/included in resale items.
// HOWEVER, if this script is used as part of a for-sale product,
// it is required that appropriate credit be given to Newfie for
// the script (or portions used in derivatives).  That's a fair price
// in exchange for unlimited use of this script, dontcha think?
//
//  SL Forum thread and new versions found here:
//  http://forums.secondlife.com/showthread.php?t=96792
///////////////////////////////////////////////////////////////////////////////
// INSTRUCTIONS
//  This is the *Component Piece* half of the Builders' Buddy system.
//  Drop it into each 'piece' of the building.  Drop the Base Prim Script
//  into the prim  that will be the container/box that will be used to
//  store the building once completed.  It can be in each individual
//  prim, but if you link as much as possible (and put the script in the link
//  set), it'll be much more neighbourly and less strain on the sim.
//
// QUICK USE:
//  - Drop this script in the Base.
//  - Drop the "Component" Script in each building part.
//  - Touch  your Base, and choose RECORD
//  - Take all building parts into inventory
//  - Drag building parts from inventory into Base Prim
//  - Touch your base and choose BUILD
//
///////////////////////////////////////////////////////////////////////////////
//  History
//
// v1.0 - 20060328 - Newfie Pendragon - Original Version
// v1.5 - 20060612 - Androclese Antonelli
//        - (See base script for details)
// v1.6 - 20060624 - Newfie Pendragon
//      - Added active repositioning (pieces move as the base piece moves)
//      - Pieces use WarpPos technique to instantanetly move large distances
//        - Pieces no longer move until the the "Record" option has been used
//        at least once
//      - Pieces will not move if base is not same owner as the pieces
//      - Pieces no longer 'bounce' when hitting the ground
// v1.7 - 20060821 - Correction for non-zero rotation (thanks Ed44 Gupta!)
// v1.9 - 20070630 - Added check to keep within sim edges
///////////////////////////////////////////////////////////////////////////////
 
//////////////////////////////////////////////////////////////////////////////////////////
// Configurable Settings
float fTimerInterval = 0.25;     // Time in seconds between movement 'ticks'
integer PRIMCHAN = -19730611;    // Channel used by Base Prim to talk to Component Prims;
                                 // ***THIS MUST MATCH IN BOTH SCRIPTS!***
 
//////////////////////////////////////////////////////////////////////////////////////////
// Runtime Variables (Dont need to change below here unless making a derivative)
vector vOffset;
rotation rRotation;
integer bNeedMove;
vector vDestPos;
rotation rDestRot;
integer bRecorded = FALSE;
 
 
////////////////////////////////////////////////////////////////////////////////
string first_word(string In_String, string Token)
{
    //This routine searches for the first word in a string,
    // and returns it.  If no word boundary found, returns
    // the whole string.
    if(Token == "") Token = " ";
    integer pos = llSubStringIndex(In_String, Token);
 
    //Found it?
    if( pos >= 1 )
        return llGetSubString(In_String, 0, pos - 1);
    else
        return In_String;
}
 
////////////////////////////////////////////////////////////////////////////////
string other_words(string In_String, string Token)
{
    //This routine searches for the other-than-first words in a string,
    // and returns it.  If no word boundary found, returns
    // the an empty string.
    if( Token == "" ) Token = " ";
 
    integer pos = llSubStringIndex(In_String, Token);
 
    //Found it?
    if( pos >= 1 )
        return llGetSubString(In_String, pos + 1, llStringLength(In_String));
    else
        return "";
}
 
////////////////////////////////////////////////////////////////////////////////
do_move()
{
    integer i = 0;
    vector vLastPos = ZERO_VECTOR;
    while( (i < 5) && (llGetPos() != vDestPos) )
    {
        list lParams = [];
 
        //If we're not there....
        if( llGetPos() != vDestPos )
        {
            //We may be stuck on the ground...
            //Did we move at all compared to last loop?
            if( llGetPos() == vLastPos )
            {
                //Yep, stuck...move straight up 10m (attempt to dislodge)
                lParams = [ PRIM_POSITION, llGetPos() + <0, 0, 10.0> ];
                //llSetPos(llGetPos() + <0, 0, 10.0>);
            } else {
                //Record our spot for 'stuck' detection
                vLastPos = llGetPos();
            }
        }
 
        //Try to move to destination
        //Upgraded to attempt to use the llSetPrimitiveParams fast-move hack
        //(Newfie, June 2006)
        integer iHops = llAbs(llCeil(llVecDist(llGetPos(), vDestPos) / 10.0));
        integer x;
        for( x = 0; x < iHops; x++ ) {
            lParams += [ PRIM_POSITION, vDestPos ];
        }
        llSetPrimitiveParams(lParams);
        //llSleep(0.1);
        i++;
    }
 
    //Set rotation
    llSetRot(rDestRot);
}
 
 
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
default
{
    //////////////////////////////////////////////////////////////////////////////////////////
    state_entry()
    {
        //Open up the listener
        llListen(PRIMCHAN, "", NULL_KEY, "");
    }
 
    //////////////////////////////////////////////////////////////////////////////////////////
    on_rez(integer iStart)
    {
        //Set the channel to what's specified
        if( iStart != 0 )
        {
            PRIMCHAN = iStart;
            state reset_listeners;
        }
    }
 
    //////////////////////////////////////////////////////////////////////////////////////////
    listen(integer iChan, string sName, key kID, string sText)
    {
        string sCmd = llToUpper(first_word(sText, " "));
 
        if( sCmd == "RECORD" )
        {
            sText = other_words(sText, " ");
            list lParams = llParseString2List(sText, [ "|" ], []);
            vector vBase = (vector)llList2String(lParams, 0);
            rotation rBase = (rotation)llList2String(lParams, 1);
 
            vOffset = (llGetPos() - vBase) / rBase;
            rRotation = llGetRot() / rBase;
            bRecorded = TRUE;
            llOwnerSay("Recorded position.");
            return;
        }
 
        //////////////////////////////////////////////////////////////////////////////////////////
        if( sCmd == "MOVE" )
        {
            //Don't move if we've not yet recorded a position
            if( !bRecorded ) return;
 
            //Also ignore commands from bases with a different owner than us
            //(Anti-hacking measure)
            if( llGetOwner() != llGetOwnerKey(kID) ) return;
 
 
            //Calculate our destination position
            sText = other_words(sText, " ");
            list lParams = llParseString2List(sText, [ "|" ], []);
            vector vBase = (vector)llList2String(lParams, 0);
            rotation rBase = (rotation)llList2String(lParams, 1);
 
            //Calculate our destination position
            vDestPos = (vOffset * rBase) + vBase;
            rDestRot = rRotation * rBase;
 
            //Make sure our calculated position is within the sim
            if(vDestPos.x < 0.0) vDestPos.x = 0.0;
            if(vDestPos.x > 255.0) vDestPos.x = 255.0;
            if(vDestPos.y < 0.0) vDestPos.y = 0.0;
            if(vDestPos.y > 255.0) vDestPos.y = 255.0;
            if(vDestPos.x > 768.0) vDestPos.x = 768.0;
 
            //Turn on our timer to perform the move?
            if( !bNeedMove )
            {
                llSetTimerEvent(fTimerInterval);
                bNeedMove = TRUE;
            }
            return;
        }
 
        //////////////////////////////////////////////////////////////////////////////////////////
        if( sCmd == "DONE" )
        {
            //We are done, remove script
            llRemoveInventory(llGetScriptName());
            return;
        }
 
        //////////////////////////////////////////////////////////////////////////////////////////
        if( sCmd == "CLEAN" )
        {
            //Clean up
            llDie();
            return;
        }
 
        //////////////////////////////////////////////////////////////////////////////////////////
        if( sCmd == "RESET" )
        {
            llResetScript();
        }
    }
 
    //////////////////////////////////////////////////////////////////////////////////////////
    timer()
    {
        //Turn ourselves off
        llSetTimerEvent(0.0);
 
        //Do we need to move?
        if( bNeedMove )
        {
            //Perform the move and clean up
            do_move();
            bNeedMove = FALSE;
        }
        return;
    }
}
 
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
state reset_listeners
{
    //////////////////////////////////////////////////////////////////////////////////////////
    state_entry()
    {
        state default;
    }
}
 