integer DEBUG = FALSE;

string STARTSOUND = "swing";
string STOPSOUND = "slap";

float STARTSOUNDVOL = 1.0;
float STOPSOUNDVOL = 0.5;

integer PTA = PERMISSION_TRIGGER_ANIMATION;
integer PTC = PERMISSION_TAKE_CONTROLS;

key MyController;
integer InAnimation = FALSE;
integer Listening = 0;

default
{    
    attach(key attached)
    {
        if (Listening) llListenRemove(Listening);
        MyController = attached;
        
        if (attached == NULL_KEY) {
            if (llGetPermissions() & PTA) {
                llStopAnimation("hold_R_handgun");
                return;
            }
        }
        
        llRequestPermissions(attached, PTA | PTC);
//        llRequestPermissions(attached, PTC);
        llSetTimerEvent(5);
    }
    
//    touch_start(integer total_count)
//    {
//        integer i;
//        for (i = 0; i < total_count; i++) {
//          if (llDetectedKey(i) == MyController) {
//                llStartAnimation("sword_strike_R");
//                InAnimation = TRUE;
//                llSetTimerEvent(0.4);
//            }
//        }
//    }
    
    timer()
    {
        if (InAnimation) {
            llStopAnimation("sword_strike_R");
            llTriggerSound(STOPSOUND, STOPSOUNDVOL);
            InAnimation = FALSE;
            llSetTimerEvent(0);
            return;
        }
        
        if ((llGetPermissions() & (PTA | PTC)) == (PTA | PTC)) {
            llStartAnimation("hold_R_handgun");
            llTakeControls(CONTROL_LBUTTON, TRUE, FALSE);
            llSetTimerEvent(0);
            llWhisper(0, "Paddle activated.  Type 'paddle release' to release controls");
            if (Listening) llListenRemove(Listening);
            Listening = llListen(0, "", MyController, "");
        } else {
            if (MyController != NULL_KEY) {
                llRequestPermissions(MyController, PTC | PTA);
            }
        }
    }
    
    control(key name, integer levels, integer edges)
    {
        if (InAnimation) return;
        
        if (((edges & CONTROL_LBUTTON) == CONTROL_LBUTTON) && ((levels & CONTROL_LBUTTON) == CONTROL_LBUTTON)) {
            llTriggerSound(STARTSOUND, STARTSOUNDVOL);
            llStartAnimation("sword_strike_R");
            InAnimation = TRUE;
            llSetTimerEvent(0.4);
        }
    }
    
    listen(integer channel, string name, key id, string message)
    {
        message = llToLower(message);
        
        if (message == "paddle release") {
            llReleaseControls();
            llWhisper(0, "Controls released.  Say 'paddle engage' to reactivate.");
            return;
        }
        
        if (message == "paddle engage") {
            InAnimation = FALSE;
            llSetTimerEvent(5);
        }
    }
} 