/* ************************************************************************** */
//
// tl Body MESH script 
// 
// by Thai Low @ endivatomic.eu:8002
//
// Provided under Creative Commons Attribution-Non-Commercial-ShareAlike 4.0 
//                International license.
//
// Please be sure you read and adhere to the terms of this license: 
//      https://creativecommons.org/licenses/by-nc-sa/4.0/
//
/* ************************************************************************** */

/* ************************************************************************** */
/*                    PARAMETERS                                              */ 
/* ************************************************************************** */

integer debug = TRUE;

integer cFEETFEET  = 1;
integer cFEETNAILS = 0;
integer cFEETSOCKS = 2;

/* ************************************************************************** */
/*                    DO NOT MODIFY UNDER THIS LINE                           */ 
/* ************************************************************************** */

// Body     0 / 29
// clothing 0 / 28
// Tattoo   0 / 28
// Underwear 0 / 28

string tALPHA = "8dcd4a48-2d37-4909-9f78-f7a9eb4ef903";

integer chbody;
integer chhandle;

// 
//  out debug message
// 
outDebug( string msg ) {
  if (debug) llOwnerSay( msg );
}

// 
//  Get a unique channel number (nearly unique)
// 
integer channel() {  
  return 0x80000000 | (integer)("0x"+llGetSubString((string)llGetOwner(),-4,-1));
}        

//
// find link number by name
//
integer name2link( string name ) {
  integer lnk = -1;    
  integer i = 1 + llGetNumberOfPrims();
  while( --i > 0 && lnk == -1 ) {
    if ( llGetLinkName(i) == name ) lnk = i;  
  }    
  return lnk;              
}

//
// return alpha value of the linked object face
//
float getLinkFaceAlpha( integer lnk, integer face ) {
  return llList2Float( llGetLinkPrimitiveParams( lnk, [PRIM_COLOR, face] ), 1 );     
}

float bool2alpha( integer val ) {
  if (val) return 1.0;
  return 0.0;
}

// 
// Remove all body alpha
//
removeBodyAlpha() {   
  integer i = 1 + llGetNumberOfPrims();
  while( --i > 0 ) {    
    if ( llGetSubString( llGetLinkName(i), 0, 3) == "Body" )      
      llSetLinkAlpha( i, 1.0, ALL_SIDES );          
  }
}

//
// ALPHA CMD 
// decode a cmd like BBBB:FF into parts:
//      BBBB = Body part name (es. Body10)
//      FF   = Face number (-1 = ALL_FACES)
//
bodySwitchAlpha( string par ) {
  list lpars = llParseString2List(par,[":"],[]);
  if ( llGetListLength( lpars ) < 2 ) return;
  
  integer lnk = name2link( llList2String( lpars, 0 ) );
  if ( lnk < 0 ) return;
  
  integer face = llList2Integer( lpars, 1 );   
  float alpha  = getLinkFaceAlpha( lnk, face );
  if ( alpha < 0.5 ) alpha = 1.0; else alpha = 0.0;
  llSetLinkAlpha( lnk, alpha, face );    
}

//
// SET SKIN COLOR
//
setSkinColor( vector col ) {
  integer i = 1 + llGetNumberOfPrims();
  while( --i > 0 ) {
    string name =  llGetSubString(llGetLinkName(i), 0, 3);                       
    if ( name == "Body" ) {     
      llSetLinkPrimitiveParamsFast( i, [PRIM_COLOR, ALL_SIDES, col, 1.0] );       
    }
    else if ( name == "Feet" ) {     
      float alpha = getLinkFaceAlpha( i, cFEETFEET );            
      llSetLinkPrimitiveParamsFast( i, [PRIM_COLOR, cFEETFEET, col, alpha] ); 
    }
    else if ( name == "Hand" ) {     
      float alpha = getLinkFaceAlpha( i, 2 );
      llSetLinkPrimitiveParamsFast( i, [PRIM_COLOR, 2, col, alpha] ); 
    }    
  }    
}

//
// Set texture on body parts
//
bodyULtexture( string texture, string ul ) {      

  integer lnk = 1 + llGetNumberOfPrims();
  while( --lnk > 0 ) {  
    string name = llGetLinkName( lnk );    

    if ( llGetSubString(name, 0, 3) == "Body" ) {
      integer p = (integer)llGetSubString(name, 4, -1);

      if ((ul == "u" && ( p < 8 || p > 25 )) ||
          (ul == "l" && ( p >= 8 && p <= 25 ))) {
        llSetLinkPrimitiveParamsFast( lnk, [PRIM_TEXTURE, ALL_SIDES, texture, <1,1,0>, <0,0,0>, 0] );
       //llSetLinkPrimitiveParamsFast( lnk, [PRIM_COLOR, ALL_SIDES, <1,1,1>, 1.0] );            
      }
    }
  }
}

//
// Set texture on hands
//
handsTexture( string texture ) {      

  integer lnk = 1 + llGetNumberOfPrims();
  while( --lnk > 0 ) {  
    if ( llGetLinkName( lnk ) == "Hand" ) {
      llSetLinkPrimitiveParamsFast( lnk, [PRIM_TEXTURE,2, texture, <1,1,0>, <0,0,0>, 0] );            
    }
  }
}

//
// Set texture on feet
//
feetTexture( string texture ) {      

  integer lnk = 1 + llGetNumberOfPrims();
  while( --lnk > 0 ) {    
    if ( llGetSubString(llGetLinkName( lnk ), 0, 3) == "Feet" ) {
      llSetLinkPrimitiveParamsFast( lnk, [PRIM_TEXTURE, cFEETFEET, texture, <1,1,0>, <0,0,0>, 0] );            
    }
  }
}

//
// Set texture on parts (not body)
//
setULtexture( string part, string texture, string ul ) {    
        
  integer plen = llStringLength( part );  

  integer lnk = 1 + llGetNumberOfPrims();
  while( --lnk > 0 ) {  
    string name = llToLower( llGetLinkName( lnk ) );    

    if ( llGetSubString(name, 0, plen-1) == part ) {
      string p = llGetSubString(name, plen, -1);

      if (ul == "ul" || ul == p ) {
        llSetLinkPrimitiveParamsFast( lnk, [PRIM_TEXTURE, ALL_SIDES, texture, <1,1,0>, <0,0,0>, 0] );
        llSetLinkPrimitiveParamsFast( lnk, [PRIM_COLOR, ALL_SIDES, <1,1,1>, 1.0] );            
      }
    }
  }
}

//
// Set Active Feet
//
setFeet( integer nr ) {    
  integer lnk = 1 + llGetNumberOfPrims();
  
  while( --lnk > 0 ) {  
    string name = llToLower( llGetLinkName( lnk ) );    

    if ( llGetSubString(name, 0, 3) == "feet" ) {
      integer p = (integer)llGetSubString(name, 4, -1);            
      llSetLinkAlpha( lnk, bool2alpha( p == nr ), cFEETNAILS );      
      llSetLinkAlpha( lnk, bool2alpha( p == nr ), cFEETFEET );   
      llSetLinkAlpha( lnk, bool2alpha( p == nr && (getLinkFaceAlpha( lnk, cFEETSOCKS ) >0.5) ), cFEETSOCKS );        
    }
  }
}

setSocksColor( vector col ) {
  integer lnk = 1 + llGetNumberOfPrims();
  
  while( --lnk > 0 ) {  
    string name = llToLower( llGetLinkName( lnk ) );    

    if ( llGetSubString(name, 0, 3) == "feet" ) {         
      llSetLinkPrimitiveParamsFast( lnk, [PRIM_COLOR, cFEETSOCKS, col, getLinkFaceAlpha( lnk, cFEETSOCKS )] );          
    }
  }    
}

setSocksTexture(  string texture ) {
  integer lnk = 1 + llGetNumberOfPrims();
  
  while( --lnk > 0 ) {  
    string name = llToLower( llGetLinkName( lnk ) );    

    if ( llGetSubString(name, 0, 3) == "feet" ) {      
       llSetLinkPrimitiveParamsFast( lnk, [PRIM_TEXTURE, cFEETSOCKS, texture, <1,1,0>, <0,0,0>, 0] );
    }
  }    
}

setSocksVisible( integer vis ) {    
  integer lnk = 1 + llGetNumberOfPrims();
  integer flnk = -1;
  integer feet0 = -1;
      
  while( --lnk > 0 ) {
    string name =  llToLower(llGetLinkName( lnk ));  
    if ( llGetSubString( name, 0, 3 ) == "feet" ) {               
      float act = getLinkFaceAlpha( lnk, cFEETFEET );
      if (act > 0.5) flnk = lnk;
      if (name == "feet0") feet0 = lnk;
      llSetLinkAlpha( lnk, bool2alpha( vis && act > 0.5 ), cFEETSOCKS );    
    }          
  }
  
  if (vis && flnk == -1 && feet0 != -1) 
    llSetLinkAlpha( feet0, 1, cFEETSOCKS );                  
}

setGlovesVisible( integer vis ) {    
  integer lnk = 1 + llGetNumberOfPrims();
  float alpha = bool2alpha( vis ); 
  
  while( --lnk > 0 ) {
    if ( llGetSubString( llToLower( llGetLinkName( lnk ) ), 0, 3 ) == "hand" )      
      llSetLinkAlpha( lnk, alpha, 4 );    
  }    
}

setGlovesColor( vector col ) {
  integer lnk = 1 + llGetNumberOfPrims();
    
  while( --lnk > 0 ) {  
    string name = llToLower( llGetLinkName( lnk ) );    

    if ( llGetSubString(name, 0, 3) == "hand" ) {
      float alpha = getLinkFaceAlpha( lnk, 4 );
      llSetLinkPrimitiveParamsFast( lnk, [PRIM_COLOR, 4, col, alpha] );          
    }
  }    
}

setGlovesTexture(  string texture ) {
  integer lnk = 1 + llGetNumberOfPrims();
    
  while( --lnk > 0 ) {  
    string name = llToLower( llGetLinkName( lnk ) );    

    if ( llGetSubString(name, 0, 3) == "hand" ) {      
       llSetLinkPrimitiveParamsFast( lnk, [PRIM_TEXTURE, 4, texture, <1,1,0>, <0,0,0>, 0] );
    }
  }    
}

setHandNailsColor( vector col ) {
  integer lnk = 1 + llGetNumberOfPrims();  
    
  while( --lnk > 0 ) {  
    string name = llToLower( llGetLinkName( lnk ) );    

    if ( llGetSubString(name, 0, 3) == "hand" ) {      
      llSetLinkPrimitiveParamsFast( lnk, [
        PRIM_COLOR, 0, col, getLinkFaceAlpha( lnk, 0 ),
        PRIM_COLOR, 1, col, getLinkFaceAlpha( lnk, 1 ),        
        PRIM_COLOR, 3, col, getLinkFaceAlpha( lnk, 3 )        
      ]);          
    }
  }    
}

setHandNailsTexture( string texture ) {
  integer lnk = 1 + llGetNumberOfPrims();  
  
  while( --lnk > 0 ) {  
    string name = llToLower( llGetLinkName( lnk ) );    

    if ( llGetSubString(name, 0, 3) == "hand" ) {     
      llSetLinkPrimitiveParamsFast( lnk, [
        PRIM_TEXTURE, 0, texture, <1,1,0>, <0,0,0>, 0,
        PRIM_TEXTURE, 1, texture, <1,1,0>, <0,0,0>, 0,
        PRIM_TEXTURE, 3, texture, <1,1,0>, <0,0,0>, 0        
      ] );         
    }
  }    
}

setFeetNailsColor( vector col ) {  
  integer lnk = 1 + llGetNumberOfPrims();
  
  while( --lnk > 0 ) {  
    string name = llToLower( llGetLinkName( lnk ) );    

    if ( llGetSubString(name, 0, 3) == "feet" ) {
      float alpha = getLinkFaceAlpha( lnk, cFEETNAILS );   
      llSetLinkPrimitiveParamsFast( lnk, [PRIM_COLOR, cFEETNAILS, col, alpha] );          
    }
  }    
}

setFeetNailsTexture( string texture ) {
  integer lnk = 1 + llGetNumberOfPrims();
  
  while( --lnk > 0 ) {  
    string name = llToLower( llGetLinkName( lnk ) );    

    if ( llGetSubString(name, 0, 3) == "feet" )      
      llSetLinkPrimitiveParamsFast( lnk, [PRIM_TEXTURE, cFEETNAILS, texture, <1,1,0>, <0,0,0>, 0] );    
  }    
}

setHandNailsLength( integer nr ) {   
  float alpha1 = bool2alpha( nr == 0 );
  float alpha2 = bool2alpha( nr == 1 );
  float alpha3 = bool2alpha( nr == 2 );               
  integer lnk  = 1 + llGetNumberOfPrims();
  
  while( --lnk > 0 ) {  
    string name = llToLower( llGetLinkName( lnk ) );    

    if ( llGetSubString(name, 0, 3) == "hand" ) {  
      llSetLinkAlpha( lnk, alpha1, 1 );   
      llSetLinkAlpha( lnk, alpha2, 3 );   
      llSetLinkAlpha( lnk, alpha3, 0 );   
    }
  }    
}

setFeetInvisible() {
  integer lnk  = 1 + llGetNumberOfPrims();
   
  while( --lnk > 0 ) {  
    string name = llToLower( llGetLinkName( lnk ) );    

    if ( llGetSubString(name, 0, 3) == "feet" ) { 
      llSetLinkAlpha( lnk, 0., cFEETFEET );       
      llSetLinkAlpha( lnk, 0., cFEETNAILS );      
    }    
  }        
}

setHandsVisible() {               
  integer lnk  = 1 + llGetNumberOfPrims();
  
  while( --lnk > 0 ) {  
    string name = llToLower( llGetLinkName( lnk ) );    

    if ( llGetSubString(name, 0, 3) == "hand" ) { 
      float alpha = getLinkFaceAlpha( lnk, 2 ); 
      if (alpha < 0.5) alpha = 1.; else alpha = 0.;
        
      llSetLinkAlpha( lnk, alpha, 0 );   
      llSetLinkAlpha( lnk, alpha, 1 );   
      llSetLinkAlpha( lnk, alpha, 2 );   
      llSetLinkAlpha( lnk, alpha, 3 );         
    }
  }    
}

//
// default event cycle
//
default {
    
  state_entry() {
    chbody   = channel();
    chhandle = llListen( chbody, "", NULL_KEY, "" );    
    outDebug( "Ready on: "+ (string)chbody);
    setSkinColor( <1,1,1> );
    setFeet( 2 );
    if ( debug ) {        
      setULtexture( "clothing", tALPHA, "ul" );  
      setULtexture( "tattoo", tALPHA, "ul" );  
      setULtexture( "underwear", tALPHA, "ul" ); 
      removeBodyAlpha();             
    }
  }
  
  listen( integer ch, string name, key id, string msg ) {         
    if ( ch != chbody ) return;   
    
    // switch commands (no params)
    if ( msg == "bodyreset" ) { removeBodyAlpha(); return; }
    if ( msg == "sockson" ) { setSocksVisible(TRUE); return; }
    if ( msg == "socksoff" ) { setSocksVisible(FALSE); return; }
    if ( msg == "gloveson" ) { setGlovesVisible(TRUE); return; }        
    if ( msg == "glovesoff" ) { setGlovesVisible(FALSE); return; } 
    if ( msg == "feetonoff") { setFeetInvisible(); return; }         
    if ( msg == "handsonoff") { setHandsVisible(); return; }          
        
    // Requests with params    
    integer i = llSubStringIndex(msg, "=");
    if ( i == -1 ) return;
    
    string cmd = llGetSubString(msg, 0, i - 1);
    string par = llGetSubString(msg, i + 1, -1);
       
    // set body alpha    
    if ( cmd == "alpha" ) { bodySwitchAlpha( par ); return; }        
        
    // set textures
    if ( cmd == "clothu" ) { setULtexture( "clothing", par, "u" ); return; }
    if ( cmd == "clothl" ) { setULtexture( "clothing", par, "l" ); return; }
    if ( cmd == "tattoou" ) { setULtexture( "tattoo", par, "u" ); return; }
    if ( cmd == "tattool" ) { setULtexture( "tattoo", par, "l" ); return; }
    if ( cmd == "underu" ) { setULtexture( "underwear", par, "u" ); return; }
    if ( cmd == "underl" ) { setULtexture( "underwear", par, "l" ); return; }
    if ( cmd == "skinu" ) { bodyULtexture( par, "u" ); return; }
    if ( cmd == "skinl" ) { bodyULtexture( par, "l" ); return; }
    if ( cmd == "handskin" ) { handsTexture( par ); return; }
    if ( cmd == "feetskin" ) { feetTexture( par ); return; }
    if ( cmd == "handnailt" ) { setHandNailsTexture( par ); return; }
    if ( cmd == "feetnailt" ) { setFeetNailsTexture( par ); return; }
    if ( cmd == "sockst" ) { setSocksTexture( par ); return; }
    if ( cmd == "glovest" ) { setGlovesTexture( par ); return; }     
        
    // nails & feet
    if ( cmd == "handnails" ) { setHandNailsLength( (integer)par ); return; }
    if ( cmd == "feetshape" ) { setFeet( (integer)par ); return; }
    
    // colors
    if ( cmd == "skinc" ) { setSkinColor( (vector)par ); return; }
    if ( cmd == "handnailc" ) { setHandNailsColor( (vector)par ); return; }
    if ( cmd == "feetnailc" ) { setFeetNailsColor( (vector)par ); return; }
    if ( cmd == "socksc" ) { setSocksColor( (vector)par ); return; }
    if ( cmd == "glovesc" ) { setGlovesColor( (vector)par ); return; } 
  }
  
  changed(integer mask) {
    if ( mask & CHANGED_OWNER ) llResetScript();    
  }  
} 