//How far in meters to travel in each direction.  Two or all three can be used for angled movement
//NOTE: when linked, this is relative to the root prim
//Positive = move north, negative = move south
float       NorthSouth = 0;
//Positive = move east, negative = move west
float       EastWest = -3.0;
//Positive = move up, negative = move down
float       UpDown = 0.0;

//The amount in seconds to stay open, set to 0 to not autoclose
float       Timer = 15.0;

//Sound to play on open, either a UUID or a name in the door contents
//if a name, it must be exact. Leave at "" for no sound
string      OpenSound = "";

//Volume to play open sound, 0.0 is same as no sound, 1.0 is max
float       OpenVol = 1.0;

//Sound to play on close, either a UUID or a name in the door contents
//if a name, it must be exact. Leave at "" for no sound
string      CloseSound = "";

//Volume to play close sound, 0.0 is same as no sound, 1.0 is max
float       CloseVol = 1.0;



//misc variables
vector      Pos;
vector      Offset;
integer     Open;
integer     x;


default
{
    state_entry()
    {
        Offset = <EastWest, NorthSouth, UpDown>;
    }
    
    touch_start(integer num)
    {
        for(x = 0; x < num; x++)
        {
            Open = !Open;
            if(Open)
            {
                Pos = llGetLocalPos();
                if(OpenSound != "") llTriggerSound(OpenSound, OpenVol);
                llSetPos(Pos + Offset);
                llSetTimerEvent(Timer);
            }else{
                if(CloseSound != "") llTriggerSound(CloseSound, CloseVol);
                llSetPos(Pos);
                llSetTimerEvent(0);
            }
        }
    }    
    
    on_rez(integer param)
    {
        llResetScript();
    }
    
    moving_end()
    {
        if(Open)
        {
            Open = 0;
            llSetTimerEvent(0.0);
        }
    }
    
    timer()
    {
        if(CloseSound != "") llTriggerSound(CloseSound, CloseVol);
        llSetPos(Pos);
        llSetTimerEvent(0);
        Open = 0;
    }
} 