//XEngine;lsl

// original script by Tiffany Sicling @ OSGrid / Hypergrid Project team
// Revised extensively by WhiteStar Magic @ HyperGrid-Supply-Centre OSGrid 
// =======================================================================
// The SHENGATE sysem is a single Point to Point mechanism and therefore much simpler than any other mechanism
// it uses osTeleportAgent to accomplish this TP process
// this must be enabled in your OpenSim.ini file
//
//
// =======================================================================
// MODFIFY following Fields
//string TARGET = "" + llGetObjectDesc() + "";
//string HoverTitle = TARGET; // for Hovertext over Portal
//
  fnRotateGate(integer linknumber,vector rotaxis,float speed ,float gain)
     {
        list omega_params = [linknumber,rotaxis,speed,gain];//[2,<0,0,1>,1,.1 ];
        list params;
        integer stride_length =4;
        integer max=llGetListLength(omega_params);
        
        integer i=0;
             while (i<max)
             {
                 integer n = llList2Integer(omega_params,i);
                 rotation rot = llList2Rot(llGetLinkPrimitiveParams(n,[PRIM_ROT_LOCAL]),0);
                 params+=[PRIM_LINK_TARGET]+[n]+[PRIM_OMEGA,llList2Vector(omega_params,(i+1))*rot]+llList2List(omega_params,(i+2),(i+3));
                 i+=stride_length;
             }
             llSetLinkPrimitiveParamsFast(LINK_SET,params);
             params = [];
         
         llSleep(0.5);         
         {
             llSetLinkPrimitiveParamsFast(LINK_SET,[PRIM_OMEGA,ZERO_VECTOR,0.0,0.0]);
         }
        llSleep(0.5);
    }
 

integer DEFAULTstate = FALSE;            // FALSE = OFF @ Startup
string  _notecard = "destinations";

integer chatChannel = 78;
string HELP_MSG = "touch for change destination and dial the gate or use chatchannel /78 to dial destination (Example: /78 3)";

list    _radioURLs;
list    _radioStations;
list    theStations;

integer _linenum = 0;
integer curStationOffset = 0;
integer stationChunk = 6;
integer curStationEnd = 5;
integer totalStations = 0;
integer dialogActive = 0;
integer curIdx  = -1;
string dispStationStr = "";

string NEXT_MSG = "Next >>";
string PREV_MSG = "<< Prev";
string LIST_MSG = "List";

string CUR_SET  = "c";
string ALL_SET  = "a";

list cmdNextChunk = [">>", "next", "Next", "Next >>"]; // NEXT_MSG]; opensim didnt like this line
list cmdPrevChunk = ["<<", "prev", "Prev", "<< Prev"]; // PREV_MSG]; opensim didnt like this line
list cmdLsCur     = ["ls", "list", "List"];             // LIST_MSG]; opensim didnt like this line
list cmdLsAll     = ["la", "listall"];
list cmdSearch    = ["s", "search"];

string newURL;
string newDesc;
float Verweildauer = 300;
//
//vector LandingPoint = <159, 45, 23>;     // Where you want the Avatar to arrive at
vector LookAt       = <0.0,0.0,180.0>;           // which way you want them facing. Avoid True North at ALL times (BUG THERE IN OS CODE)
//
//string TargetAddress = TARGET;                               // In-Grid Teleport (Region Name as defined in region.xml OR region.ini)
//string TargetAddress = "9996,9974";                                      // In-Grid Teleport (Grid Map Locations XXXX,YYYYY)
//string TargetAddress = "first-star.dyndns.org:9000:FirstStar_Station";    //HyperGrid Example (using DNSname:Port:RegionName)
//string TargetAddress = "IPaddress:Port:RegionName";                       // Hypergrid TP are also valid (IPaddress:Port:RegionName)
// ----------------------------------
// variable pour la communicaiton entre l'iris et la porte
// canal sur lequel l'iris et la porte vont communiquer... si plusieurs portes changer le canal.
// l'iris et la porte doivent avoir le meme canal
integer     channel = -125478; 
//
// =======================================================================
//
// DO NOT MODIFY BELOW Unless you KNOW LSL Scripting
// =================================================
// Global variables
//list visitor_list;
float range = 1.5; // in meters
float rate = 1.0; // in seconds
string EventHorizonLoopSound = "Event Horizon Loop";                        // Sound looped while the event horizon exists
//
list LastFewAgents;
//
reset_radio() {
    llSetText("Reading Adresses ....", // message to display
              <1,0,0>, // color: <red,green,blue>
              1.0 ); // 1.0 = 100% opaque, 0.0 = transparent
    llListen(78, "", "", "");
    curStationOffset = 0;
    curStationEnd = 5;
    _linenum = 0;
    dialogActive = 0;
    _radioURLs = [];
    _radioStations = [];
    totalStations = 0;
    curIdx = -1;
    dispStationStr = "";
    llGetNotecardLine(_notecard, _linenum);
}
//
add_station(string line) {
    list words = llParseString2List(line, [" ", " ", "="], []);
    if (llGetListLength(words) < 2) {
        return;
    }
    string url = llList2String(words, llGetListLength(words) - 1);
    string station = "";
    integer i;

    for (i=0; i<llGetListLength(words) - 1; i++) {
        if (llStringLength(station) > 0) {
            station += " ";
        }
        station += llList2String(words, i);
    }
    _radioURLs += [url]; // was http://;
    _radioStations += [station];
}

curStations() {
    theStations = [PREV_MSG, LIST_MSG, NEXT_MSG];

    integer i;
    dispStationStr = "";

   // llWhisper(0, "offset: " + (string)curStationOffset);
    // llWhisper(0, "end: " + (string)curStationEnd);
                
    for (i = curStationOffset; i <= curStationEnd; i++) {
        if (curIdx == i) {
            dispStationStr += "*";   
        } else {
            dispStationStr += "  ";   
        }
        dispStationStr += (string) (i + 1) + ") ";
        dispStationStr += llList2String(_radioStations, i);
        dispStationStr += "\n";
        
        theStations += (string)(i + 1);
    }
}


doNextSet() {
    curStationOffset += stationChunk;
    curStationEnd = curStationOffset + (stationChunk - 1);
    
    if (curStationOffset >= totalStations) {
        curStationOffset = 0;
        curStationEnd = curStationOffset + (stationChunk - 1);  
    }
    
    if (curStationEnd >= totalStations) {
        curStationEnd = totalStations - 1;   
    }
}


doPrevSet() {
    if (curStationOffset > 1  && ((curStationOffset - stationChunk) < 1)) {
        curStationOffset = 0;
    } else {
        curStationOffset -= stationChunk;
    }

    curStationEnd = curStationOffset + (stationChunk - 1);
    
    if (curStationEnd >= totalStations) {
        curStationEnd = totalStations - 1;   
    }
    
    if (curStationOffset < 0) {
        curStationEnd = totalStations - 1;
        curStationOffset = totalStations - (stationChunk - 1);  
    }
}

doListStations(string mode) {
    integer i;
    integer startPos;
    integer endPos;
    
    if (mode == "a") {
        startPos = 0;
        endPos = totalStations - 1;   
    } else {
        startPos = curStationOffset;
        endPos = curStationEnd;
    }
    
    for (i = startPos; i <= endPos; i++) {
        string newURL = llList2String(_radioURLs, i);
        string newDesc = llList2String(_radioStations, i);
        llSay(0, (string)(i + 1) + ": " + newDesc + " = " + newURL);
    }   
}


doSearch(string theTerm) {
    integer i;
    
    llSay(0, "the term is " + theTerm);
    
    for (i = 0; i < totalStations; i++) {
        string curString = llList2String(_radioStations, i);
        if (llSubStringIndex(curString, theTerm) != -1) {
            string newURL = llList2String(_radioURLs, i);
            llSay(0, (string)(i + 1) + ": " + curString + " = " + newURL); 
        }
    }  
}
//
PerformTeleport( key AgentToTP )
{
    integer CurrentTime = llGetUnixTime();
    integer AgentIndex = llListFindList( LastFewAgents, [ AgentToTP ] );           // Is the agent we're teleporting already in the list?
    if (AgentIndex != -1)                                                          // If yes, check to make sure it's been > 5 seconds
    {
        integer PreviousTime = llList2Integer( LastFewAgents, AgentIndex+1 );      // Get the last time they were teleported
        if (PreviousTime >= (CurrentTime - 5)) return;                             // Less than five seconds ago? Exit without teleporting
        LastFewAgents = llDeleteSubList( LastFewAgents, AgentIndex, AgentIndex+1); // Delete the agent from the list
    }
    LastFewAgents += [ AgentToTP, CurrentTime ];                                   // Add the agent and current time to the list
    osTeleportAgent( AgentToTP, llGetObjectName(), llGetObjectDesc(), LookAt );                          // Teleport agent to their target
    llSleep(5.0);
    llResetScript();
}
//
RESET_VOL_DET()
{
    // THIS IS A PATCH.  Resets the Volume Detection as it is borked in OS
    llVolumeDetect( 1 ); // turn off volume detection
    llVolumeDetect( 0 ); // turn it back on again
}
// PARTICLE EMMISSIONS EFFECTS
PARTICLES()
{
    llParticleSystem(  [
    PSYS_SRC_TEXTURE, llGetInventoryName(INVENTORY_TEXTURE, 0),
    PSYS_PART_START_SCALE, < 0.6, 0.6, 0 >,
    PSYS_PART_END_SCALE, < 0.2, 0.2, 0 >,
    PSYS_PART_START_COLOR, <0.0,0.0,0.0>,
    PSYS_PART_END_COLOR, <1,1,1>,
    PSYS_PART_START_ALPHA, 0.0,
    PSYS_PART_END_ALPHA, 0.0,

    PSYS_SRC_BURST_PART_COUNT, 2,
    PSYS_SRC_BURST_RATE,  0.01,
    PSYS_PART_MAX_AGE, 1.3,
    PSYS_SRC_MAX_AGE, 0.0,
    
    PSYS_SRC_PATTERN, 4,    // 1=DROP, 2=EXPLODE, 4=ANGLE, 8=ANGLE_CONE,
    PSYS_SRC_ACCEL, <0.0,0.0,0.0>,

    PSYS_SRC_BURST_RADIUS, 1.4,
    PSYS_SRC_BURST_SPEED_MIN, 0,
    PSYS_SRC_BURST_SPEED_MAX, 0.00,

    PSYS_SRC_ANGLE_BEGIN,  0.0,
    PSYS_SRC_ANGLE_END, 180*DEG_TO_RAD,
    PSYS_SRC_OMEGA, <0,0,0>,

    PSYS_SRC_TARGET_KEY,  llGetKey(),    //llGetLinkKey(llGetLinkNum() + 1),

    PSYS_PART_FLAGS, ( 0
    | PSYS_PART_INTERP_COLOR_MASK
    | PSYS_PART_INTERP_SCALE_MASK
    | PSYS_PART_EMISSIVE_MASK
    | PSYS_PART_FOLLOW_VELOCITY_MASK
    // | PSYS_PART_WIND_MASK
    // | PSYS_PART_BOUNCE_MASK
    // | PSYS_PART_FOLLOW_SRC_MASK
    | PSYS_PART_TARGET_POS_MASK
    // | PSYS_PART_TARGET_LINEAR_MASK
    ) ] );
}

default
{
    on_rez(integer start_param)
    {
        llResetScript();
        reset_radio();
    }
    state_entry()
    {
        // run this code when entering the default state
        //llSetTexture( "40e1fdf5-b4c2-49f4-9512-afcd22576acb", ALL_SIDES);
        reset_radio();
        llParticleSystem([]);
        llMessageLinked(LINK_SET,2331,"","");
        llStopSound();    // Turn off the loop sound
        llPlaySound("SGCCloseWormhole", 1.0);
        llSetText("",<1,1,1>,1);
        //RESET_VOL_DET();
        //  DEFAULTS based on DEFAULTstate, TRUE = ON, FALSE = OFF on Startup
        if (DEFAULTstate) state on;
        else state off;
    }
}
state off
{
    state_entry()
    {
        // run this code when entering the default state
        //llSetTexture( "40e1fdf5-b4c2-49f4-9512-afcd22576acb", ALL_SIDES);
        llSetObjectName ("Pegasus Stargate Teleporting System V1.5a");
        llSetObjectDesc ("Chip Angel");
        reset_radio();
        llParticleSystem([]);
        llStopSound();    // Turn off the loop sound
        llPlaySound("SGCCloseWormhole", 1.0);
        llSay(0, "Deactivated." );
        llMessageLinked(LINK_SET,2331,"","");
        llSetText("",<1,1,1>,1);
    }
    changed(integer change) // something changed, take action
    {
        if(change & CHANGED_OWNER)
        {
            llOwnerSay("Owner Changed, Resetting Script");
            llResetScript();
        }
        if (change & CHANGED_INVENTORY) {
            reset_radio();
        }
        else if (change & 256) // that bit is set during a region restart
        {
            llResetScript();
        }
    }
    dataserver(key query_id, string data) {
        if (data != EOF) {
            add_station(data);
            _linenum++;
            
            if (_linenum % 5 == 0) {
                  llSetText("found: \n" + (string)_linenum + " adresses ...", // message to display
              <1,0,0>, // color: <red,green,blue>
              1.0 ); // 1.0 = 100% opaque, 0.0 = transparent    
            }
            llGetNotecardLine(_notecard, _linenum);
            return;
        }
        llListen(99, "", NULL_KEY, ""); 
        
        totalStations = llGetListLength(_radioURLs);        
        llSay(0, HELP_MSG);
        dialogActive = 1;
        llSetText("", <1,0,0>, 1.0 );
    }

    touch_start(integer touchNumber)
    {
        curStations();
        
        llDialog(llDetectedKey(0),
            dispStationStr,
            theStations, 99); 
    }
    
    listen(integer channel, string name, key id, string message) {

        if (dialogActive == 0) {
            llWhisper(0, " ... still loading adresses ...");
            return;   
        }
        
        if (message == "") {
            message = "cur";
        }
        
        
        list words = llParseString2List(message, [" ", " ", "="], []);        
        list testFind = llList2List(words, 0, 0);
               
        if (llListFindList(cmdNextChunk, testFind) != -1) {
            doNextSet();
            curStations();
            if (channel == chatChannel) {
                doListStations(CUR_SET);
            } else {
                llDialog(id, dispStationStr,theStations, 99);
            }
            return;  
        }
         
        else if (llListFindList(cmdPrevChunk, testFind) != -1) {
            doPrevSet();
            curStations();
            if (channel == chatChannel) {
                doListStations(CUR_SET);   
            } else {
                llDialog(id, dispStationStr, theStations, 99);
            }
            return;    
        }      
          
        else if (llListFindList(cmdSearch, testFind) != -1) {
            doSearch(message);
            return;    
        }
          
        else if (llListFindList(cmdLsAll, testFind) != -1) {
            doListStations(ALL_SET);
            return;  
        }
        
        
        else if (llListFindList(cmdLsCur, testFind) != -1) {
            doListStations(CUR_SET);
            return; 
        }
        

        else if ((integer)message > 0 && (integer)message < 256) {
            curIdx = (integer)message - 1;
            
            string newURL = llList2String(_radioURLs, curIdx);
            string newDesc = llList2String(_radioStations, curIdx);
            
            llSay(0, "setting adress and dialing gate...");
            llSay(0, newDesc + " = " + newURL);
            
            llSetObjectName (newDesc);
            llSetObjectDesc (newURL);
           
            state on;        // when touched, switch to state named 'on'
         }
    }
    
}

state on
{        
    state_entry()
    
       {
        PARTICLES();
        //llSensorRepeat( "", "", AGENT, range, TWO_PI, rate );
        //llSetTexture( "28842a4b-152c-47e1-9f41-2b36361a08b2", ALL_SIDES);
        llMessageLinked(LINK_SET,2341,"","");
        llPlaySound("SGCChevronIncomming", 1.0);
        fnRotateGate(101,<0,0,1>,4,.8);
        llSleep(1.2);
        llMessageLinked(LINK_SET,2342,"","");
        llPlaySound("SGCChevronIncomming", 1.0);
        fnRotateGate(101,<0,0,-1>,2,.4);
        llSleep(1.2);
        llMessageLinked(LINK_SET,2343,"","");
        llPlaySound("SGCChevronIncomming", 1.0);
        fnRotateGate(101,<0,0,1>,9,.7);
        llSleep(1.2);
        llMessageLinked(LINK_SET,2344,"","");
        llPlaySound("SGCChevronIncomming", 1.0);
        fnRotateGate(101,<0,0,-1>,15,.9);
        llSleep(1.2);
        llMessageLinked(LINK_SET,2345,"","");
        llPlaySound("SGCChevronIncomming", 1.0);
        fnRotateGate(101,<0,0,1>,4,.8);
        llSleep(1.2);
        llMessageLinked(LINK_SET,2346,"","");
        llPlaySound("SGCChevronIncomming", 1.0);
        fnRotateGate(101,<0,0,-1>,30,.9);
        llSleep(1.2);
        llPlaySound("SGCChevron", 1.0);
        fnRotateGate(101,<0,0,1>,20,.2);
        llSleep(1.8);
        llMessageLinked(LINK_SET,2330,"","");
        llPlaySound("SGCWhoosh", 1.0);
        llSleep(4.5);
        llLoopSound( EventHorizonLoopSound, 0.5 );    // Start the sound looping
        llSay(0,"Activated.");
        llSetTimerEvent(Verweildauer);
       // llSetText("Walk here to\nteleport to "+HoverTitle,<1,1,1>,1)
        llListen(channel, "", NULL_KEY, "CLOSE");
    }
    //
    
    listen(integer chan, string name, key id, string msg){
        if (msg =="CLOSE"){
            llResetScript(); 
        }
    }
                    
    timer()
    {
        if (DEFAULTstate == FALSE) llResetScript();
    }
    
    
    touch_start(integer num_detected)
    {
        llResetScript();        // when touched, switch to the OFF state
    }
    //
    collision_start(integer total_number)  // total_number is the number of avatars detected.
    {
        llWhisper(0, "Teleporting...");
        PerformTeleport( llDetectedKey( 0 ));
    }
    //
    changed(integer change) // something changed, take action
    {
        if(change & CHANGED_OWNER)
        {
            llOwnerSay("Owner Changed, Resetting Script");
            llResetScript();
        }
        else if (change & 256) // that bit is set during a region restart
        {
            llResetScript();
        }
    }
} 