// ----------------------------------------------------------------------------------
// nPose NC Reader 2.0 OSGrid JE 001
// ----------------------------------------------------------------------------------
// Changes:
// ----------------------------------------------------------------------------------
// Version JE 001
// - reset scripts when no buttons are shown
// ----------------------------------------------------------------------------------

string NC_READER_CONTENT_SEPARATOR="%&§";
integer MEMORY_TO_BE_USED=60000;

integer DOPOSE              =  200;
integer DOACTIONS           =  207;
integer DOPOSE_READER       =  222;
integer DOACTION_READER     =  223;
integer NC_READER_REQUEST   =  224;
integer NC_READER_RESPONSE  =  225;
integer RESET               = -950;
integer MEM_USAGE           = 34334;

list cacheNcNames;
list cacheContent;

list ncReadStackNcNames;
list ncReadStack;
integer NC_READ_STACK_CURRENT_LINE=1;
integer NC_READ_STACK_CONTENT=2;
integer NC_READ_STACK_STRIDE=3;

list responseStack;

integer RESPONSE_STACK_NC_NAME=0;
integer RESPONSE_STACK_AVATAR_KEY=3;
integer RESPONSE_STACK_TYPE=4;
integer RESPONSE_STACK_STRIDE=5;

integer cacheMiss;
integer requests;

processResponseStack() {
    do{
        if(!llGetListLength(responseStack))
        {
            return;
        }
        string ncName=llList2String(responseStack, RESPONSE_STACK_NC_NAME);
        if(~llListFindList(ncReadStackNcNames, [ncName])) {

            return;
        }
        integer index=llListFindList(cacheNcNames, [ncName]);
        if(~index)
        {
            llMessageLinked(
                LINK_SET,
                llList2Integer(responseStack, RESPONSE_STACK_TYPE),
                llDumpList2String(llList2List(responseStack, 0, 2), NC_READER_CONTENT_SEPARATOR) + llList2String(cacheContent, index),
                llList2Key(responseStack, RESPONSE_STACK_AVATAR_KEY));

            responseStack=llDeleteSubList(responseStack, 0, RESPONSE_STACK_STRIDE - 1);

            cacheNcNames=llDeleteSubList(cacheNcNames, index, index) + llList2List(cacheNcNames, index, index);
            cacheContent=llDeleteSubList(cacheContent, index, index) + llList2List(cacheContent, index, index);
        }
        else
        {
            if(llGetInventoryType(ncName) == INVENTORY_NOTECARD) {
                cacheMiss++;
                ncReadStackNcNames+=[ncName];
                ncReadStack+=[llGetNotecardLine(ncName, 0), 0, ""];
                return;
            }
            else
            {
                responseStack=llDeleteSubList(responseStack, 0, RESPONSE_STACK_STRIDE - 1);
            }
        }
    }
    while(TRUE);
}

fetchNcContent(string str, key id, integer type)
{
    list parts=llParseStringKeepNulls(str, [NC_READER_CONTENT_SEPARATOR], []);
    string ncName=llList2String(parts, 0);
    string menuName=llList2String(parts, 1);
    string placeholder=llList2String(parts, 2);
    if(llGetInventoryType(ncName) == INVENTORY_NOTECARD)
    {
        requests++;
        responseStack+=[ncName, menuName, placeholder, id, type];
        processResponseStack();
        checkMemory();
    }
}

checkMemory()
{
    if(llSubStringIndex(llGetEnv("simulator_hostname"), "lindenlab.com") != -1)
    {
        while(llGetUsedMemory()>MEMORY_TO_BE_USED) {
            cacheNcNames=llDeleteSubList(cacheNcNames, 0, 0);
            cacheContent=llDeleteSubList(cacheContent, 0, 0);
        }
    }
    else
    {
        while(llGetListLength(cacheNcNames) > 40) {
            cacheNcNames=llDeleteSubList(cacheNcNames, 0, 0);
            cacheContent=llDeleteSubList(cacheContent, 0, 0);
        }
    }
}

default {
    link_message(integer sender, integer num, string str, key id) {
        if(num==DOPOSE)
        {
            fetchNcContent(str, id, DOPOSE_READER);
        }
        else if(num==DOACTIONS)
        {
            fetchNcContent(str, id, DOACTION_READER);
        }
        else if(num==NC_READER_REQUEST)
        {
            fetchNcContent(str, id, NC_READER_RESPONSE);
        }
        else if(num==RESET)
        {
            llResetScript();
        }
        else if (num == MEM_USAGE)
        {
            float hitRate;
            if(requests) {
                hitRate=100.0 - (float)cacheMiss / (float)requests * 100.0;
            }
            llSay(0,
                "Memory Used by " + llGetScriptName() + ": " + (string)llGetUsedMemory() +
                " of " + (string)llGetMemoryLimit() +
                ", Leaving " + (string)llGetFreeMemory() + " memory free.\nWe served " +
                (string)requests + " requests with a cache hit rate of " +
                (string)llRound(hitRate) + "%."
                    );
        }
    }

    dataserver(key queryid, string data) {
        integer ncReadStackIndex=llListFindList(ncReadStack, [queryid]);
        if(~ncReadStackIndex)
        {
            string ncName=llList2String(ncReadStackNcNames, ncReadStackIndex);

            if(llGetInventoryType(ncName) != INVENTORY_NOTECARD)
            {

                cacheNcNames=[];
                cacheContent=[];
                ncReadStackNcNames=[];
                ncReadStack=[];
                responseStack=[];
                return;
            }
            checkMemory();
            if(data==EOF)
            {
                cacheNcNames+=ncName;
                cacheContent+=llList2String(ncReadStack, ncReadStackIndex + NC_READ_STACK_CONTENT);
                ncReadStackNcNames=llDeleteSubList(ncReadStackNcNames, ncReadStackIndex, ncReadStackIndex);
                ncReadStack=llDeleteSubList(ncReadStack, ncReadStackIndex, ncReadStackIndex + NC_READ_STACK_STRIDE - 1);
                processResponseStack();
            }
            else {
                data=llStringTrim(data, STRING_TRIM);
                if(!llSubStringIndex(data, "#"))
                {
                    data="";
                }
                if(data)
                {
                    data=NC_READER_CONTENT_SEPARATOR + data;
                }
                integer nextLine=llList2Integer(ncReadStack, ncReadStackIndex + NC_READ_STACK_CURRENT_LINE) + 1;
                ncReadStack=llListReplaceList(ncReadStack, [
                    llGetNotecardLine(ncName, nextLine),
                    nextLine,
                    llList2String(ncReadStack, ncReadStackIndex + NC_READ_STACK_CONTENT) + data
                        ], ncReadStackIndex, ncReadStackIndex + NC_READ_STACK_STRIDE -1);
            }
        }
    }
    changed(integer change) {
        if(change & CHANGED_INVENTORY) {
            cacheNcNames=[];
            cacheContent=[];
            ncReadStackNcNames=[];
            ncReadStack=[];
            responseStack=[];
        }
    }
}

 