string animation_name = "Sign hold";
 
default
{
    // Whenever this object is attached or detached...
    attach(key id)
    {
        if (id)
        {   // If it was just attached, request permission to animate.
            llRequestPermissions(llGetOwner(), PERMISSION_TRIGGER_ANIMATION);
        }
        else
        {   // It's being detached...
            if (llGetPermissions() & PERMISSION_TRIGGER_ANIMATION)
            {   // If we have permission to animate, stop the animation.
                llStopAnimation(animation_name);
            }
        }
    }
 
    // Whenever permissions change...
    run_time_permissions(integer permissions)
    {
        if (permissions & PERMISSION_TRIGGER_ANIMATION)
        {   // If permission to animate was granted, start the animation.
            llStartAnimation(animation_name);
        }
    }
} 