string Name = "dragon";
key uNPC;
default
{
    
    on_rez(integer n)
    {
        llResetScript();
    }
    
    state_entry()
    {
        string n = llStringTrim(llGetObjectDesc(), STRING_TRIM);
        if (n != "") Name = n;
        //llListen(0, "", llGetOwner(), "");
        
        llSay(0, "You can now sit on the saddle. ");
        llSetTimerEvent(300);
        //llSay(0, "You can call the horse near you by shouting '"+Name+" come'");
        //llSay(0, "To remove the npc, say '"+Name+" remove'");
    }
    
    changed(integer c)
    {
         if (c&CHANGED_LINK)
         {
            if (llAvatarOnLinkSitTarget(1) != NULL_KEY)
            {
                key horse = llAvatarOnLinkSitTarget(2);
                if (horse == NULL_KEY)
                {
                    //llSay(0, "Rezzing the horse NPC...");
                    uNPC = osNpcCreate(Name, "", llGetPos()+<0,0,2>, "appearance",  OS_NPC_NOT_OWNED | OS_NPC_SENSE_AS_AGENT);
                    llSleep(3);
                    osNpcSit(uNPC, llGetLinkKey(2), OS_NPC_SIT_NOW);
                    llSleep(.5);
                    osNpcPlayAnimation(uNPC, "dragon1");
        
                }
                llSetTimerEvent(0);
            }
            else
            {
                llSetTimerEvent(200);
            }
        }
    }
    
    listen(integer c, string n, key who, string d)
    {
        list tok = llParseString2List(d, [" "], []);
        
        if (Name != llList2String(tok, 0)) return;
        
        if (llList2String(tok, 1)=="come")
        {
            list userData = llGetObjectDetails((key) who, [OBJECT_NAME,OBJECT_POS, OBJECT_ROT]);
            if (llGetListLength(userData))
            {
                llSetRegionPos(llList2Vector(userData,1));
            }
        }
        else if (llList2String(tok, 1) == "rez")
        {
            llSay(0, "Rezzing the horse NPC...");
            uNPC = osNpcCreate(Name, "", llGetPos()+<0,0,2>, "horse_appearance",  OS_NPC_NOT_OWNED | OS_NPC_SENSE_AS_AGENT);
            llSleep(3);
            osNpcSit(uNPC, llGetLinkKey(2), OS_NPC_SIT_NOW);
            llSleep(.5);
            osNpcPlayAnimation(uNPC, "dragon1");

        }
        else if (llList2String(tok, 1) == "remove")
        {
            if (uNPC != NULL_KEY)
            {
                osNpcStand(uNPC);
                llSleep(1.);
                osNpcRemove(uNPC);
                llSay(0, "Removed horse NPC");
                key u2 = llAvatarOnLinkSitTarget(2);
                if (u2 != NULL_KEY)
                {
                    osNpcStand(u2);
                    llSleep(1.);
                    osNpcRemove(u2);
                    //llSay(0, "Removed horse NPC");
                }
            }
        }
    }
    
    timer()
    {
        if (llAvatarOnLinkSitTarget(1) == NULL_KEY)
        {
                key u2 = llAvatarOnLinkSitTarget(2);
                if (u2 != NULL_KEY)
                {
                    llSay(0, "Removing NPC...");
                    osNpcStand(u2);
                    llSleep(1.);
                    osNpcRemove(u2);
                    llSleep(2);                
                }
                llDie();
        }
        
    }
} 