integer selected_piece;
list players;
integer game = FALSE;
list grid;
integer curr_row;
integer curr_col;
integer curr_side;
list names;
list moves;
list distances = [1, -1];
list kings;

list jumps;
integer jump_type;
//-----------------------------------------------------------------------------
// List Array functions
// 
// Written By: Sandie Harbour, July 2008
//-----------------------------------------------------------------------------
 
//------------------------------------------------------------------------------
// Function: initIntArray
// Descripton:
//      Given the number of rows and columns, create an list of integers
//      that will be used as an aarray.
//------------------------------------------------------------------------------
list makeArray ( integer rows, integer cols )
{
    integer i;
    list array = [];
    array += < rows, cols, 0 >;
    for (i=0; i < rows * cols; ++i)
    {
        array += 0;
    }
    return array;
}
 
//------------------------------------------------------------------------------
// Function: getElement
// Descripton:
//      Return the integer which is stored in the given array
//      at the given row and column numbers.
//------------------------------------------------------------------------------
integer getElement( list array, integer row, integer col )
{
    vector metadata = llList2Vector( array, 0);
    integer cols = (integer)metadata.y;
    integer index = row * cols + col + 1;
    return llList2Integer( array, index);
}
 
//------------------------------------------------------------------------------
// Function: setElement
// Descripton:
//      Set the value in the specified row and columnn and return
//      the array.
//------------------------------------------------------------------------------
list setElement( list array, integer row, integer col, integer value )
{
    vector metadata = llList2Vector( array, 0);
    integer cols = (integer)metadata.y;
    integer index = row * cols + col  + 1;
    return llListReplaceList(array, [value], index, index);
}

integer findPiece(integer piece)
{
    
    if(llListFindList(moves, [piece]) >=0)
        return TRUE;
    else
        return FALSE;
}
        
integer comp_move(integer how)
{
    integer target = 0;
    integer x = llGetListLength(moves);
    integer y =  (integer)llFrand( x );
    integer repeat = FALSE;
    
    if(how == 0)
    {
        selected_piece = llList2Integer(moves, y);
    
  //  llOwnerSay("selected piece = " + (string) selected_piece);

        string pos = findPosition(selected_piece);
        list lst = llParseString2List(pos, [","],[""]);
    
        curr_row = llList2Integer(lst, 0);
        curr_col = llList2Integer(lst, 1);
    
 //   llOwnerSay("current pos  = " + pos);
    
        getSquares(selected_piece, curr_row, curr_col);
 //   llOwnerSay("posible targets  = " + (string) jumps);
    } 
    x= llGetListLength(jumps);
    y =  (integer)llFrand( x );
    
    vector choice = llList2Vector(jumps, y);
    
//    llOwnerSay("target pos = " + (string) choice);
    
    grid = setElement(grid, curr_row, curr_col, -1);
    if((curr_side == 0 ) && ((integer)choice.x == 7))
        setKing(selected_piece);
    if((curr_side == 1 ) && ((integer)choice.x == 0))
        setKing(selected_piece);
                               
    grid = setElement(grid, (integer) choice.x, (integer) choice.y, selected_piece);
                        
    llMessageLinked( selected_piece, 0 ,(string) choice, "" );
    
    target = (integer) choice.z;
    
    if(target != 0)
    {
        killPiece(target);
        curr_row = (integer) choice.x;
        curr_col = (integer) choice.y;
        getSquares(selected_piece, curr_row, curr_col);
        if((jump_type ==0) && (llGetListLength(jumps) > 0))
        {
            repeat = TRUE;
            comp_move(1);
        }
        else
            repeat = FALSE;
    }    
    if(repeat == FALSE)
    { 
        if(curr_side == 0)
            curr_side = 1;
        else
            curr_side = 0;
                     //   curr_side = !curr_side;
        llMessageLinked(3, curr_side, "new move", "");
        selected_piece = -1;
        getMoves();
    }
    return x;
}

printGrid()
{
    integer i;
    integer j;
    integer k;
    string kk;
    
    for(i=0; i<8; i++)
    {
        kk="";
        for(j=0; j< 8; j++)
        {
            k=getElement(grid, i, j);
            kk += (string) k + ", ";
        }
        llOwnerSay(kk);
    }
}

setKing(integer x)
{
    if(llListFindList(kings, [x]) == -1)
        kings = kings + x;

}

integer isKing(integer x)
{
    if(llListFindList(kings, [x]) >= 0)
        return TRUE;
    else
        return FALSE;
}

killPiece(integer x)
{
    integer i;
    integer j;

    for(i=0; i<8; i++)
    {
        for(j=0; j<8; j++)
        {
            if(getElement(grid, i, j) == x)
            {
                grid=setElement(grid, i, j, -1);
                llMessageLinked( x, -3 ,(string) <x*7, x, 0>, "" );
            }
        }
    }
}

getSquares(integer piece, integer row, integer col)
{
 
    integer pc = piece;
    integer sd = getSide(piece);
    integer kg = isKing(getElement(grid, row, col));
    integer temp;
 
    
    jumps = [];
    jump_type = 0;
    
    // find jumps
    if((sd == 0) && ((row <6) || (kg == TRUE)))
    {
        if(col < 6)
        {
            temp = getElement(grid, row+1, col + 1);
            if(getSide(temp) == 1)
            {
                if(getElement(grid, row+2, col + 2) == -1)
                {
                    jumps = jumps + <row+2, col + 2, temp>;
                }
            }
            if((kg == TRUE) && (row > 1))
            {
                temp = getElement(grid, row-1, col + 1);
                if(getSide(temp) == 1)
                {
                    if(getElement(grid, row-2, col +2) == -1)
                    {
                        jumps = jumps + <row-2, col + 2, temp>;
                    }
                }
            }
        }
        if(col > 1)
        {
            temp = getElement(grid, row+1, col - 1);
            if(getSide(temp) == 1)
            {
                if(getElement(grid, row+2, col -2) == -1)
                {
                    jumps = jumps + <row+2, col - 2, temp>;
                }
            }
            if((kg == TRUE) && (row > 1))
            {
                temp = getElement(grid, row-1, col - 1);
                if(getSide(temp) == 1)
                {
                    if(getElement(grid, row-2, col -2) == -1)
                    {
                        jumps = jumps + <row-2, col - 2, temp>;
                    }
                }
            }
        }
    }
    else if((sd == 1) && ((row >1) || (kg == TRUE)))
    {
        if(col < 6)
        {
            temp = getElement(grid, row-1, col + 1);
            if(getSide(temp) == 0)
            {
                if(getElement(grid, row-2, col + 2) == -1)
                {
                    jumps = jumps + <row-2, col + 2, temp>;
                }
            }
            if((kg == TRUE) && (row < 6))
            {
                temp = getElement(grid, row+1, col + 1);
                if(getSide(temp) == 0)
                {
                    if(getElement(grid, row+2, col +2) == -1)
                    {
                        jumps = jumps + <row+2, col + 2, temp>;
                    }
                }
            }
        }
        if(col > 1)
        {
            temp = getElement(grid, row-1, col - 1);
            if(getSide(temp) == 0)
            {
                if(getElement(grid, row-2, col -2) == -1)
                {
                    jumps = jumps + <row-2, col - 2, temp>;
                }
            }
            if((kg == TRUE) && (row < 6))
            {
                temp = getElement(grid, row+1, col - 1);
                if(getSide(temp) == 0)
                {
                    if(getElement(grid, row+2, col -2) == -1)
                    {
                        jumps = jumps + <row+2, col - 2, temp>;
                    }
                }
            }
        }
    }
    // find regular moves
    if(llGetListLength(jumps) == 0)
    {
        jump_type = 1;
        if((sd == 0) && ((row <7) || (kg == TRUE)))
        {
            if(col < 7)
            {
                temp = getElement(grid, row+1, col + 1);

                if(temp == -1)
                {
                    jumps = jumps + <row+1, col + 1, 0>;
                }

                if((kg == TRUE) && (row > 0))
                {
                    temp = getElement(grid, row-1, col + 1);

                    if(temp == -1)
                    {
                        jumps = jumps + <row-1, col + 1, 0>;
                    }
                }
            }
            if(col > 0)
            {
                temp = getElement(grid, row+1, col - 1);

                if(temp == -1)
                {
                    jumps = jumps + <row+1, col - 1, 0>;
                }
    
                if((kg == TRUE) && (row > 0))
                {
                    temp = getElement(grid, row-1, col - 1);

                    if(temp == -1)
                    {
                        jumps = jumps + <row-1, col - 1, 0>;
                    }
                }
            }
        }
        else if((sd == 1) && ((row >0) || (kg == TRUE)))
        {
            if(col < 7)
            {
                temp = getElement(grid, row-1, col + 1);

                if(temp == -1)
                {
                    jumps = jumps + <row-1, col + 1, 0>;
                }
                
                if((kg == TRUE) && (row < 7))
                {
                    temp = getElement(grid, row+1, col + 1);

                    if(temp == -1)
                    {
                        jumps = jumps + <row+1, col + 1, 0>;
                    }
                    
                }
            }
            if(col > 0)
            {
                temp = getElement(grid, row-1, col - 1);

                if(temp == -1)
                {
                    jumps = jumps + <row-1, col - 1, 0>;
                }
                
                if((kg == TRUE) && (row < 7))
                {
                    temp = getElement(grid, row+1, col - 1);

                    if(temp == -1)
                    {
                        jumps = jumps + <row+1, col - 1, 0>;
                    }
                    
                }
            }
        }
    }
    //llSay(0, "jumps = " + (string) llList2CSV(jumps));
}

getMoves()
{
    integer i;
    integer j;
    integer piece;
    integer jmp = FALSE;

    moves=[];

    for(i=0; i<8; i=i+1)
    {
        for(j=0; j<8; j=j+1)
        {
            piece = getElement(grid, i, j);

                
            if(getSide(piece) == curr_side)
            {
                getSquares(piece, i, j);
                if(llGetListLength(jumps) > 0)
                {
                    if(jump_type == 0)
                    {
                        if(jmp == FALSE)
                        {
                            jmp = TRUE;
                            moves = [];
                        }
                        moves = moves + piece;
                    }
                    else if(jmp == FALSE)
                    {
                        moves = moves + piece;
                    }

                }
              //  if(((getElement(grid,i+llList2Integer(distances, curr_side), j-1) == -1) && (j>0)) ||
              //      ((getElement(grid,i+llList2Integer(distances, curr_side), j+1) == -1) && (j<7)))
              //      moves = moves + piece;
            }    
        }
    }
    if(llGetListLength(moves) == 0)
    {
        llSay(0, llList2String(names, !curr_side) + " wins!!!!");
        stopGame();
    }
    //llOwnerSay("movable pieces are : " + (string) llList2CSV(moves));        
}

integer getSide(integer x)
{
    if(x > 16)
        return 1;
    else if (x > 4)
        return 0;
    else
        return -1;
}

startGame()
{
    integer i;

    vector scle = llGetScale();
    setGrid(-1);
    llMessageLinked( LINK_ALL_CHILDREN, -2 , (string) scle, "" );
    for(i=0; i<12; i++)
    {
        llMessageLinked( i+5, 1 ,(string) < i/4, ((i%4)*2) + ((i/4)%2), 0>, "" );
        grid = setElement(grid, i/4, ((i%4)*2) + ((i/4)%2),i+5);
        llMessageLinked( i+17, 1 ,(string) < (i+20)/4, (((i+20)%4)*2) + (((i+20)/4)%2), 0>, "" );
        grid = setElement(grid, (i+20)/4, (((i+20)%4)*2) + (((i+20)/4)%2),i+17);
    }
    game = TRUE;
    kings=[];
    curr_side = 0;
    getMoves();
}

string findPosition(integer piece)
{
    integer i;
    integer j;
    string ret="";
    
    for(i=0; i<8; i=i+1)
    {
        for(j=0; j<8; j=j+1)
        {
            if (piece == getElement(grid, i, j))
            {
                ret = (string) i + "," + (string) j;
                i=8;
                j=8;
            }
        }
    }
    return ret;
}

stopGame()
{
    integer i;
    
    for(i=0; i<27; i++)
    {
        llMessageLinked( i+2, -3 ,(string) <i*7, i, 0>, "" );
            
    }
    game = FALSE;    
}

setGrid(integer x)
{
    integer i;
    integer j;
        
        
    for(i=0; i < 8; i++)
    {
        for(j=0; j<8; j++)
        {
            grid = setElement(grid, i, j, x);
        }
    }
}

default
{
    state_entry()
    {
        grid = makeArray(8,8);
        setGrid(-1);
    }
    
    on_rez()
    {
        llResetScript();
    }

    touch_start(integer num_detected)
    {
        list lst;
        
        if((game == TRUE) && (llDetectedKey(0) == llList2Key(players, curr_side)))
        {
            integer i = 0;
            vector boardpos;
            integer x;
            integer y;
            vector temp;
            integer target = 0;
            integer repeat = FALSE;
            
            for(; i < num_detected; ++i )
            {
                vector touchedpos = llDetectedTouchST(i);

                if (llDetectedTouchFace(i) == -1)
                {
                    llWhisper(0, "Sorry, it appears that your viewer doesn't support touched faces.");
                }
                else if ( touchedpos == TOUCH_INVALID_TEXCOORD )
                {
                    llWhisper(0, "Sorry, the surface touch position could not be determined.");
                }
                else if (selected_piece > -1)
                {

                    boardpos = <touchedpos.x/.125,touchedpos.y/.125, 0.0>;
    //        llSay(0, (string)((integer)boardpos.x));
    //        llSay(0, (string)((integer)boardpos.y));
                    y=0;
                    for(x=0; x< llGetListLength(jumps); x++)
                    {
                        temp = llList2Vector(jumps, x);
                        if(((integer)temp.x == (integer)boardpos.x) && ((integer)temp.y == (integer)boardpos.y))
                        {
     //               llSay(0,"found");
                            y=1;
                            target = (integer)temp.z;
                            x=llGetListLength(jumps);
                        }

                    }
                    if(y == 1)
                    {
                        grid = setElement(grid, curr_row, curr_col, -1);
                        if((curr_side == 0 ) && ((integer)boardpos.x == 7))
                            setKing(selected_piece);
                        if((curr_side == 1 ) && ((integer)boardpos.x == 0))
                            setKing(selected_piece);
                               
                        grid = setElement(grid, (integer) boardpos.x, (integer) boardpos.y, selected_piece);
                        
                        llMessageLinked( selected_piece, 0 ,(string) boardpos, "" );
                        if(target != 0)
                        {
                            killPiece(target);
                            curr_row = (integer) boardpos.x;
                            curr_col = (integer) boardpos.y;
                            getSquares(selected_piece, curr_row, curr_col);
                            if((jump_type ==0) && (llGetListLength(jumps) > 0))
                            {
                                repeat = TRUE;
                            }
                            else
                                repeat = FALSE;
                        }
                        if(repeat == FALSE)
                        {
                            if(curr_side == 0)
                                curr_side = 1;
                            else
                                curr_side = 0;
                        //   curr_side = !curr_side;
                            llMessageLinked(3, curr_side, "new move", "");
                            selected_piece = -1;
                            getMoves();
                            
                            if(llList2Key(players, curr_side) == NULL_KEY)
                                comp_move(0);
                        }
                        

                    }
                }
            }
        }
    } 

    link_message(integer sender, integer num, string str, key id)
    {
        if(num < 0 )
        {
            players=llParseString2List(str,[","],[]);
            names = names + llKey2Name(llList2Key(players, 0));

            if(llList2Key(players, 1) == NULL_KEY)
            {
                players = llListReplaceList(players,[(key)NULL_KEY], 1,1);
                names = names + "computer";
            }
            else
                names = names + llKey2Name(llList2Key(players, 1));
            
            startGame();
        }
        else if(str == "stop")
        {
            stopGame();
        }
        else
        {
            if(getSide(sender) == curr_side)
            {
       //         llOwnerSay((string) llList2CSV(moves));
                if(findPiece(sender) == TRUE)
                {
                    selected_piece = sender;
                    //llOwnerSay("sender = " + (string) sender);
                    //llOwnerSay("return value = " + str);
                    list lst = llParseString2List(str, [","],[""]);
                    curr_row = llList2Integer(lst, 0);
                    curr_col = llList2Integer(lst, 1);
        //            llSay(0, "row = " + (string) curr_row + " col = " + (string) curr_col);
                    getSquares(selected_piece, curr_row, curr_col);
                    //llOwnerSay("piece " + (string) getElement(grid, curr_row, curr_col) + " is at pos " + (string) curr_row + "," + (string) curr_col);
                }
            }
        }
    }
}