// LSL script generated: AMV MultiSit Target RESALE.AMV MultiSit Target v2.lslp Tue Sep  4 19:48:51 Eastern Daylight Time 2012

integer configfile_line;
key configfile_queryhandle;
string configfile_name = "Configuration";
string configfile_section = "";
integer ACCESS_OWNER = 0;

// Sit target system by Lex Neva.  Please distribute willy-nilly.
// learjeff innis: allow to leave script in furniture.
// Note that shift-drag to copy will lose the sit target.

// v2d: anim menu
// v2e: shift-lef/right to switch anims
// v2f: left/right to rotate (normal furniture mode only), and only if "Rotat" is in description
// v2g: compensate for LSL bug?  key sent to "control" is not always av on sit target!
// v2h: comments, optimize stopping of default sits
// v2i: ?
// v2i1: fix rotation after getting up

// v3: menu!  Make it so finished furniture doesn't show a clickable cursor
// v4: AMV additions.  Add config menu and save settings.  Use that to save and restore sit target

string settings = "SitTarget.config";

string HelperName = "AMV Sit Target Helper";
vector HelperTarget = <0.0, 0.0, 0.0001>;

integer HelperChannel = -2120;
integer HelperHandle;
key HelperKey = NULL_KEY;

list Anims;
integer AnimNum;
string LastAnim;
key LastAv;
rotation OrigRotation;
integer Rotating;

vector sit_target_pos = <0.0,0.0,0.1>;
rotation sit_target_rot = <0.0,0.0,0.0,1.0>;

//Bug fix
//vector offset = <0.1,0.0,0.3>;
vector offset = <0.0,0.0,0.4>;
//float hip_offset = -7.66e-2;
float hip_offset = 0.0;

integer MenuChan;
integer MenuHandle;

list Buttons = ["START","RESET","SET","DONE"];

integer inventory_exists(string name, integer type)
{
    return (llGetInventoryType(name) == type) ^ (!~type);
}

integer configfile_exists()
{
    return (inventory_exists(configfile_name, INVENTORY_NOTECARD));
}

configfile_init()
{
    configfile_line = 0;
    configfile_queryhandle = llGetNotecardLine(configfile_name,configfile_line);
}

configfile_get_next_entry()
{
    configfile_queryhandle = llGetNotecardLine(configfile_name,(++configfile_line));
}
    
//
// Assumes the caller has determined the queryid is correct and that
// Data is an entry and not EOF
//
list configfile_dataserver_hook(string data)
{
    if (llGetSubString(data,0,0) == "#") 
    {
        configfile_get_next_entry();
        return [];
    }
    
    data = llStringTrim(data,STRING_TRIM);
    if (data == "") 
    {
        configfile_get_next_entry();
        return [];
    }
    
    list entry = [];
    string token = "";
    if ((llGetSubString(data,0,0) == "[") && (llGetSubString(data,(-1),(-1)) == "]"))
    {
        if (llStringLength(data) > 2) 
            configfile_section = llGetSubString(data,1,(-2));
        else
            configfile_section = "";
    }
    else  
    {
        integer s = llSubStringIndex(data,"=");
        if (s != -1) 
        {
            token = llToLower(llStringTrim(llDeleteSubString(data,s,(-1)),STRING_TRIM));
            data = llStringTrim(llDeleteSubString(data,0,s),STRING_TRIM);
        }
    }
    
    entry = [token,data,configfile_section];
    configfile_get_next_entry();
    return entry;
}

vector config_vector(string name,string value)
{
    vector vec = (vector)value;
    return vec;
}

rotation config_rotation(string name,string value)
{
    rotation r = (rotation)value;
    return r;
}

// Return a channel number that's based on the prim's key -- unique per object
integer channel()
{
    return (integer)("0x" + llGetSubString((string)llGetKey(),-4,-1));
}

do_menu(key id)
{
    llDialog(id,((("Choose SET to set the sit target.  Then test.  Choose DONE when you're happy.\n" + "To change the target later, remove the '") + settings) + "' notecard from inventory."),Buttons,MenuChan);
}

// Calculate the sit target, compensating for the known bug
calc_sit_target(vector helper_pos,rotation helper_rot)
{
    vector my_pos = llGetPos();
    rotation my_rot = llGetRot();
    vector avatar_pos = (helper_pos + (HelperTarget * helper_rot));
    
    avatar_pos = (avatar_pos + (offset * helper_rot));
    avatar_pos -= (<0,0,hip_offset> * helper_rot);
    sit_target_pos = ((avatar_pos - my_pos) / my_rot);
    sit_target_pos = (sit_target_pos - offset);
    sit_target_rot = (helper_rot / my_rot);
    sit_target_pos.z += hip_offset;
    llSitTarget(sit_target_pos,sit_target_rot);
    llSay(0,(((("llSitTarget(" + ((string)sit_target_pos)) + ", ") + ((string)sit_target_rot)) + ");"));
}

// Collect the set of anims in this prim
get_anims()
{
    integer ix;
    string anim;
    llUnSit(llAvatarOnSitTarget());
    
    Anims = [];
    for (ix = 0; TRUE; ix++) 
    {
        anim = llGetInventoryName(INVENTORY_ANIMATION,ix);
        if (anim == "") 
        {
            llWhisper(0,(string)llGetListLength(Anims) + " animations");
            return;
        }
        
        Anims += [anim];
    }
}


// Start the animation given by ordinal number

integer start_anim(integer ix)
{
    integer numAnims = llGetListLength(Anims);
    key id = llAvatarOnSitTarget();
    list anims = llGetAnimationList(id);
    integer jx;

    for (; jx < llGetListLength(anims); ++jx) 
    {
        llStopAnimation(llList2String(anims,jx));
    }
    
    if (numAnims > 0)
    {
        string anim = llList2String(Anims,ix);
        llStartAnimation(anim);
        
        if (LastAv == NULL_KEY) 
        {
            llStopAnimation("sit");
            llStopAnimation("sit_generic");
            llStopAnimation("sit_female");
        }
        LastAnim = anim;
        LastAv = id;
    }
    
    return (numAnims > 1);
}

stop_anims(key who)
{
    list anims = llGetAnimationList(who);
    integer jx;
    for (; jx < llGetListLength(anims); ++jx) 
    {
        llStopAnimation(llList2String(anims,jx));
    }
}

// Start the next anim in inventory

next_anim()
{
    AnimNum = AnimNum + 1;
    
    if (AnimNum >= llGetListLength(Anims)) 
        AnimNum = 0;
        
    start_anim(AnimNum);
}

// Start the previous anim in inventory

prev_anim()
{
    AnimNum = AnimNum - 1;
    if (AnimNum < 0) 
        AnimNum = llGetListLength(Anims) - 1;
        
    start_anim(AnimNum);
}


// Rotate the stool by the given angle

rotate(float amt)
{
    rotation rot = llGetRot();
    rotation r = llEuler2Rot(<0,0,(amt * DEG_TO_RAD)>);
    llSetRot((rot * r));
}


// React to an arrow or shift-arrow key

handle_control(integer level,integer change)
{
    key id = llAvatarOnSitTarget();
    
    if (level & CONTROL_RIGHT)
    {
        next_anim();
        llInstantMessage(id,LastAnim);
    }
    else  if (level & CONTROL_LEFT)
    {
        prev_anim();
        llInstantMessage(id,LastAnim);
    }
    else  if (level & CONTROL_ROT_LEFT) 
    {
        rotate(-15.0);
    }
    else  if (level & CONTROL_ROT_RIGHT) 
    {
        rotate(15.0);
    }
}

upgrade()
{
    string me = llGetScriptName();
    string name = "AMV MultiSit Target";
    integer n = llGetInventoryNumber(INVENTORY_SCRIPT);
    
    while (n-- > 0) 
    {
        string item = llGetInventoryName(INVENTORY_SCRIPT,n);
        if ((item != me) && (0 == llSubStringIndex(item,name))) 
        {
            llOwnerSay(("removing old script: " + item));
            llRemoveInventory(item);
        }
    }
}

list getConfiguration()
{
    list config_data = [("sit-position=" + ((string)sit_target_pos)),("sit-rotation=" + ((string)sit_target_rot))];
    return config_data;
}
    
save_configuration(key who)
{
    llInstantMessage(who,(llGetObjectName() + " Saving configuration"));
    
    list config_data = getConfiguration();
    if (configfile_exists()) 
        llRemoveInventory(configfile_name);
        
    osMakeNotecard(configfile_name,config_data);
    llInstantMessage(who,(llGetObjectName() + " Configuration Saved."));
}

default 
{
    on_rez(integer parm) 
    {
        llResetScript();
    }
         
    state_entry() 
    {
        upgrade();
        configfile_name = settings;
        if (configfile_exists() == FALSE) 
            state setting;
        else  
            configfile_init();
    }

    changed(integer changeType) 
    {
        if ((changeType & CHANGED_OWNER) || (changeType & CHANGED_INVENTORY)) 
        {
            llResetScript();
        }
    }
    
    dataserver(key query_id,string data) 
    {
        if (query_id != configfile_queryhandle) 
            return;
            
        if (data == EOF) 
        {
            state running;
        }
        else  
        {
            list entry = configfile_dataserver_hook(data);
            string keyname = llList2String(entry,0);
            string value = llList2String(entry,1);
            if (keyname == "sit-position")
                sit_target_pos = config_vector(keyname,value);
            else  if (keyname == "sit-rotation") 
                sit_target_rot = config_rotation(keyname,value);
        }
    }
}

// Sit-target setting mode
// On click, show menu.  On "SHOW", set the sit target.  On "DONE", go to furniture mode.
// Might be a good idea to disallow to simplify and avoid user mistakes.

state setting 
{
    on_rez(integer arg) 
    {
        state default;
    }

    state_entry() 
    {
        llSay(0,"Put desired animations in this prim ands rez and sit on a Sit Target Helper.");
        llSay(0,"Touch the target to get a setup menu.");

        get_anims();

        MenuChan = channel();
        MenuHandle = llListen(MenuChan,"",NULL_KEY,"");
        HelperHandle = llListen(HelperChannel,HelperName,"","");
        HelperKey = NULL_KEY;
    }

    state_exit() 
    {
        llSetTimerEvent(0.0);
        llListenRemove(MenuHandle);
        llListenRemove(HelperHandle);
        llRegionSayTo(HelperKey,HelperChannel,"DONE");
        
        HelperKey = NULL_KEY;
        llSay(0,"Converting to normal furniture mode");
        integer linknum = llGetLinkNumber();
        string text = "To put me back in sit-target programming mode, remove the '" + settings + "' notecard from ";
        
        if (linknum > 1) 
            text += "the prim " + (string)linknum + " (" + llGetObjectName() + ")";
        else  
            text += "this object";
            
        llSay(0,text);
    }
    
    touch_end(integer total_number) 
    {
        do_menu(llDetectedKey(0));
    }
    
    listen(integer chan,string name,key id,string msg) 
    {
        if (chan == MenuChan) 
        {
            if (msg == "START") 
            {
                llSensor(HelperName,NULL_KEY,(ACTIVE | PASSIVE),20,PI);
                llSay(0,"Searching for '" + HelperName + "'");
                return;
            }
            else  if (msg == "RESET") 
            {
                if (HelperKey != NULL_KEY) 
                    llRegionSayTo(HelperKey,HelperChannel,"RESET");
                    
                stop_anims(id);
                llResetScript();
            }
            
            if (HelperKey != NULL_KEY) 
            {
                if (msg == "SET") 
                {
                    llRegionSayTo(HelperKey,HelperChannel,"STATUS");
                    return;
                }
                else  if (msg == "DONE")
                {
                    save_configuration(id);
                    stop_anims(id);
                    llRegionSayTo(HelperKey,HelperChannel,"DONE");
                    state running;
                }
            }
            else  
            {
                llSay(0, "Select START first to find a " + HelperName);
                return;
            }
        }
        else  if (chan == HelperChannel) 
        {
            key who = llGetOwnerKey(id);
            if (who != llGetOwner()) 
            {
                llSay(0,(llGetObjectName() + ": chat command from invalid source"));
                return;
            }
            
            string command = llStringTrim(msg,STRING_TRIM);
            list argslist = [];
            integer index = llSubStringIndex(command," ");
            if (index != -1)
            {
                string args = llStringTrim(llGetSubString(command,(index + 1),(-1)),STRING_TRIM);
                argslist = llParseString2List(args,["|"],[]);
                command = llGetSubString(command,0,(index - 1));
            }
            if (command == "READY") {
                llSay(0,(HelperName + " located. Setup enabled."));
                llRequestPermissions(who,(PERMISSION_TAKE_CONTROLS | PERMISSION_TRIGGER_ANIMATION));
            }
            else  if ((command == "NOTREADY")) 
            {
                HelperKey = NULL_KEY;
                llSay(0,(HelperName + " located. Sit on the Helper and select START again to begin."));
            }
            else  if ((command == "STOPPED")) 
            {
                stop_anims(who);
            }
            else  if ((command == "STATUS")) 
            {
                vector avPos = ((vector)llList2String(argslist,0));
                rotation avRot = ((rotation)llList2String(argslist,1));
                calc_sit_target(avPos,avRot);
            }
        }
    }
    
    // no helper around, do nothing
    no_sensor() 
    {
        llSay(0,(("Can't find " + HelperName) + "."));
        HelperKey = NULL_KEY;
    }

    // Found the helper: set sit target and go to furniture mode
    sensor(integer num) 
    {
        if (num > 1) 
            llSay(0,"Multiple Sit Target Helpers found.  Contacting closest one.");
            
        HelperKey = llDetectedKey(0);
        llRegionSayTo(HelperKey,HelperChannel,"START");
    }
    
    changed(integer change) 
    {
        if (change & CHANGED_INVENTORY) 
        {
            get_anims();
            return;
        }
    }


    run_time_permissions(integer perm) 
    {
        llTakeControls((CONTROL_RIGHT | CONTROL_LEFT),TRUE,FALSE);
        if (start_anim(AnimNum)) 
        {
            llInstantMessage(llAvatarOnSitTarget(),"shift-left/right to change animation");
        }
    }

    // Handle arrow keys
    control(key id,integer level,integer change) 
    {
        handle_control(level,change);
    }
}

// Normal 'sit' mode: now we're just furniture.

state running 
{
    state_entry() 
    {
        get_anims();
        OrigRotation = llGetRot();
        llSitTarget(sit_target_pos,sit_target_rot);
    }

    changed(integer change) 
    {
        if (change & CHANGED_INVENTORY) 
        {
            if (configfile_exists() == FALSE) 
                llResetScript();

            get_anims();
            return;
        }
        
        if (llAvatarOnSitTarget() == NULL_KEY) 
        {
            LastAv = NULL_KEY;
            if (Rotating) 
                llSetRot(OrigRotation);
        }
        else  
        {
            OrigRotation = llGetRot();
            llRequestPermissions(llAvatarOnSitTarget(),(PERMISSION_TAKE_CONTROLS | PERMISSION_TRIGGER_ANIMATION));
        }
    }

    run_time_permissions(integer perm) 
    {
        integer controls;
        if ((llSubStringIndex(llToUpper(llGetObjectDesc()),"ROTAT") == (-1))) 
        {
            Rotating = FALSE;
            controls = (CONTROL_RIGHT | CONTROL_LEFT);
        }
        else  
        {
            Rotating = TRUE;
            controls = (((CONTROL_RIGHT | CONTROL_LEFT) | CONTROL_ROT_LEFT) | CONTROL_ROT_RIGHT);
        }
        
        llTakeControls(controls,TRUE,FALSE);
        
        if (start_anim(AnimNum)) 
            llInstantMessage(llAvatarOnSitTarget(),"shift-left/right to change animation");
    }

    control(key id,integer level,integer change) 
    {
        handle_control(level,change);
    }


    state_exit() 
    {
        if (Rotating) 
        {
            llSetRot(OrigRotation);
        }
    }
}
