// :CATEGORY:Vehicles
// :NAME:Boat
// :AUTHOR:Encog Dod
// :CREATED:2010-01-10 05:20:56.000
// :EDITED:2013-09-18 15:38:49
// :ID:108
// :NUM:149
// :REV:1.0
// :WORLD:Second Life
// :DESCRIPTION:
// Boat
// :CODE:

// From the book:
//
// Scripting Recipes for Second Life
// by Jeff Heaton (Encog Dod in SL)
// ISBN: 160439000X
// Copyright 2007 by Heaton Research, Inc.
//
// This script may be freely copied and modified so long as this header
// remains unmodified.
//
// For more information about this book visit the following web site:
//
// http://www.heatonresearch.com/articles/series/22/

float forward_power = 14; //Power used to go forward (1 to 30)
float reverse_power = -5; //Power ued to go reverse (-1 to -30)
float turning_ratio = .6; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)
string sit_message = "RIDE"; //Sit message
string not_owner_message = "You are not the owner of this vehicle ..."; //Not owner message
float VERTICAL_THRUST = 10;
float speedmult = 1.0; 

integer shouldDie = 0;

//Anything past this point should only be modfied if you know what you are doing





psystem()
{
     llParticleSystem(
        [
            PSYS_SRC_PATTERN,PSYS_SRC_PATTERN_ANGLE_CONE,
            PSYS_SRC_BURST_RADIUS,1,
            PSYS_SRC_ANGLE_BEGIN,PI/2,
            PSYS_SRC_ANGLE_END,PI/2,
            PSYS_SRC_TARGET_KEY,llGetKey(),
            PSYS_PART_START_COLOR,<1.000000,1.000000,1.000000>,
            PSYS_PART_END_COLOR,<1.000000,1.000000,1.000000>,
            PSYS_PART_START_ALPHA,.4,
            PSYS_PART_END_ALPHA,0,
            PSYS_PART_START_GLOW,0,
            PSYS_PART_END_GLOW,0,
            PSYS_PART_BLEND_FUNC_SOURCE,PSYS_PART_BF_SOURCE_ALPHA,
            PSYS_PART_BLEND_FUNC_DEST,PSYS_PART_BF_ONE_MINUS_SOURCE_ALPHA,
            PSYS_PART_START_SCALE,<2.30000,2.00000,0.000000>,
            PSYS_PART_END_SCALE,<1,1, 0.000000>,
            //PSYS_SRC_TEXTURE,"3a7ea058-e486-4d21-b2e6-8b47462bb45b",
            PSYS_SRC_MAX_AGE,0,
            PSYS_PART_MAX_AGE,4,
            PSYS_SRC_BURST_RATE,0.1,
            PSYS_SRC_BURST_PART_COUNT,1,
            PSYS_SRC_ACCEL,<0.000000,0.000000,-.500000>,
            PSYS_SRC_OMEGA,<0.000000,0.000000,0.000000>,
            PSYS_SRC_BURST_SPEED_MIN,0.7,
            PSYS_SRC_BURST_SPEED_MAX,0.8,
            PSYS_PART_FLAGS,
                0 |
                PSYS_PART_BOUNCE_MASK |
                PSYS_PART_EMISSIVE_MASK |
                PSYS_PART_INTERP_COLOR_MASK
        ]);
}


 init()
  {
        llSetLinkPrimitiveParamsFast(LINK_ALL_CHILDREN, [PRIM_PHYSICS_SHAPE_TYPE, PRIM_PHYSICS_SHAPE_NONE]);
        llSetCameraEyeOffset(<-8, 0.0, 2.0>);
        llSetCameraAtOffset(<1.0, 0.0, 2.0>);
        
        //llPreloadSound("helicopter_run");
        
        //car
       llSetVehicleType(VEHICLE_TYPE_AIRPLANE);

       llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_EFFICIENCY, 0.8);
       
       llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_EFFICIENCY, 0.5);
       
       
       llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_TIMESCALE, 10);
       
       llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_TIMESCALE, 3);

       llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 1.9);
       llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_DECAY_TIMESCALE, .3);
       
       llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_TIMESCALE, 1.);
       llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_DECAY_TIMESCALE, .2);

       llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <2, .3,1>);
       llSetVehicleFloatParam(VEHICLE_ANGULAR_FRICTION_TIMESCALE, .1);

       llSetVehicleFloatParam(VEHICLE_BUOYANCY, 1.0);

        llSetVehicleFloatParam( VEHICLE_VERTICAL_ATTRACTION_EFFICIENCY, .5 );
        llSetVehicleFloatParam( VEHICLE_VERTICAL_ATTRACTION_TIMESCALE, 2. );

        llSetVehicleFloatParam( VEHICLE_BANKING_EFFICIENCY, 1 );
        llSetVehicleFloatParam( VEHICLE_BANKING_MIX, 0.1 );
        llSetVehicleFloatParam( VEHICLE_BANKING_TIMESCALE, .5 );
        
         llSetVehicleFloatParam( VEHICLE_HOVER_EFFICIENCY,.5 );
        llSetVehicleFloatParam( VEHICLE_HOVER_TIMESCALE, 1.0 );
        
    }   //  End init().
    



string curanim;


default
{
    
    on_rez(integer n)
    {
        llResetScript();   
    }
    
    state_entry()
    {
        llSetSitText(sit_message);
        // forward-back,left-right,updown
        llSitTarget(<-.4,0, .1>, ZERO_ROTATION );
        

        //llSetCameraAtOffset(<1.0, 0.0, 2.0>);
        
        //llPreloadSound("boat_start");
        //llPreloadSound("boat_run");
        init();
        
    }
    
    changed(integer change)
    {
        
        
        if ((change & CHANGED_LINK) == CHANGED_LINK)
        {
            
            key agent = llAvatarOnLinkSitTarget(1);
            if (agent != NULL_KEY)
            {                
                {
                    //llTriggerSound("boat_start",1);
                    init();
                    
                    //llMessageLinked(LINK_ALL_CHILDREN , 0, "start", NULL_KEY);
                    llSetStatus(STATUS_PHANTOM, FALSE);
                    llSleep(0.3);
                    llSetStatus(STATUS_PHYSICS, TRUE);
                    llSleep(1.0);
                    llRequestPermissions(agent, PERMISSION_CONTROL_CAMERA|PERMISSION_TRIGGER_ANIMATION | PERMISSION_TAKE_CONTROLS);
                    llSetLinkAlpha(2, 0.0, ALL_SIDES);
                    //llLoopSound("boat_run",1);
                   
                    //llSetTimerEvent(1);
                    shouldDie = 0;
                }

            }
            else
            {
                
                llSetStatus(STATUS_PHYSICS, FALSE);
                llSleep(.2);
                llReleaseControls();
                llTargetOmega(<0,0,0>,PI,0);
                llSetTimerEvent(0);
                llSetLinkAlpha(2,1.0, ALL_SIDES);
                llSetRot(ZERO_ROTATION);
                //llSleep(3);
                //llDie();
                llClearCameraParams();
                llSetTimerEvent(0);
                //shouldDie = 1;
                llStopAnimation("horse_sit");
            }
        }
        
    }
    
    run_time_permissions(integer perm)
    {
        if (perm&PERMISSION_TAKE_CONTROLS)
        {
            llTakeControls(CONTROL_FWD | CONTROL_BACK | CONTROL_DOWN | CONTROL_UP | CONTROL_RIGHT | 
                            CONTROL_LEFT | CONTROL_ROT_RIGHT | CONTROL_ROT_LEFT, TRUE, FALSE);
        }
        
        if (perm & PERMISSION_CONTROL_CAMERA)
        {
            llSetCameraParams([
               CAMERA_ACTIVE, 1,                     // 0=INACTIVE  1=ACTIVE
               CAMERA_BEHINDNESS_ANGLE, 15.0,         // (0 to 180) DEGREES
               CAMERA_BEHINDNESS_LAG, .6,           // (0 to 3) SECONDS
               CAMERA_DISTANCE, 5.0,                 // ( 0.5 to 10) METERS
               CAMERA_PITCH, 20.0,                    // (-45 to 80) DEGREES
               CAMERA_POSITION_LOCKED, FALSE,        // (TRUE or FALSE)
               CAMERA_POSITION_LAG, 0.05,             // (0 to 3) SECONDS
               CAMERA_POSITION_THRESHOLD, 30.0,       // (0 to 4) METERS
               CAMERA_FOCUS_LOCKED, FALSE,           // (TRUE or FALSE)
               CAMERA_FOCUS_LAG, 0.01 ,               // (0 to 3) SECONDS
               CAMERA_FOCUS_THRESHOLD, 0.01,          // (0 to 4) METERS
               CAMERA_FOCUS_OFFSET, <0.0,0.0,0.0>   // <-10,-10,-10> to <10,10,10> METERS
              ]);
        }
        
        llStopAnimation("sit");
        llStartAnimation("horse_sit");
    }
    
    
    
    control(key id, integer level, integer edge)
    {
               integer reverse=1;
        vector angular_motor;
        
        //get current speed
        vector vel = llGetVel();
        float speed = llVecMag(vel);

        angular_motor.y = 0;     

        if(speed>1 && (level &edge & CONTROL_FWD))
        {
            if (speedmult ==1.) 
            {
                speedmult = 2.;

            }
            else speedmult = 1.;
        }

        if(level & CONTROL_FWD)
        {
            //llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <forward_power,0,0>);
            
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <speedmult*forward_power,0,0>);  
            reverse=1;
        }
        else if(level & CONTROL_BACK)
        {
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <reverse_power,0,0>);
            reverse = -1;
        }

        if(level & (CONTROL_RIGHT|CONTROL_ROT_RIGHT))
        {
            angular_motor.z -= speed / turning_ratio * reverse;
            angular_motor.x += 5;
  
        }
        else if(level & (CONTROL_LEFT|CONTROL_ROT_LEFT))
        {
            angular_motor.z += speed / turning_ratio * reverse;
            angular_motor.x -= 5;
        }
        

        // going up or stop going up
        if(level & CONTROL_UP) {
             llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <0,0,VERTICAL_THRUST>);
            angular_motor.y = -5;     
        } 

           
        // going down or stop going down        
        if(level & CONTROL_DOWN) {
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <0,0,-VERTICAL_THRUST>);
            angular_motor.y = 1 ;  
        } 

        llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION, angular_motor);
        


    } //end control   
    
    
    
   
    
    timer()
    {
        if (shouldDie)
        {
            //llDie();
            return;
        }
        
        float vel = llVecMag(llGetVel());
        string an;
        if (vel >1.)
            an = "swim";
        else 
            an = "tread";
            
        if (an != curanim)
        {
            
            //llStopAnimation(curanim);
            curanim = an;
            key npc = llAvatarOnLinkSitTarget(2);
            if (npc != NULL_KEY)
            {
                if (curanim == "tread")
                {
                    llStopAnimation("horse_sit_walk");
                    llStartAnimation("horse_sit");
                    

                    //llSetLinkPrimitiveParamsFast(3,[PRIM_POS_LOCAL, <0.0, 0.0, -0.55>, PRIM_ROT_LOCAL, ZERO_ROTATION]);
                    osNpcPlayAnimation(npc, "dragon1");
                    llParticleSystem([]);
                    llStopSound();
                }
                else
                {
                    llStopAnimation("horse_sit");
                    llStartAnimation("horse_sit_walk");

                    osNpcPlayAnimation(npc, "dragon1");
                    //llLoopSound("gallup",1.0);
                    psystem();
                }
            }
            //llStartAnimation(curanim);
        }
        
    }
    
} //end default 