// A basic OpenSimulator Walk and Stand animation override
// All Modifications are Copyright 2010 by Doug Osborn.
 
// This script is Licensed under the Creative Commons Attribution-Share Alike 3.0 License
//  For a copy of the license terms  please see  http://creativecommons.org/licenses/by-sa/3.0
 
// This work uses content from the Second Life® Wiki article llGetAnimation. (http://wiki.secondlife.com/wiki/LlGetAnimation)
// Copyright © 2007-2009 Linden Research, Inc. Licensed under the Creative Commons Attribution-Share Alike 3.0 License
 
// This AO is optimized for OpenSimulator and DOES NOT POLL the animation list multiple times a second
// It relies instead on the CHANGED ANIMATION event.  The timer is ONLY active when your avatar is swapping between stands.
 
// It is NOT optimized code.  Yes it could be smaller and probably faster.  This is simple, and is intended to provide a working object
// instead of a lasting tribute to anyones programming prowess.  Feel free to Optimize and re-distribute to your hearts content.
 
// To use:   Place this script in an object that will be attached to your avatar
//           Place the animations in the same prim
//           Change the CUSTOMIZATION section to reflect the names of YOUR animations.
//           Attach to your avatar or a HUD position
 
// To Reset  Detach and re-attach the object    or   Edit the object and Reset the script
 
// All of the overrides available via the traditional ZHAO can be controlled via this script.  
// The following Animation Types can be used by expanding the StartAnimation function to include the animation type
//
// [ Standing ]
// [ Walking ]
// [ Sitting ]
// [ Sitting On Ground ]
// [ Crouching ]
// [ Crouch Walking ]
// [ Landing ]
// [ Standing Up ]
// [ Falling ]
// [ Flying Down ]
// [ Flying Up ]
// [ Flying ]
// [ Flying Slow ]
// [ Hovering ]
// [ Jumping ]
// [ Pre Jumping ]
// [ Running ]
// [ Turning Right ]
// [ Turning Left ]
// [ Floating ]
// [ Swimming Forward ]
// [ Swimming Up ]
// [ Swimming Down ]
 
//  **************************   Customize YOUR AO  by  changing the names of the Animations, and the cycle time for your stands here.
 
// Change the folling lines to reflect the animation names you want to use
 
list StandNames = ["stand1","stand2","stand3","stand4","stand5","stand6","stand7","stand8","stand9","stand10"];
integer StandTime = 12;  //  change this number to the number of seconds between stands
list WalkAnimations = ["walk1","walk3","walk4","walk5","walk6","walk7","walk8"];   //  Change this string to the name of the Walk animation you want to use

list FlyAnimations = ["skyborn2", "skyborn3", "fly5", "fall4"];
string RunAnimation = "runn2";   //  Change this string to the name of the Run animation you want to use
string SitAnimation = "sit3";   //  Change this string to the name of the sit animation you want to use 
string CrouchAnimation = "crouch walk";    //  Change this string to the name of the crouch animation you want to use

string HoverAnimation = "fall4";   //  Change this string to the name of the hover animation you want to use
string SoftLandAnimation = "landing";   //  Change this string to the name of the softland animation you want to use
integer LandingTime = 3;                          //  Change this to reflect the length of the standing animation in seconds.
 
list JumpAnimations = ["jump", "jump1", "jump2", "jumpflip", "jumpkick"];   //  Change this string to the name of the Jump animation you want to use
 
//  *******************************************************************************************************************************
 
// *****  Below there be dragons  <wink>   not really!  *******  
 
//  You should not need to change anything below these lines
//  You are welcome to.  If you break it, you get to keep all the parts!
//   
 
key Owner; // the wearer's key
 
string LastAnimation = ""; // last llGetAnimation value seen
 
string LastAnimName = "";
 
string newAnimation = "";
 
float StandCount = 0.0;
 
integer PowerStatus = 1;
 
vector onColor = <42,255,42>;           // all nice and green
 
vector offColor = <128,128,128>;        // and grey
 
// User functions
 
Initialize(key id) 
{
    if (id == NULL_KEY)                         // detaching
    { 
        llSetTimerEvent(0.0);                       // stop the timer
    }
    else                                        // attached, or reset while worn
    { 
        llRequestPermissions(id, PERMISSION_TRIGGER_ANIMATION);
        Owner = id;
        StandCount = (float) llGetListLength(StandNames);
    }
}
 
OnOff()
{
    vector color;
 
    if (PowerStatus == 0) 
    {
        PowerStatus = 1;
        newAnimation = llGetAnimation(Owner);
        StartAnimation();
        llOwnerSay("Over-ride active");
        color = onColor;
    }
    else
    {
        PowerStatus = 0;
        //llStopAnimation(LastAnimName);
        osNpcStopAnimation(Owner, LastAnimName);
        llOwnerSay("Over-ride off");
        color = offColor;
    }
 
    llSetColor(color/255.0, ALL_SIDES);
}
 
StartAnimation()
{
            if (LastAnimation != newAnimation)    
            { 
                //osNpcStopAnimation(Owner, LastAnimName);
                llStopAnimation(LastAnimName);
                
                if (newAnimation == "Walking") 
                { 


                    string anim = llList2String(WalkAnimations, (integer)llFrand(llGetListLength(WalkAnimations)));
                    if(anim != "")
                    {                    
                        LastAnimName = anim;
 
                        llStartAnimation(anim);
                    }
 
                    llSetTimerEvent(0);
                }
 
                if (newAnimation == "Running") 
                { 

 
                    if(RunAnimation != "")
                    {                    
                        LastAnimName = RunAnimation;
 
                        llStartAnimation(LastAnimName);
                        //osNpcPlayAnimation(Owner, LastAnimName);
                    }
 
                    llSetTimerEvent(0);
 
                }                                
 
                if (newAnimation == "Standing") 
                { 
 
 
                    if(StandCount > 0.0)
                    {
 
                        integer whichone = (integer)llFrand(StandCount);// pick a new stand
 
                        LastAnimName = llList2String (StandNames,whichone);
 
                        llStartAnimation(LastAnimName);
                        //osNpcPlayAnimation(Owner, LastAnimName);
 
                        if(StandCount > 1.0)                   
                             llSetTimerEvent(StandTime);
                    }                    
                    else
                    {
                        llSetTimerEvent(0);
                    }                        
                }  
 
                if (newAnimation == "Sitting" && 0 ) 
                { 

 
                   if(SitAnimation != "")
                    {                    
                        LastAnimName = SitAnimation;
 
                        llStartAnimation(LastAnimName);
                        //osNpcPlayAnimation(Owner, LastAnimName);
                    }
 
                    llSetTimerEvent(0);                   
                }  
 
                if (newAnimation == "Flying") 
                { 

                    string anim = llList2String(FlyAnimations, (integer)llFrand(llGetListLength(FlyAnimations)));
                    if(anim != "")
                    {                    
                        LastAnimName = anim;
                        llStartAnimation(LastAnimName);
                        //osNpcPlayAnimation(Owner, LastAnimName);
                    }
 
                    llSetTimerEvent(0);
 
                }
 
                if (newAnimation == "Hovering") 
                { 

 
                    if(HoverAnimation != "")
                    {                    
                        LastAnimName = HoverAnimation;
 
                        llStartAnimation(LastAnimName);
                        //osNpcPlayAnimation(Owner, LastAnimName);
                    }
 
                    llSetTimerEvent(0);
 
                }
 
                if (newAnimation == "Soft Landing") 
                { 

 
                    if(SoftLandAnimation != "")
                    {                    
                        LastAnimName = SoftLandAnimation;
 
                        llStartAnimation(LastAnimName);
                        //osNpcPlayAnimation(Owner, LastAnimName);
 
                        llSetTimerEvent(LandingTime);
                    }
 
                    llSetTimerEvent(0);
 
                }
 
                if (newAnimation == "Crouching") 
                { 
 
                    if(CrouchAnimation != "")
                    {                    
                        LastAnimName = CrouchAnimation;
 
                        llStartAnimation(LastAnimName);
                        //osNpcPlayAnimation(Owner, LastAnimName);
                    }
 
                    llSetTimerEvent(0);
 
                }                
 
                if (newAnimation == "Jumping") 
                { 

                    string anim = llList2String(JumpAnimations, (integer)llFrand(llGetListLength(JumpAnimations)));
                    if(anim != "")
                    {                    
                        LastAnimName = anim;
 
                        llStartAnimation(anim);
                    }
 
                    llSetTimerEvent(0);
 
                }                                                          
    }
}  
 
 
// Event handlers
 
default
{
    state_entry()
    {
        // script was reset while already attached
        if (llGetAttached() != 0) {
            Initialize(llGetOwner());
            llSay(0,"AO owner is " + llGetOwner());
        }
    }
 
    attach(key id) {
        Initialize(id);
    }
 
    run_time_permissions(integer perm) 
    {
        if (perm & PERMISSION_TRIGGER_ANIMATION) {
            llOwnerSay("AO active"); 
        }
    }
 
    touch_start(integer whodunit)
    {
        OnOff();
    }
 

    changed (integer change)
    {
        if (change & CHANGED_ANIMATION)
        {
 
            newAnimation = llGetAnimation(Owner);
 
            StartAnimation();
 
            LastAnimation = newAnimation; // so we can check for changes
 
//            llOwnerSay("started " + newAnimation);  // uncomment this to see the event types you can respond to 
 
//            llOwnerSay( "using " + LastAnimName);  // uncomment this to see which animations are being used
 
 
        }
    }
}