// This is a generic door / drawer script.
// It can be used for anything that you need to slide back and forth when you touch it.
// Now does rotations to, as well as periodic changes.
// It can handle multiple doors independantly, except they all must move the same.
//
// While it was originally someone elses script, I have rewritten EVERYTHING.  lol
// Copyright 2011 by the avatar known as onefang Rejected in Infinite Grid.
// Likely released under a three clause BSD license.  lol

// To use this script -
// Put ONE copy in the object somewhere.
//   Usually the root prim is good, but that's not important.  (I think.)
// 
// Name the door prims something with the text "doorPrim" in it.
//   Name all the prims for any given door exactly the same,
//   but different names from the prims in the other doors.
//   The "Prim name replicator" script might come in handy for this job.
// 
// IMPORTANT - if you move the prims around,
//   make sure to clear out the description of the door prims.
//   Replacing the description with a space works.
//   Those prim descriptions store the original positions,
//   so things can get confused if you don't.
//
//   The script should detect resizes and linkset changes to help with this,
//   anything else you should use the "update" command on the channel mentioned below.
//
// Change this to be the slide / swing you need.
//   LIMITATION - All doors will move the same amount.  DOH!
// TODO - Add a config notecard.  Though without one, just default to this slide / swing.
vector slide = <0.15, 0.0, 0.0>;
vector swing = <0.0, 0.0, 0.0>;
float period = 0.5;

// Change this to the channel you want for the update command.
integer channel = 4;

// Change this to TRUE while you are editing, and FALSE when you are done.
// Gets rid of an annoying message when people sit on it.
integer editing = FALSE;


// Don't touch the rest.
list doorPrims = [];
string pulse = "";


updatePositions()
{
    integer link; 

    llSay(0, "Updating the door prim positions.");
    for (link = llGetNumberOfPrims(); link >= 1; --link)
    {
        if (llSubStringIndex(llGetLinkName(link), "doorPrim") != -1)
            llSetLinkPrimitiveParamsFast(link, [PRIM_DESC, ""]);
    }
    llResetScript();
}

openClose(string name)
{
    integer j;

    if (llSubStringIndex(name, "doorPrim") != -1)
    {
        for (j = llGetListLength(doorPrims) - 1; j >= 1; j -= 4)
        {
            integer link = llList2Integer(doorPrims, j - 3);

            if (llGetLinkName(link) == name)
            {
                vector thisMove    = llList2Vector( doorPrims, j - 2);
                rotation thisRot   = llList2Rot(    doorPrims, j - 1);
                integer doorClosed = llList2Integer(doorPrims, j);

                if (doorClosed)
                {
                    thisMove += slide;
                    thisRot = llEuler2Rot(swing * DEG_TO_RAD) * thisRot;
                }

                llSetLinkPrimitiveParamsFast(link, [PRIM_POSITION, thisMove, PRIM_ROTATION, thisRot]);
                doorPrims = llListReplaceList(doorPrims, [!doorClosed], j, j);
            }
        }
    }
}

default
{
    state_entry()
    {
        vector rootPos = llGetRootPosition();
        rotation rootRot = llGetRootRotation();
        integer link;

        // Find all doorPrims.
        // Check if they have positions stored on their descriptions,
        //   restore if found.
        // Store position in a list for later.
        for (link = llGetNumberOfPrims(); link >= 1; --link)
        {
            if (llSubStringIndex(llGetLinkName(link), "doorPrim") != -1)
            {
                list   params = llGetLinkPrimitiveParams(link, [PRIM_DESC, PRIM_POSITION, PRIM_ROTATION]);
                string desc = llList2String(params, 0);
                vector pos = llList2Vector(params, 1);
                rotation rot = llList2Rot(params, 2);

                if ("" == llStringTrim(desc, STRING_TRIM))
                {
                    // WARNING!!  llSetLinkPrimitiveParams(PRIM_POSITION) is relative to the root, but the get is NOT!
                    // Oh, and the set rotation is buggy (blame LL), gotta apply the rootRot twice.  sigh
                    pos = (pos - rootPos) / rootRot;
                    rot = (rot / rootRot) / rootRot;
                }
                else
                {
                    string temp;

                    params = llParseStringKeepNulls(desc, "|", "");
                    pos = llList2Vector(params, 0);
                    temp = llStringTrim(llList2String(params, 1), STRING_TRIM);
                    if ("" == temp)
                        rot = (rot / rootRot) / rootRot;
                    else
                        rot = (rotation) temp;
                }
                doorPrims += [link, pos, rot, TRUE];
                llSetLinkPrimitiveParamsFast(link, [PRIM_DESC, (string) pos + "|" + (string) rot, PRIM_POSITION, pos, PRIM_ROTATION, rot]);
            }
        }
        llListen(channel, "", "", "update");
    }

    changed(integer change)
    {
        if ((CHANGED_LINK & change) || (CHANGED_SCALE & change) || (CHANGED_SHAPE & change))
        {
            if ((CHANGED_LINK & change) && !editing)
                return;
            llSay(0, "Linkset change detected, say -\n/" + (string) channel + "update\n to update door prim positions.");
        }
    }

    listen(integer channel, string name, key id, string message)
    {
        updatePositions();
    }

    touch_start(integer num_detected)
    {
        integer i;
        rotation rootRot = llGetRootRotation();

        // Respond to each touch.
        // If the prim touched is a doorPrim,
        //   Find all the matching doorPrims and open / close them.
        for (i = 0; i < num_detected; i++)
        {
            string name = llGetLinkName(llDetectedLinkNumber(i));

            if (period)
            {
                if ("" == pulse)
                {
                    pulse = name;
                    llSetTimerEvent(period);
                }
                else
                {
                    pulse = "";
                    llSetTimerEvent(0.0);
                }
            }
            openClose(name);
        }
    }

    timer()
    {
        openClose(pulse);
    }
}
 