// Table Dance Script
// by Aine Caoimhe 2015

key user=NULL_KEY;
integer indexAnim;
list anims;
float danceTimer;
vector pos=<0.0,0.0,0.00001>;
rotation rot=ZERO_ROTATION;

default
{
    state_entry()
    {
        llSitTarget(pos,rot);
        anims=[];
        integer i=llGetInventoryNumber(INVENTORY_ANIMATION);
        while (--i>=0)
        {
            anims=[]+llGetInventoryName(INVENTORY_ANIMATION,i)+anims;
        }
        indexAnim=0;
    }
    changed (integer change)
    {
        if (change & CHANGED_LINK)
        {
            key who=llAvatarOnSitTarget();
            if (who==NULL_KEY)
            {
                if (user!=NULL_KEY)
                {
                    if (llGetAgentSize(user)!=ZERO_VECTOR)
                    {
                        list animsToStop=llGetAnimationList(user);
                        llStartAnimation("stand");
                        integer stop=llGetListLength(animsToStop);
                        while (--stop>=0)
                        {
                            llStopAnimation(llList2String(animsToStop,stop));
                        }
                    }
                    user=NULL_KEY;
                    indexAnim=0;
                    llSetTimerEvent(0.0);
                }
            }
            else
            {
                user=who;
                indexAnim=0;
                llRequestPermissions(who,PERMISSION_TRIGGER_ANIMATION);
            }
        }
        else if (change & CHANGED_REGION_START) llResetScript();
    }
    timer()
    {
        if ((user==NULL_KEY) || (llGetAgentSize(user)==ZERO_VECTOR))
        {
            llSetTimerEvent(0.0);
            indexAnim=0;
            return;
        }
        string anToStop=llList2String(anims,indexAnim);
        indexAnim++;
        if (indexAnim>=llGetListLength(anims)) indexAnim=0;
        string anToStart=llList2String(anims,indexAnim);
        danceTimer=(float)llGetSubString(anToStart,llSubStringIndex(anToStart," ")+1,-1);
        danceTimer=danceTimer-1;
        llStartAnimation(anToStart);
        llStopAnimation(anToStop);
        llSetTimerEvent(danceTimer);
    }
    run_time_permissions(integer perm)
    {
        if (perm & PERMISSION_TRIGGER_ANIMATION)
        {
            if (llGetAttached()==0)
            {
                vector size = llGetAgentSize(user);
                rotation localrot = ZERO_ROTATION;
                vector localpos = ZERO_VECTOR;
                if(llGetLinkNumber() > 1)//only need the local rot if it's not the root.
                {
                    localrot = llGetLocalRot();
                    localpos = llGetLocalPos();
                }
                integer linkNum = llGetNumberOfPrims();
                do
                {
                    if(user == llGetLinkKey( linkNum ))//just checking to make sure the index is valid.
                    {
                    //<0.008906, -0.049831, 0.088967> are the coefficients for a parabolic curve that best fits real avatars. It is not a perfect fit.
                    float fAdjust = ((((0.008906 * size.z) + -0.049831) * size.z) + 0.088967) * size.z;
                    llSetLinkPrimitiveParamsFast(linkNum,
                        [PRIM_POS_LOCAL, ((pos + <0.0, 0.0, 0.4>) - (llRot2Up(rot) * fAdjust)) * localrot + localpos,
                         PRIM_ROT_LOCAL, rot * localrot]);
                    jump end;//cheaper but a tad slower then return
                    }
                }while( --linkNum );
                @end;
            }
            string anToStart=llList2String(anims,indexAnim);
            danceTimer=(float)llGetSubString(anToStart,llSubStringIndex(anToStart," ")+1,-1);
            list animsToStop=llGetAnimationList(user);
            llStartAnimation(anToStart);
            integer stop=llGetListLength(animsToStop);
            while (--stop>=0)
            {
                llStopAnimation(llList2String(animsToStop,stop));
            }
            llSetTimerEvent(danceTimer);
       }
    }
} 