/*//( v7-D Simple Hinge Action )--//*/
/*//-- Works At ANY Angle --//*/

/*//-- NOTES:
 works in ANY single prim door, linked or un-linked
 works in multi-prim doors NOT linked to a larger structure
 Never needs reset (even after moving/rotating)
//*/

/*//-- REQUIREMENTS:
 Root should either be a cylinder (to represent a hinge) or half cut prim;
 I suggest Box, pathcut start=.125, end=.625
//*/

/*//-- CAVEAT:
 Single prim doors are limited to 5m width
 Treats current position as closed when reset
//*/

 /*//-- USERS MODIFY HERE v --//*/
integer gIntSwing = 90;
/*//-- use -# to reverse the direction of swing, eg. -90; --//*/
rotation gRotSwing;

default{
    state_entry(){
        gRotSwing = llEuler2Rot( <0.0,  (float)gIntSwing * DEG_TO_RAD,0.0> );
    }
    
    touch_end( integer vIntNul ){
         llSetLocalRot( (gRotSwing = (ZERO_ROTATION / gRotSwing)) * llGetLocalRot() );
    }
}

/*//-- IF Redistributing as-is:
Please leave script full permissions & include all comments so that others may learn and use
//*/