string chatKey = "";
string NPCNAME="INVALID";
key npc = NULL_KEY;
integer gListener=-1;
integer zListener=-1;
integer aviNameLength;
string status = "";
integer lightOn = 0;
list talkedUids;
string lastAnim="";


// A basic OpenSimulator Walk and Stand animation override
// All Modifications are Copyright 2010 by Doug Osborn.
 
// This script is Licensed under the Creative Commons Attribution-Share Alike 3.0 License
//  For a copy of the license terms  please see  http://creativecommons.org/licenses/by-sa/3.0
 
// This work uses content from the Second Life® Wiki article llGetAnimation. (http://wiki.secondlife.com/wiki/LlGetAnimation)
// Copyright © 2007-2009 Linden Research, Inc. Licensed under the Creative Commons Attribution-Share Alike 3.0 License
 
// This AO is optimized for OpenSimulator and DOES NOT POLL the animation list multiple times a second
// It relies instead on the CHANGED ANIMATION event.  The timer is ONLY active when your avatar is swapping between stands.
 
// It is NOT optimized code.  Yes it could be smaller and probably faster.  This is simple, and is intended to provide a working object
// instead of a lasting tribute to anyones programming prowess.  Feel free to Optimize and re-distribute to your hearts content.
 
// To use:   Place this script in an object that will be attached to your avatar
//           Place the animations in the same prim
//           Change the CUSTOMIZATION section to reflect the names of YOUR animations.
//           Attach to your avatar or a HUD position
 
// To Reset  Detach and re-attach the object    or   Edit the object and Reset the script
 
// All of the overrides available via the traditional ZHAO can be controlled via this script.  
// The following Animation Types can be used by expanding the StartAnimation function to include the animation type
//
// [ Standing ]
// [ Walking ]
// [ Sitting ]
// [ Sitting On Ground ]
// [ Crouching ]
// [ Crouch Walking ]
// [ Landing ]
// [ Standing Up ]
// [ Falling ]
// [ Flying Down ]
// [ Flying Up ]
// [ Flying ]
// [ Flying Slow ]
// [ Hovering ]
// [ Jumping ]
// [ Pre Jumping ]
// [ Running ]
// [ Turning Right ]
// [ Turning Left ]
// [ Floating ]
// [ Swimming Forward ]
// [ Swimming Up ]
// [ Swimming Down ]
 
//  **************************   Customize YOUR AO  by  changing the names of the Animations, and the cycle time for your stands here.
 
// Change the folling lines to reflect the animation names you want to use
 
list StandNames = ["alpastand1","alpastand2","alpastand3","alpastand4","alpastand5","alpastand6","alpastand7","alpastand8","alpastand9","alpastand10"];
list WalkAnimations = ["walk1","walk3","walk4","walk5","walk6","walk7","walk8"];   //  Change this string to the name of the Walk animation you want to use
list FlyAnimations = ["skyborn2", "skyborn3", "fly5"];
string RunAnimation = "runn2";   //  Change this string to the name of the Run animation you want to use
string SitAnimation = "sit3";   //  Change this string to the name of the sit animation you want to use 
string CrouchAnimation = "crouch walk";    //  Change this string to the name of the crouch animation you want to use
string HoverAnimation = "FlyingLevel1";   //  Change this string to the name of the hover animation you want to use
string SoftLandAnimation = "landing";   //  Change this string to the name of the softland animation you want to use
integer LandingTime = 3;                          //  Change this to reflect the length of the standing animation in seconds.

list JumpAnimations = ["jump", "jump1", "jump2", "jumpflip", "jumpkick"];   //  Change this string to the name of the Jump animation you want to use
 

key Owner; // the wearer's key
 
string LastAnimation = ""; // last llGetAnimation value seen
 
string LastAnimName = "";
 
string newAnimation = "";
 
float StandCount = 0.0;
 
integer isOn = 1;
 
Initialize(key id) 
{
    if (id == NULL_KEY)                         // detaching
    { 
        
    }
    else                                        // attached, or reset while worn
    { 
        llRequestPermissions(id, PERMISSION_TRIGGER_ANIMATION);
        Owner = id;
        StandCount = (float) llGetListLength(StandNames);
    }
}

StartAnimation()
{
            if (LastAnimation != newAnimation)    
            { 
                //osNpcStopAnimation(Owner, LastAnimName);
                llStopAnimation(LastAnimName);
                
                if (newAnimation == "Walking") 
                { 
                    //llPlaySound("hooves", 0.3);

                    string anim = llList2String(WalkAnimations, (integer)llFrand(llGetListLength(WalkAnimations)));
                    if(anim != "")
                    {                    
                        LastAnimName = anim;
 
                        llStartAnimation(anim);
                    }
 
   
                }
 
                if (newAnimation == "Running") 
                { 
                    //llPlaySound("hooves", 0.3);
 
                    if(RunAnimation != "")
                    {                    
                        LastAnimName = RunAnimation;
 
                        llStartAnimation(LastAnimName);
                        //osNpcPlayAnimation(Owner, LastAnimName);
                    }
 
  
 
                }                                
 
                if (newAnimation == "Standing") 
                { 
 
                    //llStopSound();
                    if(StandCount > 0.0)
                    {
 
                        integer whichone = (integer)llFrand(StandCount);// pick a new stand
                        LastAnimName = llList2String (StandNames,whichone);
                        llStartAnimation(LastAnimName);
                        //osNpcPlayAnimation(Owner, LastAnimName);
                    }                    
                    else
                    {

                    }                        
                }  
 

 
                if (newAnimation == "Flying") 
                { 

                    string anim = llList2String(FlyAnimations, (integer)llFrand(llGetListLength(FlyAnimations)));
                    if(anim != "")
                    {                    
                        LastAnimName = anim;
                        llStartAnimation(LastAnimName);
                        //osNpcPlayAnimation(Owner, LastAnimName);
                    }
 
                }
 
                if (newAnimation == "Hovering") 
                { 

 
                    if(HoverAnimation != "")
                    {                    
                        LastAnimName = HoverAnimation;
                        llStartAnimation(LastAnimName);
                        //osNpcPlayAnimation(Owner, LastAnimName);
                    }

 
                }
 
                if (newAnimation == "Soft Landing") 
                { 

 
                    if(SoftLandAnimation != "")
                    {                    
                        LastAnimName = SoftLandAnimation;
 
                        llStartAnimation(LastAnimName);
                        //osNpcPlayAnimation(Owner, LastAnimName);
 
                    }
 
 
                }
 
                if (newAnimation == "Crouching") 
                { 
 
                    if(CrouchAnimation != "")
                    {                    
                        LastAnimName = CrouchAnimation;
 
                        llStartAnimation(LastAnimName);
                        //osNpcPlayAnimation(Owner, LastAnimName);
                    }

                }                
 
                if (newAnimation == "Jumping") 
                { 

                    string anim = llList2String(JumpAnimations, (integer)llFrand(llGetListLength(JumpAnimations)));
                    if(anim != "")
                    {                    
                        LastAnimName = anim;
 
                        llStartAnimation(anim);
                    }
 
 
                }                                                          
    }
}  


InitListener()
{

    key id = llGetOwner();
    if (id)
    {
        string name= llKey2Name(llGetOwner());
        NPCNAME = llGetSubString(name, 0, llSubStringIndex(name, " ") - 1);
        if (zListener <0)
        {
            zListener = osListenRegex(0, "", "", "^(?i)(hi|hello|"+NPCNAME+" )(?-i)", OS_LISTEN_REGEX_MESSAGE);
            llOwnerSay("Listening for '"+NPCNAME+"'");
        }
    }
}


// Event handlers 
default
{
    state_entry()
    {
        // script was reset while already attached
        if (llGetAttached() != 0) {
            Initialize(llGetOwner());
            //InitListener();
        }
    }
 
    on_rez(integer i) {
        llResetScript();
    }
 
    run_time_permissions(integer perm) 
    {
        if (perm & PERMISSION_TRIGGER_ANIMATION) {
            llOwnerSay("AO active"); 
        }
    }
    changed (integer change)
    {
        if (isOn)
        if (change & CHANGED_ANIMATION)
        {
            newAnimation = llGetAnimation(Owner);
            StartAnimation();
            LastAnimation = newAnimation; // so we can check for changes

        }
    }

    listen(integer chan, string name, key id, string mes) 
    {
        llRegionSay(68, "! "+(string)id+ " " +NPCNAME+ " "+mes);
    }
    
    dataserver(key qid, string mes)
    {
        if (mes == "find-balls")
        {
            llSensor("~ball3", "", SCRIPTED, 16, PI);
            llSensor("~ball2", "", SCRIPTED, 16, PI);
            llSensor("~ball1", "", SCRIPTED, 16, PI);
            llSensor("~ball0", "", SCRIPTED, 16, PI);
            status="looking1";
        }
        else if (llGetSubString(mes, 0,1) == "do")
        {
            string bn = llGetSubString(mes, 3, llStringLength(mes));
            llSensor(bn, "", SCRIPTED, 16, PI);
            status="looking2";
        }
        else if (llGetSubString(mes, 0,6) == "lookfor")
        {
            string bn = llGetSubString(mes, 3, llStringLength(mes));
            llSensor(bn, "", ACTIVE, 30, PI);
            status="looking2";
        }

        else if (llGetSubString(mes, 0,4) == "sound")
        {
            list tok = llParseString2List(mes, [" "], []);
            llPlaySound(llList2Key(tok,1), llList2Float(tok,2));
        }
        else if (llGetSubString(mes, 0, 4) == "light")
        {
            lightOn = !lightOn;
            llSetPrimitiveParams([PRIM_POINT_LIGHT, lightOn, <0.973, 0.543, 0.055>, 1.0, 20.0, 0.1]);
        }
        else if (llGetSubString(mes, 0, 8) == "aodisable") isOn=0;
        else if (llGetSubString(mes, 0, 7) == "aoenable") isOn=1;
        else if (llGetSubString(mes, 0, 3) == "anim")
        {
            llStopAnimation(lastAnim);
            integer sep =  llSubStringIndex(mes, ":");
            integer dur = (integer)llGetSubString(mes, 5, sep);

            lastAnim = llGetSubString(mes, sep+1, llStringLength(mes));
            llOwnerSay("Playing /" + lastAnim+"/");
            llStartAnimation(lastAnim);
            llSetTimerEvent(dur);
        }
     
    }
    
    sensor(integer detected)
    {

        list det = [];
        integer i;
        for (i=0;i < detected; i++)
        {
            key k = llDetectedKey(i);
            det += k;
        }
        llRegionSay(68, "FBALL "+NPCNAME+" "+llDumpList2String(det," "));
    }
    
    
    timer()
    {
        llStopAnimation(lastAnim);
        llSetTimerEvent(0);
    }
    
}

