
integer effects =0;
float forward_power = 17; //Power used to go forward (1 to 30)
float reverse_power = -5; //Power ued to go reverse (-1 to -30)
float turning_ratio = .8; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)
string sit_message = "DRIVE"; //Sit message
string not_owner_message = "You are not the owner of this vehicle ..."; //Not owner message
string drive_anim = "Sit01";

float curRot; 

integer shouldDie = 0;

//Anything past this point should only be modfied if you know what you are doing

stoppsystem()
{
        llLinkParticleSystem(2, []);
}
psystem()
{
     llLinkParticleSystem(2,
        [
            PSYS_SRC_PATTERN,PSYS_SRC_PATTERN_EXPLODE,
            PSYS_SRC_BURST_RADIUS,.3,
            PSYS_SRC_ANGLE_BEGIN,PI/2,
            PSYS_SRC_ANGLE_END,PI/2 + 0.1,
            PSYS_SRC_TARGET_KEY,llGetKey(),
            PSYS_PART_START_COLOR,<1.000000,1.000000,1.000000>,
            PSYS_PART_END_COLOR,<1.000000,1.000000,1.000000>,
            PSYS_PART_START_ALPHA,.7,
            PSYS_PART_END_ALPHA,0.,
            PSYS_PART_START_GLOW,0,
            PSYS_PART_END_GLOW,0,
            PSYS_PART_BLEND_FUNC_SOURCE,PSYS_PART_BF_SOURCE_ALPHA,
            PSYS_PART_BLEND_FUNC_DEST,PSYS_PART_BF_ONE_MINUS_SOURCE_ALPHA,
            PSYS_PART_START_SCALE,<1.30000,1.00000,0.000000>,
            PSYS_PART_END_SCALE,<2,2, 0.000000>,
            PSYS_SRC_TEXTURE,"3a7ea058-e486-4d21-b2e6-8b47462bb45b",
            PSYS_SRC_MAX_AGE,0,
            PSYS_PART_MAX_AGE,6,
            PSYS_SRC_BURST_RATE,0.01,
            PSYS_SRC_BURST_PART_COUNT,4,
            PSYS_SRC_ACCEL,<0.000000,0.000000,-1.00000>,
            PSYS_SRC_OMEGA,<0.000000,0.000000,0.000000>,
            PSYS_SRC_BURST_SPEED_MIN,0.6,
            PSYS_SRC_BURST_SPEED_MAX,0.6,
            PSYS_PART_FLAGS,
                0 
                | PSYS_PART_INTERP_COLOR_MASK
                | PSYS_PART_INTERP_SCALE_MASK
                | PSYS_PART_BOUNCE_MASK
                | PSYS_PART_EMISSIVE_MASK
        ]);
}


setVehicle() { 
        
        llSetCameraEyeOffset(<-10, 0.0, 3.0>);
        
        llSetLinkPrimitiveParamsFast(LINK_ALL_CHILDREN, [PRIM_PHYSICS_SHAPE_TYPE, PRIM_PHYSICS_SHAPE_NONE]);
        llSetVehicleFlags(0);
        llSetVehicleType(VEHICLE_TYPE_BOAT);
        llSetVehicleFlags(VEHICLE_FLAG_HOVER_UP_ONLY | VEHICLE_FLAG_HOVER_WATER_ONLY);
        llSetVehicleVectorParam( VEHICLE_LINEAR_FRICTION_TIMESCALE, <.8, .8, 1> );
        llSetVehicleFloatParam( VEHICLE_ANGULAR_FRICTION_TIMESCALE, 3 );

        
        
        llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <0, 0, 0>);
        llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 1);
        llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_DECAY_TIMESCALE, 0.05);
        
        llSetVehicleFloatParam( VEHICLE_ANGULAR_MOTOR_TIMESCALE, 1 );
        llSetVehicleFloatParam( VEHICLE_ANGULAR_MOTOR_DECAY_TIMESCALE, 5 );
        llSetVehicleFloatParam( VEHICLE_HOVER_HEIGHT, 0.15);
        llSetVehicleFloatParam( VEHICLE_HOVER_EFFICIENCY,.5 );
        llSetVehicleFloatParam( VEHICLE_HOVER_TIMESCALE, 2.0 );
        llSetVehicleFloatParam( VEHICLE_BUOYANCY, 1 );
        llSetVehicleFloatParam( VEHICLE_LINEAR_DEFLECTION_EFFICIENCY, 0.5 );
        llSetVehicleFloatParam( VEHICLE_LINEAR_DEFLECTION_TIMESCALE, 3 );
        llSetVehicleFloatParam( VEHICLE_ANGULAR_DEFLECTION_EFFICIENCY, 0.5 );
        llSetVehicleFloatParam( VEHICLE_ANGULAR_DEFLECTION_TIMESCALE, 10 );
        llSetVehicleFloatParam( VEHICLE_VERTICAL_ATTRACTION_EFFICIENCY, 0.5 );
        llSetVehicleFloatParam( VEHICLE_VERTICAL_ATTRACTION_TIMESCALE, 2 );
        llSetVehicleFloatParam( VEHICLE_BANKING_EFFICIENCY, 1 );
        llSetVehicleFloatParam( VEHICLE_BANKING_MIX, 0.1 );
        llSetVehicleFloatParam( VEHICLE_BANKING_TIMESCALE, .5 );
        llSetVehicleRotationParam( VEHICLE_REFERENCE_FRAME, ZERO_ROTATION );
        
    }


string curanim;

default
{
    
    on_rez(integer n)
    {
        llResetScript();   
    }
    
    state_entry()
    {
        //llSetSitText(sit_message);
        // forward-back,left-right,updown
        llSitTarget(<-.9,0.4,1.0>, llEuler2Rot(<0,0,-PI/2>) );
        
        setVehicle();
        
        shouldDie = 1;
        llSetTimerEvent(300);
    }
    
    changed(integer change)
    {
        
        
        if (change & CHANGED_LINK)
        {
            
            key agent = llAvatarOnLinkSitTarget(1);
            if (agent != NULL_KEY)
            {           
                llSetTimerEvent(0);
                setVehicle();     

                                        
                    stoppsystem();            
                    //llMessageLinked(LINK_ALL_CHILDREN , 0, "start", NULL_KEY);
                    llRequestPermissions(agent,  PERMISSION_TRIGGER_ANIMATION | PERMISSION_TAKE_CONTROLS);
                    //llSetLinkAlpha(2, 0.0, ALL_SIDES);
                    llSetStatus(STATUS_PHYSICS, TRUE);
                    llSleep(.4);
                    shouldDie = 0;


            }
            else
            {
                //llStopSound();
                
                llSetStatus(STATUS_PHYSICS, FALSE);
                llSleep(.2);
                llReleaseControls();
                llTargetOmega(<0,0,0>,PI,0);
                llStopAnimation("swim");
                llStopAnimation("tread");
                llSetTimerEvent(0);
                //llSetLinkAlpha(2,1.0, ALL_SIDES);
                vector r = llRot2Euler(llGetRot());
                r.x =0;
                r.y =0;
                llSetRot(llEuler2Rot(r));
                stoppsystem();
                
                llSetTimerEvent(300);
            }
        }
        
    }
    
    run_time_permissions(integer perm)
    {
        if (perm&PERMISSION_TAKE_CONTROLS)
        {
            llTakeControls(CONTROL_FWD | CONTROL_BACK | CONTROL_DOWN | CONTROL_UP | CONTROL_RIGHT | 
                            CONTROL_LEFT | CONTROL_ROT_RIGHT | CONTROL_ROT_LEFT, TRUE, FALSE);
        }
        if (perm & PERMISSION_TRIGGER_ANIMATION)
        {
            llStartAnimation(drive_anim);
        }
    }
    
    control(key id, integer level, integer edge)
    {
        integer reverse=1;
        vector angular_motor;
        
        //get current speed
        vector vel = llGetVel();
        float speed = llVecMag(vel);
        integer moving=0;
        float newRot;
        //car controls
        if(level & CONTROL_FWD)
        {
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <forward_power,0,0>);
            reverse=1;
            if (!(edge & CONTROL_FWD))
                moving=1;
            
        }
        if(level & CONTROL_BACK)
        {
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <reverse_power,0,0>);
            reverse = -1;
        }

        if(level & (CONTROL_RIGHT|CONTROL_ROT_RIGHT))
        {
            angular_motor.z -= speed / turning_ratio * reverse;
            angular_motor.x += 2;
            newRot = 0.1;
        }
        
        if(level & (CONTROL_LEFT|CONTROL_ROT_LEFT))
        {
            angular_motor.z += speed / turning_ratio * reverse;
            angular_motor.x -= 2;
    
            newRot = -0.1;
        }
    
        if (newRot != curRot)
        {
            curRot = newRot;
            llSetLinkPrimitiveParamsFast(3, [PRIM_ROT_LOCAL, llEuler2Rot(<PI/2, PI*(1+curRot), 0>)]);
        }
                
        if (moving>0 && !effects)
        {
            effects=1;
            psystem();
            llLoopSound("engine", 0.5);
        }
        else if (moving==0 && effects>0)
        {
            effects=0;
            stoppsystem();
        }

        llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION, angular_motor);

    } //end control   
    
    timer()
    {
            llDie();
        
    }
    
} //end default