vector POSITION=<-0.0, 0.0, -0.5>;
vector ROTATION = <0.0, 0.0, 0.0>;
string HOVERTEXT="";
string SIT_TEXT="Get on";
string HOVER_RGB="255,255,255";
list rgb;
string animation;
key whoisin = NULL_KEY;
list anims2stop;
float sleep = 0.5;
integer IsCuffed = TRUE;
integer HideOnSit = TRUE;

stop_anim(){
    integer list_pos = 0;
    integer list_length = llGetListLength(anims2stop);
    if(list_length > 0){
        while(list_pos < list_length){
            llStopAnimation(llList2String(anims2stop, list_pos));
            list_pos++;
        }
    }
}

set_text()
{
    if (llStringLength(HOVERTEXT)>0)
    {
        rgb=llCSV2List(HOVER_RGB);
        llSetText(HOVERTEXT,<llList2Float(rgb,0)*0.003921568627450980392156862745098,llList2Float(rgb,1)*0.003921568627450980392156862745098,llList2Float(rgb,2)*0.003921568627450980392156862745098>,1.0);

    }
    else
        llSetText("",<0,0,0>,0.0);
}

show()
{
    llSetText(HOVERTEXT, <1,1,1>,1);        
    llSetAlpha(1, ALL_SIDES);
}

hide()
{
    llSetText("", <1,1,1>,1);        
    llSetAlpha(0, ALL_SIDES);
}

default
{
    state_entry()
    {
        if (llStringLength(SIT_TEXT)>0)
            llSetSitText(SIT_TEXT);
        vector input = ROTATION * DEG_TO_RAD;
        rotation rot = llEuler2Rot(input);
        llSitTarget(POSITION, rot);
        set_text();
        animation=llGetInventoryName(INVENTORY_ANIMATION,0);
    }
    changed(integer change)
    {
        if (change & CHANGED_LINK)
        {

            if (llAvatarOnSitTarget() != NULL_KEY)
            {
                llRequestPermissions(llAvatarOnSitTarget(), PERMISSION_TRIGGER_ANIMATION);
            }
            else
            {
                integer perm=llGetPermissions();
                if ((perm & PERMISSION_TRIGGER_ANIMATION) && llStringLength(animation)>0)
                    llStopAnimation(animation);
                set_text();
                animation="";
                llMessageLinked(1,0,"Hide",NULL_KEY);
                if (IsCuffed)
                {
                    llMessageLinked(LINK_SET,1,"seated",whoisin);
                    whoisin = NULL_KEY;
                }
                if (HideOnSit) show();
            }
        }
    }
    run_time_permissions(integer perm)
    {
        if (perm & PERMISSION_TRIGGER_ANIMATION)
        {
            anims2stop = [];//Clears the list
            llStopAnimation("sit");
            llSleep(sleep);
            anims2stop = llGetAnimationList(llAvatarOnSitTarget());
            stop_anim();
            animation=llGetInventoryName(INVENTORY_ANIMATION,0);
            llStartAnimation(animation);
            llSetText("",<0,0,0>,0.0);
            if (HideOnSit) hide();
            if (IsCuffed)
            {whoisin= llAvatarOnSitTarget();
                    llMessageLinked(LINK_SET,0,"seated",llAvatarOnSitTarget());
                }
        }
    }


}


