integer DEBUG = FALSE;

string STARTSOUND = "774a5258-7ffc-4b87-ab32-a07e9a0bccd3";
string STOPSOUND = "callhorse";

float STARTSOUNDVOL = 1.0;
float STOPSOUNDVOL = 0.0;

integer PTA = PERMISSION_TRIGGER_ANIMATION;
integer PTC = PERMISSION_TAKE_CONTROLS;

key MyController;
integer InAnimation = FALSE;
integer Listening = 0;

default
{    
    attach(key attached)
    {
        if (Listening) llListenRemove(Listening);
        MyController = attached;
        llSay(0,"attached");
        
        llRequestPermissions(attached, PTA | PTC);
//        llRequestPermissions(attached, PTC);
        llSetTimerEvent(3);
    }
    
   touch_start(integer total_count)
   {
        integer i;
        for (i = 0; i < total_count; i++) {
          if (llDetectedKey(i) == MyController) {
               llStartAnimation("apple");
                InAnimation = TRUE;
                llSetTimerEvent(20.0);
            }
        }
    }
    
    timer()
    {
        if (InAnimation) {
            llStopAnimation("apple");
            //llTriggerSound(STOPSOUND, STOPSOUNDVOL);
            InAnimation = FALSE;
            llSetTimerEvent(0);
            return;
        }
        
        if ((llGetPermissions() & (PTA | PTC)) == (PTA | PTC)) {

            llTakeControls(CONTROL_LBUTTON, TRUE, FALSE);
            llSetTimerEvent(0);
            llWhisper(0, "Apple activated.  Type 'release' to release controls");
            if (Listening) llListenRemove(Listening);
            Listening = llListen(0, "", MyController, "");
        } else {
            if (MyController != NULL_KEY) {
                llRequestPermissions(MyController, PTC | PTA);
            }
        }
    }
    
    control(key name, integer levels, integer edges)
    {
        if (InAnimation) return;
        
        if (((edges & CONTROL_LBUTTON) == CONTROL_LBUTTON) && ((levels & CONTROL_LBUTTON) == CONTROL_LBUTTON)) {
            llPlaySound("774a5258-7ffc-4b87-ab32-a07e9a0bccd3", 1.0);
            llStartAnimation("apple");
            InAnimation = TRUE;
            llSetTimerEvent(20.0);
        }
    }
    
    listen(integer channel, string name, key id, string message)
    {
        message = llToLower(message);
        
        if (message == "release") {
            llReleaseControls();
            llWhisper(0, "Controls released.  Say 'Feed Apple' to reactivate.");
            return;
        }
        
        if (message == "Feed Apple") {
            InAnimation = FALSE;
            llSetTimerEvent(20.0);}
    }
}